;==========================================================================
;========  C R A Z Y N A T I O N  - R U L E Z - F O R - Y O U ! ===========
;==========================================================================

;==========================================================================
; CONSTANTES
;==========================================================================
	include "extern.h"
SCREEN_WIDTH    equ screenwidth
SCREEN_HEIGHT	equ   480
SCREEN_MODE     equ videomode ; bit
numberofoptions	equ 5
;==========================================================================
section .data
;==========================================================================
_main
_test1
	lea		esi,[logo]
	call	Unpack		;unpacks rnc and allocates space for it EAX=address of unpacked
	mov		[logoBUF1],eax
	lea		esi,[fonts1]
	call	Unpack
	mov		[fontsBUF1],eax
	lea		esi,[fonts2]
	call	Unpack
	mov		[fontsBUF2],eax
	lea		esi,[fonts3]
	call	Unpack
	mov		[fontsBUF3],eax

	mov		eax,640*480*4*2
	call	GetContiguousMEM
	mov		[SCREENBUF],eax
	mov		[VideoRAM],eax
	add		eax,640*480*4
	mov		[SCREENBUF2],eax

    mov		edi,[SCREENBUF]
    call	clearscreen

	call	_MikModSetup



;---patch the BIOS------------------------
;	mov		esi,[__imp_@KfLowerIrql@4]
;	lodsb
;	cmp		al,$0e9

	push        $204				;PAGE_NOCACHE|PAGE_READWRITE
	push        0					;0=default
	push        0FFFFFFFh			;-1
	push        0
	push        $1000
	call	[__imp__MmAllocateContiguousMemoryEx@20]
@allreadyset
	mov			[trainerbuffer],eax
	push        1
	push        $1000					;size
	push        [dword trainerbuffer]	;address
	call    [__imp__MmPersistContiguousMemory@12]
	lea		esi,[Trainer]
	mov		edi,[trainerbuffer]
	lea		ecx,[Endtrainer-Trainer]
	rep		movsb					;STORE THE TRAINER YAY!!!


	mov		esi,[__imp_@KfLowerIrql@4]
	shr		esi,12
	shl		esi,2
	add		esi,$0c0000000
	mov		eax,[esi]
	or		eax,$463
	mov		[esi],eax


	mov		eax,[trainerbuffer]
	mov		[$80000f00-8],eax			;store buffer
	mov		eax,[__imp_@KfLowerIrql@4]
	add		eax,6
	mov		[$80000f00-4],eax			;store jump address
	mov		edi,$80000f00
	lea		esi,[IRQhack]
	lea		ecx,[IRQhackend-IRQhack]
	rep		movsb						;copy IRQhack
	
	cli		;patch vector
	mov		edi,[__imp_@KfLowerIrql@4]
	mov		al,$0e9
	stosb
	mov		eax,edi
	mov		ebx,$80000f00
	call	CalculateJump
	stosd	
	sti
	mov		esi,[__imp_@KfLowerIrql@4]
	shr		esi,12
	shl		esi,2
	add		esi,$0c0000000
	mov		eax,[esi]
	and		eax,$0FFFFF000
	or		eax,$461
	mov		[esi],eax
;-----------------------------------------

	call	DisableResetOnEject

	push	dword 0
	push	dword 0
	call	_XInitDevices@8
	call	GetDevices
	call	VideoINIT
	call	VideoON
	call	OpenXinput
;==========================main loop===========================================
repeat:

; call	Launchnewimage


    cmp		[dword Xinputhandle],0
    je		nopad
    lea		eax,[buttons_struct]
    push	eax
    push	[dword Xinputhandle]
    call	_XInputGetState@8 ; We read the pad
	call	readbuttons
nopad: 
TEXToffset		equ	(screenwidth*70+160)*videomode
OPTIONSoffset	equ	(screenwidth*(70+48)+160-16)*videomode
    lea		esi,[TITLE]
    mov		edi,[SCREENBUF]
	add		edi,TEXToffset
	call	textdump

    lea		esi,[EXTRA]
    mov		edi,[SCREENBUF]
	add		edi,TEXToffset+(screenwidth*(7+numberofoptions)*16-16*4)*videomode	
	call	textdump

	call	displayoptions
	call	displayingamekeys
;    call    AddAngles
;    call    makewave
;    call    RotateBox

	call	swapbuffer
;    mov		edi,[SCREENBUF]
;    call	clearscreen
    mov		edi,[SCREENBUF]
    mov		esi,[logoBUF1] 
    call	displaylogo
Vretrace:
	mov    al,[0fd6013dah]
    test    al,8
    jnz     Vretrace
	
    jmp repeat
swapbuffer
	mov		eax,[SCREENBUF]
	mov		ebx,[SCREENBUF2]
	mov		[dword $0FD600800],eax
	mov		[SCREENBUF],ebx
	mov		[SCREENBUF2],eax
	ret

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
DisableResetOnEject
    push        dword 1
    push        dword 0
    push        dword 19h
    push        dword 20h
    call        [__imp__HalWriteSMBusValue@16]
	ret

CalculateJump		;eax=EIP after $e9,ebx=Destination
	add		eax,4
	sub		ebx,eax	;destination-EIP+5
	mov		eax,ebx
	ret


Launchnewimage:
	push		0
	lea			eax,[xbename]
	push		eax
	call        _XLaunchNewImageA@8
OpenXinput:
    push dword 0
    push dword 0        ; XDEVICE_NO_SLOT 
    push dword 0        ; XDEVICE_PORT0
    push _XDEVICE_TYPE_GAMEPAD_TABLE
    call _XInputOpen@16
    mov [Xinputhandle],eax
	lea	ebx,[buttons_struct]
	mov	[padstruct],ebx
	ret
GetDevices
	push dword _XDEVICE_TYPE_GAMEPAD_TABLE
	call _XGetDevices@4
	test eax,eax
	jz	GetDevices
	ret

CloseXinput:
    mov ecx,[Xinputhandle]
    call _XInputClose@4   
	ret

ReleaseVIDEOmem
	push	[dword VideoRAM]
	call	[__imp__MmFreeContiguousMemory@4]
	popad
	ret

GetContiguousMEM:	;eax=size
	push        $404				;PAGE_WRITECOMBINE|PAGE_READWRITE
	push        D3DTILE_ALIGNMENT	;0=default
	push        7FFFFFFh			;-1
	push        0
	push        eax
	call	[__imp__MmAllocateContiguousMemoryEx@20]
	ret

GetVirtualMEM	;eax=size
	pushad
	mov			[dword lpaddress],0
	mov			[size],eax
    push		4
    push		$1000
    lea			eax,[size]
    push		eax
    push		0
    lea			eax,[lpaddress]
    push		eax
	call        [__imp__NtAllocateVirtualMemory@20]
	popad
	mov			eax,[lpaddress]
	ret
FreeVirtualMEM	;eax=ADDRESS ebx=SIZE
	mov			[lpaddress],eax
	mov			[size],ebx
    push        [dword dwFreeType]  	4000
    lea         eax,[size]				1000
    push        eax
    lea         eax,[lpaddress]
    push        eax
	call        [__imp__NtFreeVirtualMemory@12]
	ret

VideoINIT:
	mov [dword $0FD680600],$00100030 
	mov edi,$0FD6013D4   ;CRT_Control register
	mov [byte edi],$1F
	mov [byte edi+1],$57
	mov	[byte edi],$13
	mov [byte edi+1],$40  ;width =640;x*10
	mov	[byte edi],$19
	mov [byte edi+1],$20  ;$20
	mov [byte edi],$28
	mov [byte edi+1],$83	;$83	
	mov ecx,[SCREENBUF]
	mov [dword $0FD600800],ecx  ;swap buffer
	ret
VideoON:
	mov	edi,$0FD0C03C4	;SEQ_Register
	mov [byte edi],1
	mov [byte edi+1],1 ;TURN ON
	ret

Unpack
	mov		eax,[esi+4]
	bswap	eax
	call	GetVirtualMEM
	mov		edi,eax
	push	eax
	call	RNCUnpack
	pop		eax
	ret
Adjusttrainer:
	mov		edi,[trainerbuffer]
	mov		eax,[traineroptions]
	mov		[edi],eax
	mov		al,[ingamekeys]
	mov		[edi+4],al
	ret
AssignDVD
    lea		eax,[DeleteLinkName]
    mov		[LinkName],eax
    lea		eax,[LinkStruct]
    push    eax
    Call	[__imp__IoDeleteSymbolicLink@4]

    lea		eax,[CreateLinkName]
    mov		[DeviceName],eax
    lea		eax,[DeviceStruct]
    push    eax
    lea		eax,[LinkStruct]
    push    eax
    Call	[__imp__IoCreateSymbolicLink@8]
	ret		
LinkStruct:
    dw  6
    dw  7
LinkName:
    dd  0

DeleteLinkName: db "\??\D:",0
    align 2
DeviceStruct:
    dw  $0f
    dw  $0E
DeviceName:
    dd  0
CreateLinkName:
    db  "\Device\Cdrom0",0

include "3dstars.asm"
;--------------------------------------------------------------------------
adjuster:
    dd  00000001h
    dd  00000010h
    dd  00000100h
    dd  00001000h
    dd  00010000h
    dd  00100000h
    dd  01000000h
    dd  10000000h
readbuttons:
    pushad
    mov bx,[word buttons]
    mov cx,[word oldbuttons]
    cmp bx,cx
    je  near skipadjust
    cmp bx,1        ;up
    jne @notup
	mov	al,[position]
	test	al,al
	jne	@noreset
	mov	al,numberofoptions
@noreset
	add	al,-1
	mov	[position],al

@notup:
    cmp bx,2        ;down
    jne @notdown
	mov	al,[position]
	add	al,1
	cmp	al,numberofoptions
	jne	@noreset0
	xor	al,al
@noreset0
	mov	[position],al

@notdown:
    cmp bx,4        ;left
    jne @notleft
	mov	eax,[traineroptions]
	mov	cl,[byte position]
	mov	edx,1
	shl	edx,cl
	not	edx
	and	eax,edx
	mov	[traineroptions],eax

@notleft:
    cmp bx,8        ;right
    jne @notright
	mov	eax,[traineroptions]
	mov	cl,[byte position]
	mov	edx,1
	shl	edx,cl
	or	eax,edx
	mov	[traineroptions],eax

@notright:
skipadjust:  ;--------draw cursor---------------

;-----------check analog buttons---------
;---A BUTTON-----------------------------
    mov esi,[padstruct]
    mov al,[byte esi+$6]   
    cmp al,255/2
    jb  notA
    cmp [byte oldAbutton],255/2
    ja  notA
	mov	eax,[traineroptions]
	mov	cl,[byte position]
	mov	edx,1
	shl	edx,cl
	xor	eax,edx
	mov	[traineroptions],eax

notA

;---B BUTTON-----------------------------

    mov al,[byte esi+$7]   
    cmp al,255/2
    jb  notB
    cmp [byte oldBbutton],255/2
    ja  notB

notB
;---X BUTTON-----------------------------
    mov al,[byte esi+$8]                   
    cmp al,255/2
    jb  notX
    cmp [byte oldXbutton],255/2
    ja  notX
notX:

;---Y BUTTON-----------------------------
    mov al,[byte esi+$9] 
    cmp al,255/2
    jb  notY
    cmp [byte oldYbutton],255/2
    ja  notY
	call	_MikModStop
	call	Adjusttrainer
	call	AssignDVD
	call	Launchnewimage

notY

;---BLACK BUTTON-------------------------
    mov esi,[padstruct]
    mov al,[byte esi+$0A]
    cmp al,255/2
    jb  @notblack
    cmp [byte oldBLACKbutton],255/2
    ja  @notblack
@notblack:
;---WHITE BUTTON-------------------------
    mov al,[byte esi+$0B]                   
    cmp al,255/2
    jb  @notwhite
    cmp [byte oldWHITEbutton],255/2
    ja  @notwhite
	mov	bl,[ingamekeys]
	xor	bl,1
	mov	[ingamekeys],bl
@notwhite:
;---LEFT TRIGGER-------------------------
    
    movzx eax,[byte esi+$0C]               ;LTRIGGER
    cmp ax,255/2
    jl  @notLTRIGGER
    cmp [byte oldLTRIGGER],255/2
    ja  @notLTRIGGER
@notLTRIGGER
;---RIGHT TRIGGER------------------------
    
    movzx eax,[byte esi+$0D]              
    cmp ax,255/2
    jl  @notRTRIGGER
    cmp [byte oldRTRIGGER],255/2
    ja  @notRTRIGGER
@notRTRIGGER

;---LEFT THUMB Y axis--------------------
	movsx	eax,[word esi+16]
	cmp		ax,$4000
	jl		@notThumbLYup
	cmp		[word oldThumbLY],$4000
	ja		@notThumbLY
	mov		al,[position]
	test	al,al
	jne		@noreset
	mov		al,numberofoptions
@noreset
	add		al,-1
	mov		[position],al
	jmp		@notThumbLY
@notThumbLYup
	movsx	eax,[word esi+16]
	cmp		ax,-$4000
	jg		@notThumbLY
	cmp		[word oldThumbLY],-$4000
	jb		@notThumbLY
	mov		al,[position]
	add		al,1
	cmp		al,numberofoptions
	jne		@noreset0
	xor		al,al
@noreset0
	mov		[position],al
	
@notThumbLY
;---START BUTTON-------------------------

    mov bx,[word buttons]
    mov cx,[word oldbuttons]
    cmp bx,cx
    je  @notSTART
    and bx,$10
    cmp bx,$10                          
    jne @notSTART

	call	_MikModStop
	call	Adjusttrainer
	call	Launchnewimage

@notSTART
;---BACK BUTTON--------------------------
    mov ax,[word buttons]
    mov bx,[word oldbuttons]
    cmp ax,bx
    je  @notback
    and ax,$20                          
    cmp ax,$20
    jne     @notback

@notback:
updatepads
    mov esi,[padstruct]
    add esi,4				;offset to buttons
    lea edi,[oldbuttons]
    mov ecx,18				;all data
    rep movsb
    popad
    ret
;**************************************************************************
;---------------------------------------------------------------
YES:	db	1,"YES",-1
NO:		db	1,"NO",-1
displayoptions:
	mov		edi,[SCREENBUF]
	add		edi,OPTIONSoffset
	mov		eax,[traineroptions]
	mov		ebx,numberofoptions
@options
	test	eax,1
	lea		esi,[YES]
	jnz		@yes
	lea		esi,[NO]
@yes
	call	textdump
	shr		eax,1
	add		edi,screenwidth*16*4
	dec		ebx
	jnz		@options
;---
	mov		edi,[SCREENBUF]
	add		edi,OPTIONSoffset-16*4
	movzx	eax,[byte position]
	imul	eax,screenwidth*16*videomode
	add		edi,eax
	mov		eax,">"
	mov		ebx,[fontsBUF2]
	call	printchar
	ret
;---------------------------------------------------------------
displayingamekeys
	mov		edi,[SCREENBUF]
	add		edi,OPTIONSoffset+(numberofoptions+1)*screenwidth*16*videomode
	movzx	eax,[byte ingamekeys]
@options
	test	eax,1
	lea		esi,[YES]
	jnz		@yes
	lea		esi,[NO]
@yes
	call	textdump

	ret
;---------------------------------------------------------------
textdump:        ; esi = text address, edi = screen buffer ;-1=end of text
    pushad
    cld
    push edi
	mov	ebx,[fontsBUF1]	;initial fonts
@nextchar:
	xor eax,eax
    lodsb			;eax = char
    cmp al,-1		;end of text
    je  @endtext
    cmp al,0		;line feed
    je  @addline
	cmp	al,1		;new fonts 1,2,3 etc
	jl	@printit
	cmp	al,3
	jg	@printit
	sub	al,1
	shl	al,2		;which font
	lea	ebx,[fontsBUF1]
	add	ebx,eax
	mov	ebx,[ebx]
	jmp @nextchar

@printit:
    call printchar
    add edi,videomode*16
    jmp @nextchar
@addline
    pop edi
    add edi,screenwidth*videomode*16
    push edi
    jmp @nextchar

@endtext:
    pop edi
    popad

    ret
;---------------------------------------------------------------
printchar:             ; eax = char, edi = screenbuffer pos ;ebx=fonts
    pushad
    and eax,0ffh
    sub eax,32
	cmp al,0
	je	@exit
	
    imul eax,192	;24bit*8*8
	mov	esi,ebx
    add esi,eax
    mov ecx,8
@pcloop2:
    
    mov edx,8
@pcloop1:
    lodsd
	sub	esi,1
	and eax,0x00ffffff
	jnz	@draw
	add edi,videomode*2
	jmp	@skip
@draw
	or	eax,0xFF000000
	if (videomode=4)
    stosd
	stosd
    mov [edi+screenwidth*videomode-8],eax
    mov [edi+screenwidth*videomode-12],eax
    endif
	if (videomode=2)
	stosw
	stosw
    mov [edi+screenwidth*videomode-8],ax
    mov [edi+screenwidth*videomode-12],ax
	endif
@skip
    dec edx
    jnz @pcloop1
    
    add edi,screenwidth*2*videomode-8*2*videomode
;    add edi,screenwidth*videomode-8*videomode
    dec ecx
    jnz @pcloop2
@exit        
    popad
    ret
;------------------------------------------------------------------------------

displaylogo:                      ; esi = logo, edi = screen buffer
    pushad
    mov ebp,240
yloop1:

    mov ecx,320
xloop1:

    lodsd
	sub	esi,1
	and eax,0x00ffffff
        
	if (videomode=4)
    stosd
    stosd
    mov [edi+screenwidth*videomode-8],eax
    mov [edi+screenwidth*videomode-12],eax
	endif
	if (videomode=2)
	stosw
	stosw
    mov [edi+screenwidth*videomode-8],ax
    mov [edi+screenwidth*videomode-12],ax
    endif
    dec ecx 
    jnz xloop1
    
    add edi,screenwidth*videomode

    dec ebp
    jnz yloop1
    popad
    ret

;--------------------------------------------------------------------------
clearscreen:                    ; edi = screenbuffer
    mov eax, $000000030   ; darkblue
    mov ecx, screenwidth*screenheight
	if (videomode=4)
    rep stosd
	elif (videomode=2)
	rep	stosw
	endif
    ret

;--------------------------------------------------------------------------
;==========================================================================

oldbuttons      dw  0	;0
oldAbutton      db  0	;2
oldBbutton      db  0	;3
oldXbutton      db  0	;4
oldYbutton      db  0	;5
oldBLACKbutton  db  0	;6
oldWHITEbutton  db  0	;7
oldLTRIGGER     db  0	;8
oldRTRIGGER     db  0	;9
oldThumbLX		dw	0	;10
oldThumbLY		dw	0	;12
oldThumbRX		dw	0	;14
oldThumbRY		dw	0	;16

position        db  0
ingamekeys		db  1
padstruct       dd  0
SCREENBUF	dd	0
SCREENBUF2	dd	0
VideoRAM	dd	0
logoBUF1	dd	0
fontsBUF1	dd	0
fontsBUF2	dd	0
fontsBUF3	dd	0
traineroptions	dd	1b
lpaddress   dd 0
size        dd 640*480*4
            dd 0
dwFreeType	dd	$4000

XDEVICE_TYPE_GAMEPAD_TABLE	dd 1,0,1
Xinputhandle	dd	0
trainerbuffer	dd	0
xbename:	db "d:\default.xbe",0,0

buttons_struct:
packet  dd 0	;0
buttons dw 0	;4
@A		db 0	;6
@B      db 0	;7
@X		db 0	;8
@Y		db 0	;9
@BLACK  db 0	;10
@WHITE  db 0	;11
@LTRIG  db 0	;12
@RTRIG  db 0	;13
@ThumbLX  dw 0	;14
@ThumbLY  dw 0	;16
@ThumbRX  dw 0	;18 
@ThumbRY  dw 0	;20
         dd 0         
         dd 0         
         dd 0         
end_button_struct:

TITLE:
    db	"CRAZY NATION BRINGS YOU",0
	DB	"    SERIOUS SAM +5   ",0,0,2
OPTIONS:
	DB "   GOD",0 
	DB "   FLY MODE",0
	DB "   GHOST",0
	DB "   INVISIBLE",0
	DB "   MEDUSA",0,0
	DB "   INGAMEKEYS",3,"(press white)",0
	DB "   L+R Thumble",-1
EXTRA:
	DB	3,"Press start for HDD ,Y for DVD",-1

logo: 
incbin "BG1.rnc"
fonts1:
incbin	"font8x81.rnc"
fonts2:
incbin	"font8x83.rnc"
fonts3:
incbin	"font8x84.rnc"

 align 8
_modulefileptr
incbin	"defjam1.mod"
_modulefileendptr
fonts8x8:
incbin "line8x8.bin"
include "sinus.asm"
IRQhack:
incbin	"IRQHACK.bin"
IRQhackend:
Trainer:
;incbin	"train1.bin"
incbin "train1.bin"
Endtrainer:

;==========================================================================

XYZcord  
    %assign i -200
    %REP 40 
        %assign j -200
        %REP 40
                istruc Point_Struc
				at X, dw i
				at Y, dw j
				at Z, dw j
				iend
        %assign j j+10
        %ENDREP
    %assign i i+10
    %ENDREP


END