//-----------------------------------------------------------------------------
// File: tokei.cpp		v1.01
//
// Desc: CTokei object [app timing shit]
//
// Copyright (c) Huirippu. All rights reserved.
//-----------------------------------------------------------------------------

#include "stdafx.h"
#include <stdio.h>

#include "tokei.h"


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
CTokei::CTokei()
{
    m_fTime           = 0.0f;
    m_fElapsedTime    = 0.0f;
    m_fAppTime        = 0.0f;
    m_fElapsedAppTime = 0.0f;
    m_bPaused         = FALSE;
    m_fFPS            = 0.0f;
    m_strFrameRate[0] = L'\0';
}
//-----------------------------------------------------------------------------
CTokei::~CTokei()
{
}
//-----------------------------------------------------------------------------
LARGE_INTEGER qwTicksPerSec;
LARGE_INTEGER qwTime, qwLastTime, qwElapsedTime;
LARGE_INTEGER qwAppTime, qwElapsedAppTime;
FLOAT			fSecsPerTick;
//-----------------------------------------------------------------------------
void CTokei::Initialize()
{
    // Get the frequency of the timer
//    LARGE_INTEGER qwTicksPerSec;
    QueryPerformanceFrequency( &qwTicksPerSec );
    fSecsPerTick = 1.0f / (FLOAT)qwTicksPerSec.QuadPart;

    // Save the start time
//    LARGE_INTEGER qwTime, qwLastTime, qwElapsedTime;
    QueryPerformanceCounter( &qwTime );
    qwLastTime.QuadPart = qwTime.QuadPart;

//    LARGE_INTEGER qwAppTime, qwElapsedAppTime;
    qwAppTime.QuadPart        = 0;
    qwElapsedTime.QuadPart    = 0;
    qwElapsedAppTime.QuadPart = 0;
}
//-----------------------------------------------------------------------------
void CTokei::Update()
{
	// Get the current time (keep in LARGE_INTEGER format for precision)
	QueryPerformanceCounter(&qwTime);
	qwElapsedTime.QuadPart = qwTime.QuadPart - qwLastTime.QuadPart;
	qwLastTime.QuadPart    = qwTime.QuadPart;
	if( m_bPaused )
		qwElapsedAppTime.QuadPart = 0;
	else
		qwElapsedAppTime.QuadPart = qwElapsedTime.QuadPart;
	qwAppTime.QuadPart    += qwElapsedAppTime.QuadPart;

	// Store the current time values as floating point
	m_fTime           = fSecsPerTick * ((FLOAT)(qwTime.QuadPart));
	m_fElapsedTime    = fSecsPerTick * ((FLOAT)(qwElapsedTime.QuadPart));
	m_fAppTime        = fSecsPerTick * ((FLOAT)(qwAppTime.QuadPart));
	m_fElapsedAppTime = fSecsPerTick * ((FLOAT)(qwElapsedAppTime.QuadPart));

	// Compute the FPS (frames per second) once per second
	static FLOAT fLastTime = 0.0f;
	static DWORD dwFrames  = 0L;
	dwFrames++;

	if( m_fTime - fLastTime > 1.0f )
	{
		m_fFPS    = dwFrames / ( m_fTime - fLastTime );
		fLastTime = m_fTime;
		dwFrames  = 0L;
		swprintf( m_strFrameRate, L"%0.02f fps", m_fFPS );
	}
}
//-----------------------------------------------------------------------------
