//-----------------------------------------------------------------------------
// File: app.cpp		v1.04
//
// Desc: 
//
// Copyright (c) Huirippu. All rights reserved.
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include <stdio.h>

#include "tokei.h"
#include "gamepad.h"
#include "text.h"

#include "HeightMap.h"

//#include "Input.h"

#include "PickUp.h"


#include "Camera.h"

#include "ViewPort.h"

#include "Ship.h"

#include "Player.h"

	#include "Shadow.h"
	#include "Altimeter.h"
	#include "FuelGuage.h"
	#include "GameOver.h"
#include "UniqGeom.h"

#include "Game.h"


	#include "LandScape.h"
	#include "CloudBox.h"
	#include "SkyBox.h"
	#include "ShipModel.h"
	#include "FuelTank.h"
#include "SharedGeom.h"


#include "Title.h"


#include "GameMgr.h"



#include "app.h"


//#define CHEAT_MODE
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
CApp::CApp()
{
	m_pTokei = new CTokei();
}
//-----------------------------------------------------------------------------
CApp::~CApp()
{
	delete m_pTokei;
}
//-----------------------------------------------------------------------------
HRESULT CApp::Init()
{
	if( (m_pD3D = Direct3DCreate8(D3D_SDK_VERSION)) == NULL )
		return E_FAIL;

	// Create the Direct3D device.
	D3DPRESENT_PARAMETERS		d3dpp;
	ZeroMemory(&d3dpp, sizeof(d3dpp));
	d3dpp.BackBufferWidth					= 640;
	d3dpp.BackBufferHeight					= 480;
	d3dpp.BackBufferFormat					= D3DFMT_X8R8G8B8;
	d3dpp.BackBufferCount					= 1;
	d3dpp.SwapEffect						= D3DSWAPEFFECT_DISCARD;
	d3dpp.EnableAutoDepthStencil			= TRUE;
	d3dpp.AutoDepthStencilFormat			= D3DFMT_D16;
	d3dpp.FullScreen_PresentationInterval	= D3DPRESENT_INTERVAL_IMMEDIATE;
	if(FAILED(m_pD3D->CreateDevice(	0, D3DDEVTYPE_HAL, NULL				,
									D3DCREATE_HARDWARE_VERTEXPROCESSING	,
									&d3dpp, &m_pd3dDevice				)))
		return E_FAIL;

	if(g_GamePads.Initialise())
		return E_FAIL;
	m_pTokei->Initialize();
	if(FAILED(m_Font.Create("D:\\Arial16.xpr")))
		return E_FAIL;

	// Setup the WORLD and PROJEXION(const) matrix
	D3DXMATRIX matWorld;
	D3DXMatrixIdentity(&matWorld);
	m_pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
	D3DXMATRIX	matProj;
	D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 4.0f/3.0f, 2.0f, 500.0f );
	m_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );


	m_GameMgr.Initialise(0);
	m_GameMgr.InitDeviceObjects(m_pd3dDevice);

			IDirect3DSurface8* pISurface;
			m_pd3dDevice->GetRenderTarget(&pISurface);
			D3DSURFACE_DESC SurfaceDesc;
			pISurface->GetDesc(&SurfaceDesc);

	m_GameMgr.RestoreDeviceObjects(&SurfaceDesc);

			pISurface->Release();

	return S_OK;
}
//-----------------------------------------------------------------------------
VOID CApp::ReadInput()
{
	m_pTokei->Update();
	g_GamePads.ReadDevices();
	CGamePad *pPad = &(g_GamePads.m_GamePads[0]);

////////////
// REBOOT //
////////////
	if(	pPad->bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]	&&
		pPad->bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]	&&
		pPad->m_bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]	)
	{
		LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
		XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
	}
///////////
// PAUSE //
///////////

	{
		//////////////////////
		// Handle DEAD-ZONE //
		//////////////////////
		struct {
			FLOAT	m_fX1;
			FLOAT	m_fY1;
			FLOAT	m_fX2;
			FLOAT	m_fY2;
		} MoveStruct;
		const FLOAT				fDZ = 0.4f;

		if(pPad->m_fX1 > 0.0f)
			MoveStruct.m_fX1 = pPad->m_fX1 <  fDZ ? 0.0f : pPad->m_fX1 - fDZ;
		else
			MoveStruct.m_fX1 = pPad->m_fX1 > -fDZ ? 0.0f : pPad->m_fX1 + fDZ;
		if(pPad->m_fY1 > 0.0f)
			MoveStruct.m_fY1 = pPad->m_fY1 <  fDZ ? 0.0f : pPad->m_fY1 - fDZ;
		else
			MoveStruct.m_fY1 = pPad->m_fY1 > -fDZ ? 0.0f : pPad->m_fY1 + fDZ;
		if(pPad->m_fX2 > 0.0f)
			MoveStruct.m_fX2 = pPad->m_fX2 <  fDZ ? 0.0f : pPad->m_fX2 - fDZ;
		else
			MoveStruct.m_fX2 = pPad->m_fX2 > -fDZ ? 0.0f : pPad->m_fX2 + fDZ;
		if(pPad->m_fY2 > 0.0f)
			MoveStruct.m_fY2 = pPad->m_fY2 <  fDZ ? 0.0f : pPad->m_fY2 - fDZ;
		else
			MoveStruct.m_fY2 = pPad->m_fY2 > -fDZ ? 0.0f : pPad->m_fY2 + fDZ;

		pPad->m_fX1 = MoveStruct.m_fX1;
		pPad->m_fY1 = MoveStruct.m_fY1;
		pPad->m_fX2 = MoveStruct.m_fX2;
		//////////////////////
		// End of DEAD-ZONE //
		//////////////////////

		///////////////
		// PUSHING ? //
		///////////////
	}
}
//-----------------------------------------------------------------------------
VOID CApp::FrameMove()
{
	CGamePad *pPad = &(g_GamePads.m_GamePads[0]);
	m_GameMgr.FrameMove(m_pTokei->m_fElapsedTime, pPad);
}
//-----------------------------------------------------------------------------
void CApp::Render()
{
	m_GameMgr.Render();
	
//////////
// TEXT //
//////////
	m_Font.Begin();
		m_Font.DrawText( 48, 36, 0x7F00ffff,  L"FuiRiPpu@softhome.net" );
		m_Font.DrawText( 592, 38, 0x3fffff00, m_pTokei->m_strFrameRate, XBFONT_RIGHT );
	m_Font.End();

	m_pd3dDevice->Present(NULL, NULL, NULL, NULL);
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/* TITLE HEADER
 *
	m_Font.Begin();
		m_Font.DrawText( 48, 36, 0x7F000000,  L"Konbanwa by Phil" );
	m_Font.End();
*/
/* 4x4 matrix DUMP
 *
		WCHAR str[80];
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f"	,
					mat._11, mat._12, mat._13, mat._14				);
		m_Font.DrawText(48, 68, 0xff000000, str);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f"	,
					mat._21, mat._22, mat._23, mat._24				);
		m_Font.DrawText(48, 100, 0xff000000, str);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f"	,
					mat._31, mat._32, mat._33, mat._34				);
		m_Font.DrawText(48, 132, 0xff000000, str);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f"	,
					mat._41, mat._42, mat._43, mat._44				);
		m_Font.DrawText(48, 164, 0xff000000, str);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f"					,
					g_GamePads.m_GamePads[0].m_fY1, g_GamePads.m_GamePads[0].m_fX2	,
					g_GamePads.m_GamePads[0].m_fY2, g_GamePads.m_GamePads[0].m_fX1	);
		m_Font.DrawText(48, 196, 0xff000000, str);
*/
/* 3D vector DUMP
 *
		WCHAR str[80];
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f"			,
					m_vViewAngle.x, m_vViewAngle.y, m_vViewAngle.z	);
		m_Font.DrawText(48, 68, 0xff000000, str);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f"			,
					m_vCameraPos.x, m_vCameraPos.y, m_vCameraPos.z	);
		m_Font.DrawText(48, 100, 0xff000000, str);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f"	,
					m_vLookat.x, m_vLookat.y, m_vLookat.z	);
		m_Font.DrawText(48, 132, 0xff000000, str);
*/
/* D3DMATERIAL8 dump
 *
		D3DCOLORVALUE	*pColVal = &(m_pmtrl->Diffuse);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f diff"	,
					pColVal->r, pColVal->g, pColVal->b, pColVal->a		);
		m_Font.DrawText(48, 100, 0xff000000, str);
		pColVal = &(m_pmtrl->Ambient);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f ambi"	,
					pColVal->r, pColVal->g, pColVal->b, pColVal->a		);
		m_Font.DrawText(48, 132, 0xff000000, str);
		pColVal = &(m_pmtrl->Specular);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f spec"	,
					pColVal->r, pColVal->g, pColVal->b, pColVal->a		);
		m_Font.DrawText(48, 164, 0xff000000, str);
		pColVal = &(m_pmtrl->Emissive);
		swprintf(	str, L"% #09.4f  % #09.4f  % #09.4f  % #09.4f emis"	,
					pColVal->r, pColVal->g, pColVal->b, pColVal->a		);
		m_Font.DrawText(48, 196, 0xff000000, str);
		swprintf(	str, L"% #09.4f pow"	,
					m_pmtrl->Power			);
		m_Font.DrawText(48, 228, 0xff000000, str);
*/
/* GAMEPAD dump
 *
		CGamePad	*pPad = &(g_GamePads.m_GamePads[0]);
		swprintf(str, L"% #09.4f  % #09.4f", pPad->m_fY1, pPad->m_fX1);
		m_Font.DrawText(48, 100, 0xffac00ac, str);
		swprintf(str, L"% #09.4f  % #09.4f", pPad->m_fY2, pPad->m_fX2);
		m_Font.DrawText(48, 132, 0xffac00ac, str);

		swprintf(str, L"% .5d  % .5d", pPad->sThumbLY, pPad->sThumbLX);
		m_Font.DrawText(48, 164, 0xffac00ac, str);
		swprintf(str, L"% .5d  % .5d", pPad->sThumbRY, pPad->sThumbRX);
		m_Font.DrawText(48, 196, 0xffac00ac, str);
*/
