//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>
#include "port.h"

#include "CloudBox.h"
#include ".\SkyBox.h"

#include "DxObjects.h"
//-----------------------------------------------------------------------------
#define TEX_OFFSET	(1.0f / 512.0f)
//-----------------------------------------------------------------------------

CSkyBox::CSkyBox(void)
{
	m_dwFVF			= D3DFVF_XYZ|D3DFVF_TEX1;
	m_pVB			= NULL;
	for(int i=0; i < NUM_SKY_TEXTURES; ++i)
		m_apTextures[i] = NULL;
	D3DXMatrixIdentity(&m_matWorld);

	m_bRender = false;
}

//-----------------------------------------------------------------------------

CSkyBox::~CSkyBox(void)
{
}

//-----------------------------------------------------------------------------

HRESULT CSkyBox::InitDeviceObjects()
{
	HRESULT hr;
	if((hr = CreateVertexBuffer()) != S_OK)
	{
//        MessageBox(NULL, "SkyBox VBuf creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}

	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

	if((hr = D3DXCreateTextureFromFile( pDevice, "D:\\skyfront.jpg", &m_apTextures[0])) != S_OK)
	{
//        MessageBox(NULL, "SkyBox texture creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = D3DXCreateTextureFromFile( pDevice, "D:\\skyleft.jpg", &m_apTextures[1])) != S_OK)
	{
//        MessageBox(NULL, "SkyBox texture creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = D3DXCreateTextureFromFile( pDevice, "D:\\skyback.jpg", &m_apTextures[2])) != S_OK)
	{
//        MessageBox(NULL, "SkyBox texture creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = D3DXCreateTextureFromFile( pDevice, "D:\\skyright.jpg", &m_apTextures[3])) != S_OK)
	{
//        MessageBox(NULL, "SkyBox texture creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = D3DXCreateTextureFromFile( pDevice, "D:\\skyup.jpg", &m_apTextures[4])) != S_OK)
	{
//        MessageBox(NULL, "SkyBox texture creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = D3DXCreateTextureFromFile( pDevice, "D:\\skydown.jpg", &m_apTextures[5])) != S_OK)
	{
//        MessageBox(NULL, "SkyBox texture creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}

	if((hr = m_CloudBox.InitDeviceObjects()) != S_OK)
		return(hr);

	m_bRender = true;

	return S_OK;
}

//-----------------------------------------------------------------------------

void CSkyBox::DeleteDeviceObjects()
{
	SAFE_RELEASE( m_apTextures[0] );
	SAFE_RELEASE( m_apTextures[1] );
	SAFE_RELEASE( m_apTextures[2] );
	SAFE_RELEASE( m_apTextures[3] );
	SAFE_RELEASE( m_apTextures[4] );
	SAFE_RELEASE( m_apTextures[5] );
	SAFE_RELEASE(m_pVB);

	m_bRender=false;

	m_CloudBox.DeleteDeviceObjects();
}

//-----------------------------------------------------------------------------

void CSkyBox::Render() const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		// Turn off Z-BUF_READ
		pDevice->SetRenderState( D3DRS_ZFUNC, D3DCMP_ALWAYS );

		pDevice->SetStreamSource(0, m_pVB, sizeof(CUSTOMVERTEX));
		pDevice->SetVertexShader(m_dwFVF);
		pDevice->SetTransform(D3DTS_WORLD, &m_matWorld);

		pDevice->SetTexture(0, m_apTextures[0]);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, 2);
		pDevice->SetTexture(0, m_apTextures[1]);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 6, 2);
		pDevice->SetTexture(0, m_apTextures[2]);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 12, 2);
		pDevice->SetTexture(0, m_apTextures[3]);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 18, 2);
		pDevice->SetTexture(0, m_apTextures[4]);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 24, 2);
		pDevice->SetTexture(0, m_apTextures[5]);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 30, 2);

		m_CloudBox.Render();
		pDevice->SetRenderState( D3DRS_ZFUNC, D3DCMP_LESSEQUAL );
	}
}

//-----------------------------------------------------------------------------

HRESULT CSkyBox::CreateVertexBuffer()
{
	HRESULT hr;
	if((hr = CDxObjects::GetDevice()->CreateVertexBuffer
							(	NUM_VERTS * sizeof(CSkyBox::CUSTOMVERTEX)	,
								0, m_dwFVF, D3DPOOL_MANAGED, &m_pVB)) != S_OK)
		return(hr);

	CSkyBox::CUSTOMVERTEX* pVertices;
	if((hr = m_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 )) != S_OK)
		return(hr);

	// Anti-clockwise triangle list..
	float fVerts[NUM_VERTS * 5] = {	 1.0f, -1.0f,  1.0f, 1.0f - TEX_OFFSET, 1.0f - TEX_OFFSET,	// Front
									 1.0f,  1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									-1.0f, -1.0f,  1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,

									-1.0f, -1.0f,  1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									 1.0f,  1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									-1.0f,  1.0f,  1.0f, 0.0f + TEX_OFFSET, 0.0f + TEX_OFFSET,


									-1.0f, -1.0f,  1.0f, 1.0f - TEX_OFFSET, 1.0f - TEX_OFFSET,	// Left
									-1.0f,  1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									-1.0f, -1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,

									-1.0f, -1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									-1.0f,  1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									-1.0f,  1.0f, -1.0f, 0.0f + TEX_OFFSET, 0.0f + TEX_OFFSET,


									-1.0f, -1.0f, -1.0f, 1.0f - TEX_OFFSET, 1.0f - TEX_OFFSET,	// Back
									-1.0f,  1.0f, -1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									 1.0f, -1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,

									 1.0f, -1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									-1.0f,  1.0f, -1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									 1.0f,  1.0f, -1.0f, 0.0f + TEX_OFFSET, 0.0f + TEX_OFFSET,


									 1.0f, -1.0f, -1.0f, 1.0f - TEX_OFFSET, 1.0f - TEX_OFFSET,	// Right
									 1.0f,  1.0f, -1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									 1.0f, -1.0f,  1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,

									 1.0f, -1.0f,  1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									 1.0f,  1.0f, -1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									 1.0f,  1.0f,  1.0f, 0.0f + TEX_OFFSET, 0.0f + TEX_OFFSET,


									 1.0f,  1.0f,  1.0f, 0.0f + TEX_OFFSET, 0.0f + TEX_OFFSET,	// Top
									 1.0f,  1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									-1.0f,  1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,

									-1.0f,  1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									 1.0f,  1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									-1.0f,  1.0f, -1.0f, 1.0f - TEX_OFFSET, 1.0f - TEX_OFFSET,


									 1.0f, -1.0f, -1.0f, 1.0f - TEX_OFFSET, 1.0f - TEX_OFFSET,	// Bottom
									 1.0f, -1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									-1.0f, -1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,

									-1.0f, -1.0f, -1.0f, 0.0f + TEX_OFFSET, 1.0f - TEX_OFFSET,
									 1.0f, -1.0f,  1.0f, 1.0f - TEX_OFFSET, 0.0f + TEX_OFFSET,
									-1.0f, -1.0f,  1.0f, 0.0f + TEX_OFFSET, 0.0f + TEX_OFFSET};

	float fScaleFactor = 4.0f;
	for(int i=0; i < NUM_VERTS; ++i)
	{
		pVertices[i].position.x = fVerts[i*5] * fScaleFactor;
		pVertices[i].position.y = fVerts[i*5 + 1] * fScaleFactor;
		pVertices[i].position.z = fVerts[i*5 + 2] * fScaleFactor;
		pVertices[i].tu			= fVerts[i*5 + 3];
		pVertices[i].tv			= fVerts[i*5 + 4];
	}
	m_pVB->Unlock();

	return S_OK;
}

//-----------------------------------------------------------------------------
