#pragma once

class CGame;

class CPickUp
{
public:
	CPickUp(void);
	~CPickUp(void);

	void	UpdatePosition(const CHeightMap &HeightMap, CGame &Game1,
							CGame *pGame2, float fTime);

	const D3DXVECTOR3&	GetPosition() const;
	float				GetRotation() const;

private:
	// const parameters
	float			m_fFuelLevel;

	float			m_fMinAltitude;
	float			m_fMaxAltitude;

	float			m_fAttractDistance;
	float			m_fCollectDistance;
	float			m_fCollectSpeed;


	// state flag - 0 = floating
	//				n = player# currently attracting
	int				m_nPickingUp;			


	D3DXVECTOR3		m_vecPos;
	float			m_fRotation;
	D3DXMATRIX		m_matWorld;


	bool	MoveTowardShip(const D3DXVECTOR3& vecShip, float fDistance);
	bool	CollisionTest(const D3DXVECTOR3& vecShip, float fCollideDistance);
	void	SpawnInNewPosition(const CHeightMap &HeightMap);
};
