#include <stdio.h>
#include <assert.h>
//#include <d3dx9.h>
#include <xtl.h>

#include ".\heightmap.h"
//-----------------------------------------------------------------------------
#define DATA_FILE	"landscape.lnd"
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CHeightMap::CHeightMap(void)
{
	m_nSizeZ = 0;
	m_nSizeX = 0;
	m_pData = NULL;
}

//-----------------------------------------------------------------------------

CHeightMap::~CHeightMap(void)
{
	if(m_pData)
		free(m_pData);
}

//-----------------------------------------------------------------------------

HRESULT CHeightMap::Initialise()
{
//
// HeightMap runs from near-left to far-right in columns then rows...
//
//  z        ...-4095
//  ^  |  |  |    |      (for 64x64 heightmap)
//  |  2-66-131-  .
//  |  1-65-130-  .
//  |  0-64-129-  .
//
//       ---->x
//
/*
	///////////////
	// Open file //
	///////////////
	FILE *pFile = fopen(DATA_FILE, "r");
	if(!pFile)
		return(-1l);

	//////////////////////////////////////
	// Read size of landscape (z and x) //
	//////////////////////////////////////
	if(fscanf(pFile, " %d", &m_nSizeZ) == EOF)
		return(-2);
	if(fscanf(pFile, " %d", &m_nSizeX) == EOF)
		return(-3);

	/////////////////////////////////////
	// Allocate memory for height data //
	/////////////////////////////////////
	m_pData = new float[m_nSizeZ * m_nSizeX];

	////////////////////
	// Read data here //
	////////////////////
	float *pCur = m_pData;
	for(int x=0; x < m_nSizeX; ++x)
		for(int z=0; z < m_nSizeZ; ++z)
			if(fscanf(pFile, " %f", pCur++) == EOF)
				return(-4);

	////////////////////
	// Close the file //
	////////////////////
	if(fclose(pFile) == EOF)
		return(-5);
*/
	m_nSizeX = 64;
	m_nSizeZ = 64;
	m_pData = new float[64 * 64];

	float data[] = {0.128859f, 0.128087f, 0.127170f, 0.124846f, 0.123213f, 0.121212f, 0.117764f, 0.115640f, 0.112482f, 0.108380f, 0.103161f, 0.096824f, 0.091146f, 0.085750f, 0.079376f, 0.075548f, 0.074628f, 0.072609f, 0.071000f, 0.068905f, 0.066772f, 0.066013f, 0.066099f, 0.066108f, 0.066114f, 0.064758f, 0.062913f, 0.061362f, 0.060735f, 0.060866f, 0.062058f, 0.063385f, 0.064887f, 0.068209f, 0.072366f, 0.076119f, 0.081098f, 0.084772f, 0.088142f, 0.093252f, 0.097868f, 0.102360f, 0.106495f, 0.110461f, 0.112287f, 0.114773f, 0.117570f, 0.120206f, 0.122940f, 0.124561f, 0.126665f, 0.126946f, 0.127137f, 0.127515f, 0.128781f, 0.130143f, 0.130509f, 0.132673f, 0.132973f, 0.133201f, 0.133273f, 0.133333f, 0.132005f, 0.129622f 
, 0.126861f, 0.123878f, 0.121187f, 0.117813f, 0.116253f, 0.114497f, 0.111367f, 0.109494f, 0.106615f, 0.102894f, 0.098026f, 0.092010f, 0.086773f, 0.081750f, 0.075761f, 0.072228f, 0.071476f, 0.069648f, 0.068330f, 0.066524f, 0.064583f, 0.063907f, 0.064212f, 0.064217f, 0.064222f, 0.063018f, 0.061504f, 0.060430f, 0.060288f, 0.060810f, 0.062102f, 0.063611f, 0.065372f, 0.068732f, 0.072944f, 0.076643f, 0.081401f, 0.084837f, 0.087494f, 0.091907f, 0.095931f, 0.099701f, 0.103011f, 0.106387f, 0.107853f, 0.110087f, 0.112412f, 0.114800f, 0.117734f, 0.119571f, 0.122164f, 0.122896f, 0.123394f, 0.124523f, 0.126189f, 0.128178f, 0.129178f, 0.131618f, 0.132270f, 0.132869f, 0.132970f, 0.132989f, 0.132020f, 0.129920f
, 0.123679f, 0.117899f, 0.112937f, 0.108230f, 0.106779f, 0.105352f, 0.102650f, 0.101120f, 0.098626f, 0.095415f, 0.091035f, 0.085477f, 0.080847f, 0.076336f, 0.070887f, 0.067760f, 0.067226f, 0.065650f, 0.064697f, 0.063242f, 0.061538f, 0.060947f, 0.061510f, 0.061490f, 0.061478f, 0.060474f, 0.059392f, 0.058935f, 0.059415f, 0.060459f, 0.061897f, 0.063701f, 0.065947f, 0.069373f, 0.073725f, 0.077427f, 0.081979f, 0.085532f, 0.087906f, 0.091681f, 0.095146f, 0.098397f, 0.101097f, 0.103858f, 0.105042f, 0.107105f, 0.108930f, 0.110928f, 0.114029f, 0.116095f, 0.119215f, 0.120356f, 0.121025f, 0.122806f, 0.124598f, 0.126956f, 0.128384f, 0.130726f, 0.131522f, 0.132325f, 0.132278f, 0.132025f, 0.131443f, 0.129757f
, 0.119432f, 0.110654f, 0.103249f, 0.097123f, 0.095813f, 0.094763f, 0.092553f, 0.091422f, 0.089374f, 0.086751f, 0.082940f, 0.077924f, 0.074000f, 0.070084f, 0.065266f, 0.062615f, 0.062327f, 0.061041f, 0.060494f, 0.059423f, 0.057984f, 0.057483f, 0.058319f, 0.058268f, 0.058235f, 0.057460f, 0.056866f, 0.057098f, 0.058268f, 0.059898f, 0.061509f, 0.063672f, 0.066537f, 0.070065f, 0.074607f, 0.078354f, 0.082717f, 0.086620f, 0.089015f, 0.092220f, 0.095173f, 0.098061f, 0.100322f, 0.102476f, 0.103439f, 0.105382f, 0.106708f, 0.108235f, 0.111453f, 0.113730f, 0.117353f, 0.118839f, 0.119567f, 0.121882f, 0.123592f, 0.126113f, 0.127790f, 0.129761f, 0.130535f, 0.131385f, 0.131039f, 0.130328f, 0.130082f, 0.128829f
, 0.114241f, 0.102652f, 0.092949f, 0.085518f, 0.084372f, 0.083715f, 0.082018f, 0.081303f, 0.079722f, 0.077711f, 0.074495f, 0.070051f, 0.066864f, 0.063570f, 0.059415f, 0.057262f, 0.057230f, 0.056244f, 0.056112f, 0.055432f, 0.054270f, 0.053864f, 0.054967f, 0.054893f, 0.054844f, 0.054310f, 0.054216f, 0.055139f, 0.056998f, 0.059214f, 0.061004f, 0.063537f, 0.067066f, 0.070741f, 0.075489f, 0.079303f, 0.083501f, 0.087859f, 0.090457f, 0.093171f, 0.095669f, 0.098306f, 0.100258f, 0.101844f, 0.102630f, 0.104476f, 0.105332f, 0.106369f, 0.109637f, 0.112072f, 0.116110f, 0.117860f, 0.118556f, 0.121270f, 0.122754f, 0.125283f, 0.127056f, 0.128486f, 0.129113f, 0.129869f, 0.129097f, 0.127785f, 0.127747f, 0.126835f
, 0.108223f, 0.094399f, 0.082868f, 0.074440f, 0.073479f, 0.073194f, 0.071984f, 0.071666f, 0.070530f, 0.069100f, 0.066453f, 0.062557f, 0.060071f, 0.057372f, 0.053849f, 0.052173f, 0.052384f, 0.051684f, 0.051946f, 0.051635f, 0.050744f, 0.050437f, 0.051778f, 0.051705f, 0.051657f, 0.051357f, 0.051732f, 0.053279f, 0.055757f, 0.058491f, 0.060450f, 0.063315f, 0.067460f, 0.071336f, 0.076266f, 0.080157f, 0.084218f, 0.089012f, 0.091869f, 0.094181f, 0.096292f, 0.098744f, 0.100473f, 0.101563f, 0.102199f, 0.103943f, 0.104388f, 0.104975f, 0.108210f, 0.110715f, 0.115021f, 0.116930f, 0.117530f, 0.120486f, 0.121669f, 0.124102f, 0.125846f, 0.126664f, 0.127062f, 0.127594f, 0.126294f, 0.124283f, 0.124247f, 0.123471f
, 0.101499f, 0.086400f, 0.073831f, 0.064916f, 0.064153f, 0.064188f, 0.063393f, 0.063414f, 0.062659f, 0.061726f, 0.059567f, 0.056141f, 0.054254f, 0.052065f, 0.049083f, 0.047819f, 0.048240f, 0.047786f, 0.048386f, 0.048395f, 0.047754f, 0.047554f, 0.049081f, 0.049048f, 0.049025f, 0.048937f, 0.049704f, 0.051739f, 0.054697f, 0.057817f, 0.059912f, 0.063022f, 0.067641f, 0.071784f, 0.076838f, 0.080795f, 0.084754f, 0.089837f, 0.092888f, 0.094898f, 0.096700f, 0.098988f, 0.100538f, 0.101235f, 0.101731f, 0.103341f, 0.103461f, 0.103702f, 0.106802f, 0.109258f, 0.113619f, 0.115564f, 0.116025f, 0.119052f, 0.119922f, 0.122203f, 0.123819f, 0.124058f, 0.124187f, 0.124379f, 0.122475f, 0.119710f, 0.119393f, 0.118435f
, 0.084615f, 0.071094f, 0.059842f, 0.052149f, 0.051857f, 0.052315f, 0.052068f, 0.052535f, 0.052279f, 0.052003f, 0.050489f, 0.047680f, 0.046580f, 0.045064f, 0.042793f, 0.042077f, 0.042783f, 0.042656f, 0.043713f, 0.044161f, 0.043925f, 0.043956f, 0.045646f, 0.045841f, 0.045971f, 0.046209f, 0.047460f, 0.049929f, 0.053297f, 0.056675f, 0.058926f, 0.062184f, 0.067257f, 0.072357f, 0.077433f, 0.081500f, 0.085384f, 0.090492f, 0.093728f, 0.095535f, 0.097031f, 0.099154f, 0.100699f, 0.101137f, 0.101478f, 0.102748f, 0.102651f, 0.102699f, 0.105138f, 0.107041f, 0.110646f, 0.112153f, 0.112136f, 0.114567f, 0.114716f, 0.116461f, 0.117359f, 0.116458f, 0.115824f, 0.114727f, 0.111057f, 0.106244f, 0.103900f, 0.100946f
, 0.054119f, 0.047748f, 0.042386f, 0.039085f, 0.039619f, 0.040498f, 0.040787f, 0.041698f, 0.041940f, 0.042314f, 0.041452f, 0.039270f, 0.038949f, 0.038111f, 0.036552f, 0.036397f, 0.037394f, 0.037596f, 0.039103f, 0.039989f, 0.040270f, 0.040670f, 0.042357f, 0.043070f, 0.043541f, 0.044179f, 0.045840f, 0.048363f, 0.051732f, 0.054923f, 0.057291f, 0.060428f, 0.065722f, 0.072749f, 0.077650f, 0.081909f, 0.085884f, 0.090691f, 0.094420f, 0.096562f, 0.098093f, 0.100416f, 0.102620f, 0.103327f, 0.103671f, 0.104412f, 0.104524f, 0.104762f, 0.105649f, 0.106118f, 0.107478f, 0.107592f, 0.106448f, 0.106887f, 0.105536f, 0.105862f, 0.104850f, 0.101905f, 0.099619f, 0.095664f, 0.088563f, 0.079897f, 0.072777f, 0.065002f
, 0.028181f, 0.027934f, 0.027575f, 0.027965f, 0.029160f, 0.030395f, 0.031125f, 0.032414f, 0.033081f, 0.034002f, 0.033720f, 0.032110f, 0.032446f, 0.032207f, 0.031271f, 0.031638f, 0.032894f, 0.033383f, 0.035260f, 0.036517f, 0.037295f, 0.038079f, 0.039684f, 0.040949f, 0.041794f, 0.042804f, 0.044759f, 0.047127f, 0.050274f, 0.053071f, 0.055470f, 0.058351f, 0.063392f, 0.071256f, 0.075918f, 0.080340f, 0.084534f, 0.089027f, 0.093207f, 0.095939f, 0.097822f, 0.100117f, 0.102214f, 0.102678f, 0.102601f, 0.102544f, 0.102461f, 0.102362f, 0.101516f, 0.100295f, 0.099350f, 0.097979f, 0.095763f, 0.094152f, 0.091450f, 0.090183f, 0.087394f, 0.082954f, 0.079252f, 0.073187f, 0.064215f, 0.053779f, 0.043895f, 0.033569f
, 0.013465f, 0.014655f, 0.015377f, 0.016720f, 0.018280f, 0.019886f, 0.021084f, 0.022766f, 0.023875f, 0.025368f, 0.025681f, 0.024650f, 0.025673f, 0.026050f, 0.025755f, 0.026649f, 0.028169f, 0.028954f, 0.031222f, 0.032866f, 0.034152f, 0.035322f, 0.036858f, 0.038685f, 0.039907f, 0.041301f, 0.043578f, 0.045826f, 0.048787f, 0.051223f, 0.053682f, 0.056331f, 0.060650f, 0.067199f, 0.071763f, 0.076419f, 0.081154f, 0.085701f, 0.090347f, 0.094026f, 0.096824f, 0.098585f, 0.098915f, 0.097881f, 0.096370f, 0.094916f, 0.093471f, 0.091656f, 0.088927f, 0.085735f, 0.082889f, 0.080175f, 0.077131f, 0.073877f, 0.070228f, 0.067294f, 0.063330f, 0.058478f, 0.053947f, 0.047521f, 0.039833f, 0.031802f, 0.023666f, 0.015959f
, 0.004545f, 0.005361f, 0.005646f, 0.006805f, 0.008504f, 0.010435f, 0.012023f, 0.014055f, 0.015563f, 0.017554f, 0.018444f, 0.017997f, 0.019624f, 0.020588f, 0.020895f, 0.022338f, 0.024116f, 0.025177f, 0.027770f, 0.029755f, 0.031519f, 0.033069f, 0.034519f, 0.036842f, 0.038415f, 0.040156f, 0.042663f, 0.044691f, 0.047352f, 0.049334f, 0.051727f, 0.054064f, 0.057306f, 0.061540f, 0.065920f, 0.070679f, 0.075863f, 0.080373f, 0.085222f, 0.089715f, 0.093381f, 0.094244f, 0.092050f, 0.089017f, 0.085811f, 0.082883f, 0.079790f, 0.075919f, 0.071465f, 0.066419f, 0.062028f, 0.058187f, 0.054558f, 0.050008f, 0.045758f, 0.041321f, 0.036614f, 0.031992f, 0.027071f, 0.021210f, 0.016279f, 0.012456f, 0.008076f, 0.005084f
, 0.000293f, 0.000533f, 0.000535f, 0.001361f, 0.002830f, 0.004925f, 0.006625f, 0.008847f, 0.010588f, 0.012807f, 0.014185f, 0.014293f, 0.016202f, 0.017623f, 0.018364f, 0.020400f, 0.022417f, 0.023680f, 0.026368f, 0.028522f, 0.030575f, 0.032392f, 0.033804f, 0.036216f, 0.037926f, 0.039835f, 0.042302f, 0.043998f, 0.046221f, 0.047711f, 0.049653f, 0.051584f, 0.053781f, 0.056320f, 0.060150f, 0.064467f, 0.069136f, 0.072853f, 0.076905f, 0.080828f, 0.083950f, 0.083612f, 0.079452f, 0.075044f, 0.071217f, 0.067842f, 0.064226f, 0.059706f, 0.054840f, 0.049376f, 0.044664f, 0.040657f, 0.037119f, 0.032393f, 0.028288f, 0.023550f, 0.018966f, 0.014961f, 0.010371f, 0.005435f, 0.002591f, 0.001482f, 0.000351f, 0.000135f
, 0.000000f, 0.000000f, 0.000000f, 0.000146f, 0.000729f, 0.002792f, 0.004355f, 0.006602f, 0.008415f, 0.010647f, 0.012410f, 0.012968f, 0.014813f, 0.016505f, 0.017505f, 0.020179f, 0.022479f, 0.023920f, 0.026529f, 0.028677f, 0.030813f, 0.032781f, 0.034229f, 0.036376f, 0.037992f, 0.039902f, 0.042112f, 0.043428f, 0.045171f, 0.046210f, 0.047461f, 0.048997f, 0.050395f, 0.052156f, 0.055294f, 0.058865f, 0.062361f, 0.064780f, 0.067333f, 0.069668f, 0.071169f, 0.069580f, 0.064243f, 0.059177f, 0.055717f, 0.052802f, 0.049666f, 0.045760f, 0.041592f, 0.036904f, 0.032887f, 0.029518f, 0.026599f, 0.022619f, 0.019197f, 0.015155f, 0.011328f, 0.008119f, 0.004377f, 0.000772f, 0.000027f, 0.000000f, 0.000000f, 0.000000f
, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000074f, 0.001723f, 0.003036f, 0.005250f, 0.007084f, 0.009242f, 0.011401f, 0.012438f, 0.014085f, 0.016021f, 0.017246f, 0.020656f, 0.023283f, 0.024909f, 0.027359f, 0.029433f, 0.031590f, 0.033686f, 0.035199f, 0.036911f, 0.038341f, 0.040188f, 0.042020f, 0.042877f, 0.044047f, 0.044576f, 0.044941f, 0.046019f, 0.046558f, 0.047670f, 0.049947f, 0.052536f, 0.054439f, 0.055185f, 0.055751f, 0.055893f, 0.055151f, 0.052084f, 0.045624f, 0.040027f, 0.037325f, 0.035255f, 0.033009f, 0.030234f, 0.027277f, 0.023916f, 0.021085f, 0.018750f, 0.016746f, 0.013975f, 0.011558f, 0.008684f, 0.005988f, 0.003801f, 0.001270f, 0.000005f, 0.000000f, 0.000000f, 0.000000f, 0.000000f
, 0.000229f, 0.000448f, 0.000329f, 0.000229f, 0.000104f, 0.001900f, 0.002943f, 0.005108f, 0.006930f, 0.008945f, 0.011426f, 0.012910f, 0.014369f, 0.016526f, 0.017919f, 0.021937f, 0.024779f, 0.026503f, 0.028743f, 0.030734f, 0.032893f, 0.035077f, 0.036631f, 0.037879f, 0.039135f, 0.040894f, 0.042330f, 0.042747f, 0.043350f, 0.043398f, 0.042860f, 0.043467f, 0.043150f, 0.043638f, 0.044974f, 0.046477f, 0.046671f, 0.045721f, 0.044267f, 0.042086f, 0.039001f, 0.034484f, 0.027047f, 0.021066f, 0.019244f, 0.018140f, 0.016923f, 0.015439f, 0.013852f, 0.012009f, 0.010505f, 0.009296f, 0.008261f, 0.006813f, 0.005496f, 0.003938f, 0.002479f, 0.001335f, 0.000181f, 0.000000f, 0.000000f, 0.000000f, 0.000274f, 0.000054f
, 0.002160f, 0.002669f, 0.002566f, 0.002175f, 0.001645f, 0.003559f, 0.004405f, 0.006546f, 0.008338f, 0.010158f, 0.012792f, 0.014630f, 0.016046f, 0.018407f, 0.019876f, 0.024146f, 0.026927f, 0.028572f, 0.030579f, 0.032533f, 0.034713f, 0.036927f, 0.038447f, 0.039344f, 0.040539f, 0.042220f, 0.043353f, 0.043446f, 0.043599f, 0.043283f, 0.042007f, 0.042184f, 0.041095f, 0.040900f, 0.041309f, 0.041761f, 0.040442f, 0.038136f, 0.035093f, 0.030952f, 0.025959f, 0.020286f, 0.012127f, 0.005942f, 0.004865f, 0.004582f, 0.004261f, 0.003880f, 0.003467f, 0.002969f, 0.002585f, 0.002289f, 0.002035f, 0.001674f, 0.001317f, 0.000905f, 0.000515f, 0.000222f, 0.000009f, 0.000000f, 0.000270f, 0.000258f, 0.002368f, 0.001790f
, 0.005271f, 0.005861f, 0.006052f, 0.005603f, 0.004883f, 0.006691f, 0.007441f, 0.009618f, 0.011379f, 0.012958f, 0.015547f, 0.017633f, 0.019341f, 0.021976f, 0.023452f, 0.027433f, 0.029736f, 0.031033f, 0.032846f, 0.034901f, 0.037190f, 0.039360f, 0.040736f, 0.041507f, 0.042860f, 0.044498f, 0.045509f, 0.045490f, 0.045400f, 0.044925f, 0.043220f, 0.043043f, 0.041313f, 0.040279f, 0.039809f, 0.039310f, 0.036885f, 0.033859f, 0.030054f, 0.024687f, 0.018640f, 0.012327f, 0.003890f, 0.000088f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000029f, 0.000107f, 0.000255f, 0.000514f, 0.001768f, 0.002197f, 0.004973f, 0.004677f
, 0.009503f, 0.010203f, 0.010937f, 0.010449f, 0.009515f, 0.010951f, 0.011568f, 0.013850f, 0.015580f, 0.016838f, 0.019307f, 0.021657f, 0.024152f, 0.027343f, 0.028870f, 0.032077f, 0.033463f, 0.034122f, 0.035833f, 0.038237f, 0.040793f, 0.042854f, 0.043990f, 0.044818f, 0.046567f, 0.048185f, 0.049233f, 0.049305f, 0.049149f, 0.048707f, 0.046799f, 0.046285f, 0.043954f, 0.041829f, 0.040355f, 0.038811f, 0.035443f, 0.032193f, 0.028322f, 0.022206f, 0.015723f, 0.009188f, 0.001375f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000007f, 0.000090f, 0.000393f, 0.000947f, 0.001133f, 0.001318f, 0.001875f, 0.003931f, 0.005090f, 0.007975f, 0.008415f
, 0.014695f, 0.015542f, 0.016944f, 0.016507f, 0.015468f, 0.016496f, 0.017019f, 0.019431f, 0.021112f, 0.021996f, 0.024216f, 0.026771f, 0.030225f, 0.034003f, 0.035524f, 0.037636f, 0.037844f, 0.037694f, 0.039299f, 0.042118f, 0.044976f, 0.046876f, 0.047707f, 0.048688f, 0.050946f, 0.052550f, 0.053716f, 0.053987f, 0.053867f, 0.053567f, 0.051594f, 0.050769f, 0.047895f, 0.044602f, 0.042098f, 0.039500f, 0.035324f, 0.032139f, 0.028584f, 0.022004f, 0.015447f, 0.008945f, 0.001320f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000005f, 0.000322f, 0.000706f, 0.000735f, 0.000735f, 0.000950f, 0.001866f, 0.002611f, 0.003395f, 0.003433f, 0.003424f, 0.004093f, 0.006925f, 0.008900f, 0.011674f, 0.013003f
, 0.020479f, 0.021525f, 0.023570f, 0.023410f, 0.022617f, 0.023537f, 0.024138f, 0.026651f, 0.028256f, 0.028754f, 0.030495f, 0.033059f, 0.037233f, 0.041271f, 0.042575f, 0.043436f, 0.042424f, 0.041439f, 0.042808f, 0.045871f, 0.048908f, 0.050604f, 0.051096f, 0.052249f, 0.054981f, 0.056566f, 0.057860f, 0.058340f, 0.058294f, 0.058162f, 0.056205f, 0.055137f, 0.051845f, 0.047553f, 0.044192f, 0.040722f, 0.035955f, 0.032971f, 0.029828f, 0.022991f, 0.016550f, 0.010211f, 0.002400f, 0.000000f, 0.000000f, 0.000000f, 0.000045f, 0.000360f, 0.001181f, 0.003140f, 0.003951f, 0.003891f, 0.003775f, 0.003946f, 0.005156f, 0.006116f, 0.007103f, 0.007045f, 0.006839f, 0.007546f, 0.010995f, 0.013683f, 0.016189f, 0.018235f
, 0.026486f, 0.027804f, 0.030311f, 0.030790f, 0.030837f, 0.032284f, 0.033268f, 0.035805f, 0.037288f, 0.037434f, 0.038365f, 0.040607f, 0.044847f, 0.048460f, 0.049183f, 0.048804f, 0.046744f, 0.045047f, 0.045930f, 0.048823f, 0.051752f, 0.053216f, 0.053368f, 0.054636f, 0.057655f, 0.059208f, 0.060563f, 0.061166f, 0.061167f, 0.061149f, 0.059234f, 0.058031f, 0.054510f, 0.049638f, 0.045789f, 0.041822f, 0.036764f, 0.033961f, 0.031046f, 0.024077f, 0.017774f, 0.011604f, 0.003999f, 0.000114f, 0.000011f, 0.000407f, 0.001475f, 0.002614f, 0.004006f, 0.006442f, 0.007370f, 0.007357f, 0.007262f, 0.007540f, 0.009069f, 0.010501f, 0.011879f, 0.012015f, 0.011829f, 0.012614f, 0.016383f, 0.019497f, 0.021641f, 0.023906f
, 0.033080f, 0.034781f, 0.037398f, 0.039061f, 0.040886f, 0.043907f, 0.045740f, 0.048154f, 0.049446f, 0.049293f, 0.048884f, 0.050297f, 0.053537f, 0.055610f, 0.055166f, 0.053605f, 0.050805f, 0.048603f, 0.048551f, 0.050582f, 0.052936f, 0.054139f, 0.053960f, 0.055245f, 0.058247f, 0.059764f, 0.061072f, 0.061649f, 0.061621f, 0.061595f, 0.059713f, 0.058518f, 0.054986f, 0.050138f, 0.046338f, 0.042439f, 0.037503f, 0.034750f, 0.031624f, 0.024593f, 0.018338f, 0.012272f, 0.004981f, 0.000964f, 0.000829f, 0.001762f, 0.003282f, 0.004590f, 0.006187f, 0.009043f, 0.010208f, 0.010608f, 0.010860f, 0.011644f, 0.013666f, 0.016108f, 0.018294f, 0.019203f, 0.019489f, 0.020496f, 0.024139f, 0.027214f, 0.028905f, 0.030533f
, 0.041873f, 0.044126f, 0.046430f, 0.049952f, 0.054766f, 0.060643f, 0.063871f, 0.065972f, 0.066979f, 0.066539f, 0.064012f, 0.063974f, 0.065070f, 0.064271f, 0.061887f, 0.058954f, 0.055575f, 0.052960f, 0.051330f, 0.051679f, 0.052910f, 0.053802f, 0.053253f, 0.054526f, 0.057258f, 0.058777f, 0.059983f, 0.060450f, 0.060346f, 0.060212f, 0.058390f, 0.057347f, 0.053931f, 0.049617f, 0.046371f, 0.043131f, 0.038821f, 0.036056f, 0.032297f, 0.025314f, 0.019132f, 0.013199f, 0.006223f, 0.002681f, 0.002642f, 0.003695f, 0.005448f, 0.006924f, 0.008741f, 0.012064f, 0.013579f, 0.014801f, 0.015756f, 0.017516f, 0.020282f, 0.024476f, 0.028064f, 0.030485f, 0.031763f, 0.033143f, 0.036157f, 0.038713f, 0.039725f, 0.039728f
, 0.051279f, 0.054167f, 0.055970f, 0.061735f, 0.070183f, 0.079588f, 0.084528f, 0.086229f, 0.086901f, 0.086194f, 0.081169f, 0.079329f, 0.077633f, 0.073244f, 0.068524f, 0.064164f, 0.060332f, 0.057392f, 0.053895f, 0.052132f, 0.051943f, 0.052491f, 0.051557f, 0.052782f, 0.055077f, 0.056594f, 0.057650f, 0.057939f, 0.057742f, 0.057454f, 0.055731f, 0.054944f, 0.051812f, 0.048416f, 0.046073f, 0.043865f, 0.040495f, 0.037722f, 0.033166f, 0.026369f, 0.020315f, 0.014552f, 0.007930f, 0.004871f, 0.004915f, 0.006068f, 0.008031f, 0.009648f, 0.011656f, 0.015413f, 0.017301f, 0.019525f, 0.021341f, 0.024272f, 0.027856f, 0.034097f, 0.039306f, 0.043553f, 0.046045f, 0.047832f, 0.049916f, 0.051671f, 0.051877f, 0.049745f
, 0.058956f, 0.062449f, 0.063847f, 0.071875f, 0.083875f, 0.096721f, 0.103410f, 0.104756f, 0.105102f, 0.104177f, 0.096793f, 0.093144f, 0.088578f, 0.080638f, 0.073661f, 0.068060f, 0.063922f, 0.060784f, 0.055591f, 0.051765f, 0.050168f, 0.050358f, 0.049073f, 0.050175f, 0.051943f, 0.053392f, 0.054237f, 0.054277f, 0.053991f, 0.053555f, 0.051963f, 0.051498f, 0.048894f, 0.046695f, 0.045451f, 0.044392f, 0.042042f, 0.039312f, 0.034064f, 0.027611f, 0.021733f, 0.016143f, 0.009941f, 0.007293f, 0.007375f, 0.008585f, 0.010687f, 0.012387f, 0.014512f, 0.018566f, 0.020759f, 0.023898f, 0.026505f, 0.030471f, 0.034726f, 0.042741f, 0.049314f, 0.055175f, 0.058749f, 0.060850f, 0.061940f, 0.062841f, 0.062270f, 0.058064f
, 0.062561f, 0.066518f, 0.067887f, 0.077834f, 0.092579f, 0.108022f, 0.116216f, 0.117382f, 0.117469f, 0.116403f, 0.107323f, 0.102199f, 0.095256f, 0.084559f, 0.075886f, 0.069469f, 0.065191f, 0.062022f, 0.055764f, 0.050399f, 0.047711f, 0.047558f, 0.045998f, 0.046866f, 0.048095f, 0.049348f, 0.049908f, 0.049619f, 0.049277f, 0.048744f, 0.047316f, 0.047198f, 0.045442f, 0.044616f, 0.044511f, 0.044462f, 0.042977f, 0.040388f, 0.034828f, 0.028892f, 0.023233f, 0.017788f, 0.012095f, 0.009707f, 0.009753f, 0.010950f, 0.013072f, 0.014763f, 0.016891f, 0.021003f, 0.023336f, 0.027037f, 0.030136f, 0.034675f, 0.039230f, 0.048180f, 0.055382f, 0.062116f, 0.066288f, 0.068483f, 0.068759f, 0.068976f, 0.067814f, 0.062167f
, 0.060152f, 0.064340f, 0.066297f, 0.077552f, 0.093671f, 0.110297f, 0.119550f, 0.120817f, 0.120755f, 0.119648f, 0.109949f, 0.103951f, 0.095560f, 0.083489f, 0.074055f, 0.067448f, 0.063218f, 0.060223f, 0.053901f, 0.047888f, 0.044681f, 0.044225f, 0.042514f, 0.043015f, 0.043761f, 0.044652f, 0.044853f, 0.044160f, 0.043811f, 0.043276f, 0.042034f, 0.042254f, 0.041737f, 0.042384f, 0.043341f, 0.043961f, 0.042986f, 0.040655f, 0.035357f, 0.030108f, 0.024677f, 0.019278f, 0.014171f, 0.011804f, 0.011709f, 0.012807f, 0.014793f, 0.016360f, 0.018337f, 0.022184f, 0.024417f, 0.028117f, 0.031224f, 0.035617f, 0.039926f, 0.048520f, 0.055244f, 0.061696f, 0.065706f, 0.067677f, 0.067507f, 0.067394f, 0.065962f, 0.059962f
, 0.051901f, 0.056169f, 0.059385f, 0.071736f, 0.088364f, 0.105268f, 0.115466f, 0.117090f, 0.116931f, 0.115869f, 0.106349f, 0.099802f, 0.090427f, 0.077860f, 0.068294f, 0.062033f, 0.058050f, 0.055463f, 0.049939f, 0.043868f, 0.040545f, 0.039795f, 0.038031f, 0.038000f, 0.038228f, 0.038573f, 0.038304f, 0.037088f, 0.036776f, 0.036310f, 0.035300f, 0.035913f, 0.037237f, 0.039758f, 0.041945f, 0.043077f, 0.042384f, 0.040418f, 0.035870f, 0.031547f, 0.026329f, 0.020788f, 0.016371f, 0.013752f, 0.013386f, 0.014296f, 0.015992f, 0.017302f, 0.018960f, 0.022206f, 0.024107f, 0.027327f, 0.030034f, 0.033647f, 0.037194f, 0.044267f, 0.049491f, 0.054631f, 0.057811f, 0.059250f, 0.058864f, 0.058645f, 0.057194f, 0.051700f
, 0.039967f, 0.044218f, 0.049079f, 0.062376f, 0.078975f, 0.095589f, 0.106645f, 0.108782f, 0.108563f, 0.107610f, 0.098767f, 0.091867f, 0.081778f, 0.069248f, 0.059944f, 0.054375f, 0.050788f, 0.048768f, 0.044569f, 0.038807f, 0.035598f, 0.034553f, 0.032796f, 0.032120f, 0.031787f, 0.031462f, 0.030643f, 0.028813f, 0.028566f, 0.028213f, 0.027469f, 0.028522f, 0.032068f, 0.036742f, 0.040287f, 0.041869f, 0.041356f, 0.039837f, 0.036353f, 0.033138f, 0.028154f, 0.022395f, 0.018756f, 0.015731f, 0.015013f, 0.015673f, 0.016972f, 0.017939f, 0.019166f, 0.021588f, 0.023011f, 0.025457f, 0.027516f, 0.029955f, 0.032410f, 0.037234f, 0.040312f, 0.043505f, 0.045441f, 0.046148f, 0.045663f, 0.045454f, 0.044130f, 0.039644f
, 0.026827f, 0.030979f, 0.037501f, 0.051448f, 0.067573f, 0.083443f, 0.095124f, 0.097819f, 0.097592f, 0.096787f, 0.088924f, 0.081882f, 0.071392f, 0.059315f, 0.050559f, 0.045869f, 0.042759f, 0.041364f, 0.038706f, 0.033517f, 0.030558f, 0.029235f, 0.027524f, 0.026180f, 0.025300f, 0.024275f, 0.022895f, 0.020442f, 0.020267f, 0.020045f, 0.019573f, 0.021057f, 0.026814f, 0.033582f, 0.038418f, 0.040378f, 0.039996f, 0.038966f, 0.036682f, 0.034621f, 0.029923f, 0.024023f, 0.021187f, 0.017737f, 0.016661f, 0.017045f, 0.017901f, 0.018498f, 0.019262f, 0.020786f, 0.021679f, 0.023232f, 0.024540f, 0.025654f, 0.026903f, 0.029211f, 0.029916f, 0.030930f, 0.031468f, 0.031379f, 0.030864f, 0.030730f, 0.029603f, 0.026343f
, 0.014956f, 0.018948f, 0.026776f, 0.040924f, 0.056226f, 0.071012f, 0.082937f, 0.086124f, 0.085954f, 0.085318f, 0.078542f, 0.071580f, 0.061050f, 0.049725f, 0.041698f, 0.037910f, 0.035293f, 0.034478f, 0.033266f, 0.028809f, 0.026141f, 0.024578f, 0.022927f, 0.020985f, 0.019627f, 0.017971f, 0.016087f, 0.013078f, 0.012968f, 0.012867f, 0.012642f, 0.014494f, 0.022059f, 0.030524f, 0.036386f, 0.038646f, 0.038400f, 0.037859f, 0.036736f, 0.035739f, 0.031408f, 0.025593f, 0.023519f, 0.019762f, 0.018398f, 0.018517f, 0.018943f, 0.019210f, 0.019555f, 0.020256f, 0.020663f, 0.021377f, 0.021979f, 0.021862f, 0.022001f, 0.021987f, 0.020513f, 0.019520f, 0.018766f, 0.017947f, 0.017427f, 0.017380f, 0.016448f, 0.014347f
, 0.006798f, 0.010583f, 0.018994f, 0.032737f, 0.046952f, 0.060415f, 0.072045f, 0.075552f, 0.075518f, 0.075053f, 0.069283f, 0.062640f, 0.052479f, 0.042101f, 0.034884f, 0.031863f, 0.029693f, 0.029312f, 0.029142f, 0.025484f, 0.023054f, 0.021310f, 0.019708f, 0.017332f, 0.015617f, 0.013491f, 0.011229f, 0.007807f, 0.007740f, 0.007725f, 0.007691f, 0.009794f, 0.018367f, 0.027798f, 0.034222f, 0.036696f, 0.036647f, 0.036558f, 0.036385f, 0.036232f, 0.032383f, 0.027038f, 0.025624f, 0.021816f, 0.020309f, 0.020209f, 0.020276f, 0.020313f, 0.020361f, 0.020462f, 0.020519f, 0.020620f, 0.020706f, 0.019690f, 0.019026f, 0.017340f, 0.014291f, 0.011860f, 0.010175f, 0.008824f, 0.008282f, 0.008279f, 0.007467f, 0.006176f
, 0.003513f, 0.007011f, 0.014913f, 0.027216f, 0.039756f, 0.051282f, 0.061654f, 0.065267f, 0.065518f, 0.065219f, 0.060454f, 0.054574f, 0.045531f, 0.036581f, 0.030432f, 0.028062f, 0.026333f, 0.026209f, 0.026588f, 0.024025f, 0.021797f, 0.019954f, 0.018411f, 0.015808f, 0.013891f, 0.011480f, 0.008972f, 0.005291f, 0.005232f, 0.005235f, 0.005299f, 0.007473f, 0.015853f, 0.025173f, 0.031468f, 0.034052f, 0.034348f, 0.034739f, 0.035325f, 0.035761f, 0.032675f, 0.028572f, 0.027759f, 0.024324f, 0.022895f, 0.022613f, 0.022370f, 0.022313f, 0.022224f, 0.022009f, 0.021887f, 0.021630f, 0.021431f, 0.019919f, 0.018832f, 0.016276f, 0.012384f, 0.009219f, 0.007059f, 0.005410f, 0.004810f, 0.004807f, 0.004019f, 0.003070f
, 0.004238f, 0.007355f, 0.013731f, 0.023470f, 0.033555f, 0.042307f, 0.050354f, 0.053911f, 0.054619f, 0.054475f, 0.050860f, 0.046276f, 0.039242f, 0.032416f, 0.027732f, 0.025992f, 0.024742f, 0.024730f, 0.025310f, 0.024316f, 0.022340f, 0.020502f, 0.019060f, 0.016426f, 0.014473f, 0.011930f, 0.009291f, 0.005481f, 0.005398f, 0.005344f, 0.005396f, 0.007444f, 0.014449f, 0.022581f, 0.028036f, 0.030591f, 0.031352f, 0.032283f, 0.033525f, 0.034305f, 0.032285f, 0.030236f, 0.029980f, 0.027314f, 0.026176f, 0.025727f, 0.025191f, 0.025159f, 0.025074f, 0.024787f, 0.024620f, 0.024166f, 0.023847f, 0.022134f, 0.020924f, 0.018118f, 0.013944f, 0.010582f, 0.008308f, 0.006543f, 0.005893f, 0.005898f, 0.005091f, 0.004147f
, 0.007441f, 0.010101f, 0.014391f, 0.020978f, 0.028233f, 0.033866f, 0.039092f, 0.042467f, 0.043713f, 0.043748f, 0.041336f, 0.038315f, 0.033728f, 0.029327f, 0.026278f, 0.025132f, 0.024350f, 0.024357f, 0.024900f, 0.025603f, 0.023890f, 0.022107f, 0.020770f, 0.018227f, 0.016341f, 0.013791f, 0.011121f, 0.007302f, 0.007181f, 0.007055f, 0.007059f, 0.008889f, 0.013896f, 0.020242f, 0.024466f, 0.026892f, 0.028136f, 0.029581f, 0.031353f, 0.032319f, 0.031459f, 0.031765f, 0.031982f, 0.030271f, 0.029533f, 0.028949f, 0.028164f, 0.028228f, 0.028228f, 0.028015f, 0.027894f, 0.027383f, 0.027055f, 0.025351f, 0.024219f, 0.021580f, 0.017526f, 0.014335f, 0.012172f, 0.010428f, 0.009743f, 0.009747f, 0.008889f, 0.007765f
, 0.011464f, 0.013612f, 0.015729f, 0.019134f, 0.023605f, 0.026286f, 0.028804f, 0.031906f, 0.033676f, 0.033958f, 0.032711f, 0.031237f, 0.029045f, 0.026953f, 0.025467f, 0.024870f, 0.024501f, 0.024491f, 0.024875f, 0.027036f, 0.025541f, 0.023804f, 0.022530f, 0.020110f, 0.018321f, 0.015849f, 0.013231f, 0.009504f, 0.009348f, 0.009204f, 0.009212f, 0.010855f, 0.013845f, 0.018327f, 0.021285f, 0.023528f, 0.025175f, 0.027024f, 0.029191f, 0.030292f, 0.030481f, 0.032908f, 0.033491f, 0.032703f, 0.032365f, 0.031690f, 0.030726f, 0.030897f, 0.031004f, 0.030903f, 0.030868f, 0.030418f, 0.030134f, 0.028556f, 0.027594f, 0.025315f, 0.021607f, 0.018773f, 0.016803f, 0.015161f, 0.014460f, 0.014425f, 0.013491f, 0.012162f
, 0.014692f, 0.016276f, 0.016588f, 0.017308f, 0.019440f, 0.019830f, 0.020340f, 0.023105f, 0.025299f, 0.025951f, 0.025753f, 0.025535f, 0.025217f, 0.024914f, 0.024692f, 0.024595f, 0.024541f, 0.024535f, 0.024748f, 0.027760f, 0.026385f, 0.024623f, 0.023323f, 0.020967f, 0.019233f, 0.016888f, 0.014390f, 0.010844f, 0.010674f, 0.010638f, 0.010793f, 0.012405f, 0.013953f, 0.017004f, 0.018998f, 0.021055f, 0.022926f, 0.024985f, 0.027398f, 0.028699f, 0.029625f, 0.033411f, 0.034231f, 0.034123f, 0.034078f, 0.033369f, 0.032324f, 0.032558f, 0.032729f, 0.032669f, 0.032715f, 0.032427f, 0.032180f, 0.030754f, 0.029945f, 0.028006f, 0.024697f, 0.022230f, 0.020390f, 0.018883f, 0.018183f, 0.018045f, 0.017010f, 0.015615f
, 0.017380f, 0.018062f, 0.016727f, 0.014934f, 0.014943f, 0.013774f, 0.013214f, 0.015381f, 0.017915f, 0.019355f, 0.020282f, 0.021045f, 0.022000f, 0.022866f, 0.023621f, 0.024059f, 0.024199f, 0.024255f, 0.024250f, 0.027091f, 0.025669f, 0.023722f, 0.022205f, 0.019802f, 0.018042f, 0.015947f, 0.013730f, 0.010586f, 0.010441f, 0.010793f, 0.011428f, 0.013324f, 0.014271f, 0.016436f, 0.017857f, 0.019674f, 0.021456f, 0.023404f, 0.025925f, 0.027758f, 0.029026f, 0.032925f, 0.033787f, 0.034069f, 0.034229f, 0.033634f, 0.032703f, 0.032896f, 0.033043f, 0.032863f, 0.033006f, 0.033176f, 0.032958f, 0.031776f, 0.031122f, 0.029554f, 0.026858f, 0.024870f, 0.023021f, 0.021759f, 0.021135f, 0.020710f, 0.019464f, 0.018289f
, 0.020455f, 0.019913f, 0.017009f, 0.012885f, 0.011075f, 0.009191f, 0.008507f, 0.009786f, 0.012567f, 0.015190f, 0.017216f, 0.018661f, 0.020263f, 0.021603f, 0.022969f, 0.023893f, 0.024063f, 0.024187f, 0.023821f, 0.025434f, 0.023785f, 0.021525f, 0.019609f, 0.017099f, 0.015275f, 0.013599f, 0.011860f, 0.009371f, 0.009284f, 0.010285f, 0.011691f, 0.014141f, 0.015192f, 0.016900f, 0.018065f, 0.019559f, 0.020920f, 0.022402f, 0.024818f, 0.027440f, 0.028624f, 0.031363f, 0.032001f, 0.032403f, 0.032709f, 0.032402f, 0.031821f, 0.031893f, 0.031956f, 0.031564f, 0.031858f, 0.032839f, 0.032695f, 0.031937f, 0.031522f, 0.030527f, 0.028814f, 0.027556f, 0.025651f, 0.024798f, 0.024340f, 0.023449f, 0.021871f, 0.021118f
, 0.022591f, 0.021008f, 0.017072f, 0.011363f, 0.008329f, 0.006328f, 0.006004f, 0.006459f, 0.009374f, 0.013080f, 0.015968f, 0.017852f, 0.019716f, 0.021128f, 0.022840f, 0.024158f, 0.024271f, 0.024449f, 0.023673f, 0.023658f, 0.021718f, 0.019122f, 0.016764f, 0.014142f, 0.012253f, 0.011040f, 0.009826f, 0.008052f, 0.008033f, 0.009736f, 0.011972f, 0.015044f, 0.016529f, 0.018035f, 0.019132f, 0.020305f, 0.021138f, 0.021987f, 0.024008f, 0.027151f, 0.027920f, 0.029061f, 0.029355f, 0.029637f, 0.029920f, 0.029875f, 0.029674f, 0.029649f, 0.029643f, 0.029054f, 0.029486f, 0.031250f, 0.031192f, 0.030883f, 0.030714f, 0.030308f, 0.029610f, 0.029097f, 0.027190f, 0.026750f, 0.026403f, 0.025061f, 0.023210f, 0.022903f
, 0.021880f, 0.019985f, 0.016098f, 0.010146f, 0.006728f, 0.004882f, 0.004863f, 0.004942f, 0.007870f, 0.012039f, 0.015402f, 0.017625f, 0.019721f, 0.021210f, 0.023197f, 0.024833f, 0.024906f, 0.025104f, 0.023960f, 0.022551f, 0.020364f, 0.017492f, 0.014774f, 0.012081f, 0.010154f, 0.009339f, 0.008572f, 0.007419f, 0.007451f, 0.009747f, 0.012700f, 0.016293f, 0.018132f, 0.019472f, 0.020538f, 0.021463f, 0.021887f, 0.022083f, 0.023227f, 0.025957f, 0.026019f, 0.025989f, 0.025962f, 0.025878f, 0.025771f, 0.025718f, 0.025692f, 0.025726f, 0.025743f, 0.025076f, 0.025543f, 0.027631f, 0.027630f, 0.027633f, 0.027635f, 0.027640f, 0.027650f, 0.027656f, 0.025927f, 0.025743f, 0.025261f, 0.023687f, 0.021849f, 0.021851f
, 0.012707f, 0.012110f, 0.010872f, 0.007824f, 0.005939f, 0.004999f, 0.005334f, 0.006021f, 0.008745f, 0.012133f, 0.015289f, 0.017818f, 0.020223f, 0.021893f, 0.024165f, 0.026104f, 0.026172f, 0.026346f, 0.024811f, 0.022097f, 0.019684f, 0.016561f, 0.013527f, 0.010801f, 0.008864f, 0.008439f, 0.008105f, 0.007568f, 0.007645f, 0.010503f, 0.014239f, 0.018315f, 0.020390f, 0.021654f, 0.022816f, 0.023608f, 0.023776f, 0.022999f, 0.021697f, 0.021519f, 0.019792f, 0.019097f, 0.018642f, 0.017343f, 0.015741f, 0.014973f, 0.014633f, 0.015122f, 0.015380f, 0.014792f, 0.014960f, 0.016321f, 0.016311f, 0.016403f, 0.016455f, 0.016580f, 0.016794f, 0.016952f, 0.015880f, 0.015717f, 0.014510f, 0.013166f, 0.012158f, 0.012231f
, 0.002844f, 0.004315f, 0.006816f, 0.008095f, 0.008704f, 0.009053f, 0.009752f, 0.011449f, 0.013732f, 0.015597f, 0.017930f, 0.020396f, 0.022777f, 0.024359f, 0.026575f, 0.028574f, 0.028607f, 0.028685f, 0.026833f, 0.023106f, 0.020524f, 0.017273f, 0.014081f, 0.011408f, 0.009517f, 0.009361f, 0.009308f, 0.009201f, 0.009284f, 0.012484f, 0.016675f, 0.021044f, 0.023423f, 0.024707f, 0.026014f, 0.026744f, 0.026785f, 0.025139f, 0.021212f, 0.017496f, 0.013920f, 0.013101f, 0.012321f, 0.009756f, 0.006503f, 0.004861f, 0.004101f, 0.005158f, 0.005755f, 0.005492f, 0.005404f, 0.005669f, 0.005644f, 0.005668f, 0.005682f, 0.005714f, 0.005770f, 0.005811f, 0.005541f, 0.005155f, 0.002967f, 0.002056f, 0.001966f, 0.001969f
, 0.003254f, 0.005619f, 0.009576f, 0.012509f, 0.014036f, 0.014814f, 0.015504f, 0.017462f, 0.019368f, 0.020402f, 0.022135f, 0.024265f, 0.026345f, 0.027640f, 0.029527f, 0.031342f, 0.031322f, 0.031280f, 0.029291f, 0.025181f, 0.022535f, 0.019311f, 0.016155f, 0.013594f, 0.011787f, 0.011698f, 0.011690f, 0.011699f, 0.011742f, 0.014968f, 0.019020f, 0.023411f, 0.026083f, 0.027235f, 0.028451f, 0.029068f, 0.029033f, 0.027171f, 0.022578f, 0.017870f, 0.013976f, 0.013401f, 0.012612f, 0.009953f, 0.006376f, 0.004548f, 0.003804f, 0.005046f, 0.005827f, 0.005989f, 0.006139f, 0.006185f, 0.006232f, 0.006258f, 0.006287f, 0.006320f, 0.006352f, 0.006383f, 0.006462f, 0.005839f, 0.003158f, 0.002372f, 0.002241f, 0.002267f
, 0.007006f, 0.009600f, 0.013801f, 0.016982f, 0.018614f, 0.019398f, 0.019957f, 0.021841f, 0.023505f, 0.024196f, 0.025589f, 0.027395f, 0.029175f, 0.030204f, 0.031772f, 0.033378f, 0.033315f, 0.033182f, 0.031156f, 0.026983f, 0.024327f, 0.021172f, 0.018105f, 0.015642f, 0.013906f, 0.013797f, 0.013744f, 0.013729f, 0.013729f, 0.016870f, 0.020571f, 0.024878f, 0.027763f, 0.028707f, 0.029690f, 0.030135f, 0.029980f, 0.028044f, 0.023488f, 0.018887f, 0.015246f, 0.014865f, 0.014024f, 0.011689f, 0.008315f, 0.006546f, 0.005937f, 0.007169f, 0.008043f, 0.008612f, 0.009194f, 0.009497f, 0.009704f, 0.009857f, 0.010023f, 0.010211f, 0.010396f, 0.010577f, 0.010839f, 0.010087f, 0.007233f, 0.006473f, 0.005927f, 0.006036f
, 0.012363f, 0.015102f, 0.019342f, 0.022533f, 0.024127f, 0.024830f, 0.025200f, 0.026927f, 0.028322f, 0.028688f, 0.029708f, 0.031109f, 0.032513f, 0.033212f, 0.034381f, 0.035718f, 0.035602f, 0.035364f, 0.033320f, 0.029163f, 0.026508f, 0.023453f, 0.020512f, 0.018168f, 0.016517f, 0.016359f, 0.016221f, 0.016138f, 0.016083f, 0.019084f, 0.022288f, 0.026460f, 0.029587f, 0.030259f, 0.030920f, 0.031137f, 0.030823f, 0.028826f, 0.024470f, 0.020241f, 0.017045f, 0.016899f, 0.015976f, 0.014135f, 0.011132f, 0.009484f, 0.009063f, 0.010238f, 0.011208f, 0.012281f, 0.013447f, 0.014171f, 0.014605f, 0.014943f, 0.015312f, 0.015729f, 0.016140f, 0.016539f, 0.016995f, 0.016107f, 0.013113f, 0.012371f, 0.011228f, 0.011449f
, 0.018932f, 0.021750f, 0.025878f, 0.028903f, 0.030354f, 0.030912f, 0.031049f, 0.032557f, 0.033661f, 0.033713f, 0.034336f, 0.035271f, 0.036238f, 0.036561f, 0.037270f, 0.038293f, 0.038118f, 0.037763f, 0.035716f, 0.031629f, 0.028986f, 0.026053f, 0.023268f, 0.021059f, 0.019504f, 0.019273f, 0.019024f, 0.018837f, 0.018718f, 0.021539f, 0.024169f, 0.028172f, 0.031558f, 0.031941f, 0.032260f, 0.032247f, 0.031789f, 0.029814f, 0.025861f, 0.022233f, 0.019644f, 0.019817f, 0.018870f, 0.017653f, 0.015153f, 0.013699f, 0.013518f, 0.014606f, 0.015667f, 0.017278f, 0.019089f, 0.020301f, 0.020964f, 0.021479f, 0.022043f, 0.022680f, 0.023306f, 0.023916f, 0.024525f, 0.023474f, 0.020361f, 0.019607f, 0.017762f, 0.018101f
, 0.026314f, 0.029170f, 0.033087f, 0.035832f, 0.037075f, 0.037445f, 0.037320f, 0.038569f, 0.039366f, 0.039111f, 0.039315f, 0.039742f, 0.040233f, 0.040147f, 0.040354f, 0.041032f, 0.040795f, 0.040314f, 0.038272f, 0.034294f, 0.031670f, 0.028874f, 0.026263f, 0.024200f, 0.022748f, 0.022432f, 0.022051f, 0.021740f, 0.021551f, 0.024165f, 0.026209f, 0.030027f, 0.033677f, 0.033807f, 0.033831f, 0.033640f, 0.033105f, 0.031305f, 0.027999f, 0.025164f, 0.023317f, 0.023932f, 0.023106f, 0.022605f, 0.020710f, 0.019526f, 0.019638f, 0.020628f, 0.021761f, 0.023882f, 0.026307f, 0.027975f, 0.028812f, 0.029430f, 0.030105f, 0.030870f, 0.031621f, 0.032353f, 0.033026f, 0.031766f, 0.028537f, 0.027722f, 0.025148f, 0.025585f
, 0.034115f, 0.036987f, 0.040649f, 0.043063f, 0.044068f, 0.044232f, 0.043829f, 0.044799f, 0.045281f, 0.044716f, 0.044492f, 0.044387f, 0.044380f, 0.043867f, 0.043551f, 0.043867f, 0.043565f, 0.042954f, 0.040922f, 0.037068f, 0.034465f, 0.031814f, 0.029388f, 0.027478f, 0.026134f, 0.025724f, 0.025204f, 0.024758f, 0.024497f, 0.026891f, 0.028405f, 0.032041f, 0.035946f, 0.035906f, 0.035752f, 0.035488f, 0.034995f, 0.033596f, 0.031223f, 0.029337f, 0.028335f, 0.029557f, 0.029086f, 0.029352f, 0.028130f, 0.027302f, 0.027759f, 0.028655f, 0.029833f, 0.032374f, 0.035295f, 0.037285f, 0.038177f, 0.038756f, 0.039389f, 0.040106f, 0.040809f, 0.041495f, 0.042091f, 0.040558f, 0.037207f, 0.036257f, 0.033006f, 0.033493f
, 0.041939f, 0.044824f, 0.048242f, 0.050337f, 0.051110f, 0.051072f, 0.050392f, 0.051085f, 0.051248f, 0.050367f, 0.049708f, 0.049068f, 0.048561f, 0.047618f, 0.046776f, 0.046728f, 0.046361f, 0.045618f, 0.043596f, 0.039863f, 0.037281f, 0.034776f, 0.032536f, 0.030780f, 0.029544f, 0.029042f, 0.028383f, 0.027805f, 0.027472f, 0.029648f, 0.030752f, 0.034227f, 0.038366f, 0.038291f, 0.038145f, 0.037966f, 0.037687f, 0.036983f, 0.035869f, 0.035051f, 0.034971f, 0.037006f, 0.037211f, 0.038256f, 0.037743f, 0.037364f, 0.038215f, 0.039041f, 0.040226f, 0.043034f, 0.046241f, 0.048320f, 0.049091f, 0.049422f, 0.049784f, 0.050194f, 0.050597f, 0.050988f, 0.051317f, 0.049425f, 0.045931f, 0.044752f, 0.040953f, 0.041423f
, 0.049193f, 0.052109f, 0.055339f, 0.057185f, 0.057770f, 0.057558f, 0.056622f, 0.057065f, 0.056922f, 0.055726f, 0.054649f, 0.053505f, 0.052528f, 0.051180f, 0.049842f, 0.049454f, 0.049025f, 0.048157f, 0.046140f, 0.042506f, 0.039941f, 0.037571f, 0.035504f, 0.033893f, 0.032761f, 0.032177f, 0.031393f, 0.030697f, 0.030298f, 0.032274f, 0.033156f, 0.036511f, 0.040849f, 0.040910f, 0.041010f, 0.041114f, 0.041255f, 0.041580f, 0.042055f, 0.042367f, 0.043237f, 0.046302f, 0.047557f, 0.049341f, 0.049527f, 0.049682f, 0.050968f, 0.051759f, 0.052904f, 0.055767f, 0.058970f, 0.060824f, 0.061249f, 0.061074f, 0.060882f, 0.060664f, 0.060451f, 0.060243f, 0.060074f, 0.057733f, 0.054065f, 0.052547f, 0.048404f, 0.048768f
, 0.056158f, 0.059115f, 0.062172f, 0.063782f, 0.064188f, 0.063807f, 0.062625f, 0.062829f, 0.062390f, 0.060890f, 0.059409f, 0.057782f, 0.056351f, 0.054614f, 0.052799f, 0.052082f, 0.051593f, 0.050606f, 0.048592f, 0.045051f, 0.042502f, 0.040263f, 0.038360f, 0.036890f, 0.035856f, 0.035193f, 0.034288f, 0.033478f, 0.033015f, 0.034798f, 0.035618f, 0.038893f, 0.043428f, 0.043796f, 0.044382f, 0.044976f, 0.045758f, 0.047548f, 0.050124f, 0.051755f, 0.053696f, 0.058109f, 0.060886f, 0.063439f, 0.064395f, 0.065221f, 0.067018f, 0.067787f, 0.068823f, 0.071532f, 0.074443f, 0.075752f, 0.075570f, 0.074572f, 0.073471f, 0.072226f, 0.071012f, 0.069812f, 0.068849f, 0.065905f, 0.062004f, 0.059988f, 0.055645f, 0.055823f
, 0.063736f, 0.066737f, 0.069587f, 0.070920f, 0.071117f, 0.070546f, 0.069095f, 0.069033f, 0.068279f, 0.066457f, 0.064546f, 0.062394f, 0.060473f, 0.058314f, 0.055983f, 0.054911f, 0.054358f, 0.053241f, 0.051231f, 0.047798f, 0.045268f, 0.043169f, 0.041445f, 0.040127f, 0.039199f, 0.038448f, 0.037409f, 0.036472f, 0.035936f, 0.037508f, 0.038361f, 0.041573f, 0.046327f, 0.047148f, 0.048433f, 0.049710f, 0.051354f, 0.055075f, 0.060356f, 0.063609f, 0.066840f, 0.072973f, 0.077764f, 0.081206f, 0.083081f, 0.084751f, 0.087171f, 0.087918f, 0.088783f, 0.091183f, 0.093578f, 0.094073f, 0.093038f, 0.090907f, 0.088551f, 0.085889f, 0.083298f, 0.080727f, 0.078671f, 0.074948f, 0.070749f, 0.068063f, 0.063586f, 0.063504f
, 0.071683f, 0.074722f, 0.077339f, 0.078363f, 0.078333f, 0.077558f, 0.075824f, 0.075482f, 0.074400f, 0.072250f, 0.069892f, 0.067194f, 0.064761f, 0.062162f, 0.059293f, 0.057850f, 0.057229f, 0.055977f, 0.053975f, 0.050660f, 0.048149f, 0.046199f, 0.044662f, 0.043501f, 0.042685f, 0.041840f, 0.040659f, 0.039586f, 0.038976f, 0.040325f, 0.041280f, 0.044438f, 0.049413f, 0.050787f, 0.052912f, 0.054998f, 0.057645f, 0.063580f, 0.071924f, 0.076976f, 0.081620f, 0.089690f, 0.096795f, 0.101189f, 0.104063f, 0.106681f, 0.109790f, 0.110518f, 0.111175f, 0.113158f, 0.114890f, 0.114399f, 0.112359f, 0.108909f, 0.105092f, 0.100778f, 0.096583f, 0.092414f, 0.089085f, 0.084487f, 0.079962f, 0.076507f, 0.071953f, 0.071559f
, 0.079725f, 0.082785f, 0.085154f, 0.085853f, 0.085586f, 0.084603f, 0.082583f, 0.081956f, 0.080545f, 0.078069f, 0.075264f, 0.072016f, 0.069067f, 0.066026f, 0.062615f, 0.060797f, 0.060109f, 0.058722f, 0.056729f, 0.053538f, 0.051048f, 0.049247f, 0.047901f, 0.046899f, 0.046194f, 0.045254f, 0.043931f, 0.042721f, 0.042036f, 0.043160f, 0.044260f, 0.047367f, 0.052546f, 0.054522f, 0.057553f, 0.060506f, 0.064219f, 0.072464f, 0.083974f, 0.090871f, 0.096954f, 0.107018f, 0.116537f, 0.121884f, 0.125769f, 0.129367f, 0.133178f, 0.133899f, 0.134337f, 0.135846f, 0.136841f, 0.135288f, 0.132189f, 0.127358f, 0.122013f, 0.115973f, 0.110099f, 0.104263f, 0.099601f, 0.094114f, 0.089269f, 0.085023f, 0.080443f, 0.079710f
, 0.087588f, 0.090646f, 0.092759f, 0.093129f, 0.092627f, 0.091440f, 0.089142f, 0.088236f, 0.086507f, 0.083717f, 0.080478f, 0.076694f, 0.073245f, 0.069774f, 0.065835f, 0.063654f, 0.062900f, 0.061382f, 0.059400f, 0.056334f, 0.053866f, 0.052212f, 0.051054f, 0.050206f, 0.049610f, 0.048577f, 0.047116f, 0.045773f, 0.045018f, 0.045922f, 0.047186f, 0.050240f, 0.055582f, 0.058164f, 0.062095f, 0.065904f, 0.070667f, 0.081127f, 0.095650f, 0.104310f, 0.111760f, 0.123717f, 0.135550f, 0.141791f, 0.146628f, 0.151164f, 0.155644f, 0.156372f, 0.156608f, 0.157635f, 0.157895f, 0.155302f, 0.151184f, 0.145034f, 0.138238f, 0.130557f, 0.123080f, 0.115664f, 0.109731f, 0.103421f, 0.098302f, 0.093312f, 0.088754f, 0.087676f
, 0.095000f, 0.098023f, 0.099880f, 0.099929f, 0.099206f, 0.097827f, 0.095270f, 0.094103f, 0.092076f, 0.088994f, 0.085350f, 0.081063f, 0.077146f, 0.073272f, 0.068840f, 0.066318f, 0.065504f, 0.063864f, 0.061895f, 0.058949f, 0.056504f, 0.054989f, 0.054009f, 0.053308f, 0.052814f, 0.051695f, 0.050105f, 0.048640f, 0.047823f, 0.048523f, 0.049944f, 0.052934f, 0.058380f, 0.061520f, 0.066274f, 0.070860f, 0.076577f, 0.088970f, 0.106098f, 0.116306f, 0.124955f, 0.138543f, 0.152393f, 0.159410f, 0.165068f, 0.170428f, 0.175493f, 0.176249f, 0.176326f, 0.176912f, 0.176513f, 0.173001f, 0.168000f, 0.160720f, 0.152689f, 0.143611f, 0.134759f, 0.126008f, 0.118985f, 0.111999f, 0.106688f, 0.101078f, 0.096584f, 0.095178f
, 0.101687f, 0.104632f, 0.106243f, 0.105995f, 0.105073f, 0.103524f, 0.100737f, 0.099336f, 0.097044f, 0.093702f, 0.089695f, 0.084957f, 0.080622f, 0.076389f, 0.071515f, 0.068689f, 0.067823f, 0.066074f, 0.064120f, 0.061286f, 0.058863f, 0.057476f, 0.056658f, 0.056089f, 0.055688f, 0.054493f, 0.052791f, 0.051221f, 0.050352f, 0.050872f, 0.052419f, 0.055328f, 0.060796f, 0.064402f, 0.069826f, 0.075042f, 0.081538f, 0.095394f, 0.114464f, 0.125877f, 0.135458f, 0.150255f, 0.165624f, 0.173239f, 0.179518f, 0.185517f, 0.191032f, 0.191843f, 0.191828f, 0.192065f, 0.191159f, 0.186943f, 0.181294f, 0.173195f, 0.164288f, 0.154215f, 0.144368f, 0.134685f, 0.126875f, 0.119441f, 0.114057f, 0.108024f, 0.103631f, 0.101938f
, 0.107558f, 0.110369f, 0.111746f, 0.111230f, 0.110138f, 0.108446f, 0.105461f, 0.103861f, 0.101337f, 0.097770f, 0.093447f, 0.088319f, 0.083621f, 0.079078f, 0.073820f, 0.070731f, 0.069821f, 0.067980f, 0.066043f, 0.063310f, 0.060909f, 0.059635f, 0.058964f, 0.058511f, 0.058193f, 0.056934f, 0.055139f, 0.053484f, 0.052576f, 0.052945f, 0.054560f, 0.057361f, 0.062739f, 0.066673f, 0.072550f, 0.078187f, 0.085216f, 0.099877f, 0.119966f, 0.132118f, 0.142270f, 0.157693f, 0.173885f, 0.181862f, 0.188493f, 0.194874f, 0.200658f, 0.201561f, 0.201554f, 0.201582f, 0.200393f, 0.195787f, 0.189820f, 0.181346f, 0.172071f, 0.161577f, 0.151274f, 0.141229f, 0.133060f, 0.125500f, 0.120207f, 0.114031f, 0.109779f, 0.107854f
, 0.115367f, 0.117980f, 0.119156f, 0.118361f, 0.117053f, 0.115166f, 0.111909f, 0.110041f, 0.107204f, 0.103321f, 0.098571f, 0.092921f, 0.087734f, 0.082770f, 0.076998f, 0.073553f, 0.072578f, 0.070608f, 0.068673f, 0.066048f, 0.063663f, 0.062527f, 0.062032f, 0.061728f, 0.061514f, 0.060165f, 0.058232f, 0.056444f, 0.055460f, 0.055613f, 0.057200f, 0.059713f, 0.064549f, 0.068654f, 0.074680f, 0.080442f, 0.087695f, 0.101796f, 0.120930f, 0.133001f, 0.143097f, 0.157907f, 0.173519f, 0.181444f, 0.187886f, 0.194181f, 0.199924f, 0.201133f, 0.201424f, 0.201458f, 0.200372f, 0.195960f, 0.190402f, 0.182528f, 0.174105f, 0.164533f, 0.154991f, 0.146014f, 0.138474f, 0.131644f, 0.127039f, 0.121476f, 0.117607f, 0.115424f
, 0.122523f, 0.124962f, 0.126133f, 0.125197f, 0.123697f, 0.121619f, 0.118097f, 0.115974f, 0.112839f, 0.108645f, 0.103491f, 0.097363f, 0.091711f, 0.086349f, 0.080097f, 0.076319f, 0.075268f, 0.073167f, 0.071204f, 0.068637f, 0.066245f, 0.065217f, 0.064848f, 0.064669f, 0.064543f, 0.063100f, 0.061015f, 0.059065f, 0.057967f, 0.057899f, 0.059343f, 0.061401f, 0.065142f, 0.069088f, 0.074700f, 0.080038f, 0.086903f, 0.098371f, 0.113602f, 0.124210f, 0.133175f, 0.145529f, 0.158450f, 0.165612f, 0.171003f, 0.176445f, 0.181630f, 0.183384f, 0.184321f, 0.184680f, 0.184253f, 0.180900f, 0.176781f, 0.170872f, 0.164970f, 0.158167f, 0.151088f, 0.145111f, 0.139585f, 0.134620f, 0.131417f, 0.127484f, 0.124284f, 0.121903f
, 0.127363f, 0.129358f, 0.130397f, 0.129291f, 0.127668f, 0.125481f, 0.121804f, 0.119528f, 0.116212f, 0.111835f, 0.106435f, 0.100005f, 0.094072f, 0.088467f, 0.081919f, 0.077936f, 0.076849f, 0.074674f, 0.072716f, 0.070215f, 0.067834f, 0.066889f, 0.066624f, 0.066533f, 0.066469f, 0.064976f, 0.062814f, 0.060792f, 0.059655f, 0.059465f, 0.060737f, 0.062347f, 0.064883f, 0.068501f, 0.073418f, 0.078050f, 0.084162f, 0.092106f, 0.102138f, 0.110545f, 0.117794f, 0.126839f, 0.136071f, 0.142054f, 0.145969f, 0.150174f, 0.154493f, 0.156803f, 0.158511f, 0.159369f, 0.159902f, 0.158034f, 0.155796f, 0.152478f, 0.149765f, 0.146500f, 0.142617f, 0.140366f, 0.137420f, 0.134752f, 0.133137f, 0.131164f, 0.128728f, 0.126248f
, 0.129440f, 0.130352f, 0.130717f, 0.129165f, 0.127500f, 0.125338f, 0.121686f, 0.119410f, 0.116087f, 0.111741f, 0.106320f, 0.099821f, 0.093880f, 0.088265f, 0.081676f, 0.077678f, 0.076634f, 0.074487f, 0.072646f, 0.070300f, 0.068006f, 0.067150f, 0.067036f, 0.067008f, 0.066988f, 0.065523f, 0.063442f, 0.061551f, 0.060568f, 0.060443f, 0.061610f, 0.062940f, 0.064615f, 0.067972f, 0.072302f, 0.076305f, 0.081676f, 0.086612f, 0.092101f, 0.098404f, 0.103991f, 0.110041f, 0.115922f, 0.120695f, 0.123248f, 0.126315f, 0.129733f, 0.132388f, 0.134766f, 0.136103f, 0.137588f, 0.137101f, 0.136506f, 0.135561f, 0.135576f, 0.135409f, 0.134352f, 0.135205f, 0.134479f, 0.133773f, 0.133395f, 0.132951f, 0.131198f, 0.128715f
};

	for(int x=0; x < m_nSizeX; ++x)
		for(int z=0; z < m_nSizeZ; ++z)
			m_pData[z + x * m_nSizeZ] = data[z + x * m_nSizeZ];
	

	return S_OK;
}

//-----------------------------------------------------------------------------

float CHeightMap::GetData(int nZ, int nX) const
{
//	assert((nZ >= 0) && (nZ<m_nSizeZ));
//	assert((nX >= 0) && (nX<m_nSizeX));
	if(nZ < 0)
		nZ += m_nSizeZ;
	else if(nZ >= m_nSizeZ)
		nZ -= m_nSizeZ;
	if(nX < 0)
		nX += m_nSizeX;
	else if(nX >= m_nSizeX)
		nX -= m_nSizeX;

	return m_pData[nX * m_nSizeZ + nZ];
}

float CHeightMap::GetData(float fZ, float fX) const
{
// BAD::Can cause crash: if (fZ == fX == 1.0f)
//
	assert((fZ >= 0.0f) && (fZ < 1.0f));
	assert((fX >= 0.0f) && (fX < 1.0f));

	float scaledZ = fZ * m_nSizeZ;
	float scaledX = fX * m_nSizeX;
	int z0, z1, z2, z3;
	int x[4];

	z1 = (int)floor(scaledZ);
	z0 = z1 - 1;
	if(z0 < 0)
		z0 += m_nSizeZ;
	z2 = z1 + 1;
	if(z2 >= m_nSizeZ)
		z2 -= m_nSizeZ;
	z3 = z2 + 1;
	if(z3 >= m_nSizeZ)
		z3 -= m_nSizeZ;

	x[1] = (int)floor(scaledX);
	x[0] = x[1] - 1;
	if(x[0] < 0)
		x[0] += m_nSizeX;
	x[2] = x[1] + 1;
	if(x[2] >= m_nSizeX)
		x[2] -= m_nSizeX;
	x[3] = x[2] + 1;
	if(x[3] >= m_nSizeX)
		x[3] -= m_nSizeX;

	float tZ = scaledZ - z1;

	float h[4];
	for(int i = 0; i < 4; ++i)
	{
		h[i] = SplineInterpolation(tZ,
			m_pData[x[i] * m_nSizeZ + z0],
			m_pData[x[i] * m_nSizeZ + z1],
			m_pData[x[i] * m_nSizeZ + z2],
			m_pData[x[i] * m_nSizeZ + z3]);
	}

	float tX = scaledX - x[1];

	float H = SplineInterpolation(tX, h[0], h[1], h[2], h[3]);
	return H;
}

//-----------------------------------------------------------------------------

int	CHeightMap::GetSizeZ() const
{
	return m_nSizeZ;
}

//-----------------------------------------------------------------------------

int	CHeightMap::GetSizeX() const
{
	return m_nSizeX;
}

//-----------------------------------------------------------------------------

float CHeightMap::SplineInterpolation(	float SplineInterpolationValue	,
										float Height0, float Height1	,
										float Height2, float Height3	) const
{
	//////////////////////////////////////////////////////////////////
	// This function provides smooth interpolation between 4 points //
	//////////////////////////////////////////////////////////////////
	float SplineInterpolationValueSquared=SplineInterpolationValue*SplineInterpolationValue;
	float SplineInterpolationValueCubed=SplineInterpolationValueSquared*SplineInterpolationValue;

	return (float) (0.5 * ((-Height0 + 3.0*Height1 -3.0*Height2 + Height3)*SplineInterpolationValueCubed
						+ (2.0*Height0 -5.0*Height1 + 4.0*Height2 - Height3)*SplineInterpolationValueSquared
						+ (-Height0+Height2)*SplineInterpolationValue
						+ 2.0*Height1));
}
