//#include <d3dx9.h>
//#define DIRECTINPUT_VERSION 0x0800
//#include <dinput.h>
//#include "DXUtil.h"
#include <xtl.h>

#include "gamepad.h"

#include "Camera.h"
#include "Ship.h"
	#include "Shadow.h"
	#include "Altimeter.h"
	#include "FuelGuage.h"
	#include "GameOver.h"
#include "UniqGeom.h"
#include "Player.h"
#include "ViewPort.h"


#include ".\game.h"

//-----------------------------------------------------------------------------

CGame::CGame(void)
{
	m_bGameOver = true;
}

//-----------------------------------------------------------------------------

CGame::~CGame(void)
{
}

//-----------------------------------------------------------------------------

bool CGame::GameOver() const
{
	return(m_bGameOver);
}

//-----------------------------------------------------------------------------

void CGame::StartGame()
{
	m_bGameOver = false;
	m_Ship.FuelBonus(2.0f);
}

//-----------------------------------------------------------------------------

HRESULT CGame::Initialise(int anKeys[], D3DXVECTOR3 *pvecShip)
{
	if(anKeys)
	{
		//m_Player.SetKeyLeft  (anKeys[0]);
		//m_Player.SetKeyRight (anKeys[1]);
		//m_Player.SetKeyThrust(anKeys[2]);
	}
	if(pvecShip)
	{
		m_Ship.SetPosition(*pvecShip);
	}

	return(S_OK);
}

//-----------------------------------------------------------------------------

HRESULT CGame::InitDeviceObjects()
{
	HRESULT hr = S_OK;

	if((hr = m_UniqGeom.InitDeviceObjects()) != S_OK)
		return(hr);

	return(hr);
}

//-----------------------------------------------------------------------------

void CGame::DeleteDeviceObjects()
{
	m_UniqGeom.DeleteDeviceObjects();
}

//-----------------------------------------------------------------------------

HRESULT CGame::RestoreDeviceObjects(DWORD y, DWORD height, DWORD width)
{
	HRESULT hr = S_OK;

	// Activate (new) view, so UniqGeom can determine screen size
	m_ViewPort.SetViewPort(y, height, width);
	m_ViewPort.Activate();

	if((hr = m_UniqGeom.RestoreDeviceObjects()) != S_OK)
		return(hr);

	return(hr);
}

//-----------------------------------------------------------------------------

void CGame::InvalidateDeviceObjects()
{
	m_UniqGeom.InvalidateDeviceObjects();
}

//-----------------------------------------------------------------------------

void CGame::FrameMove(CGamePad *pPad, const CHeightMap &HeightMap, float fTime, bool bDemo)
{
//	if(!bDemo && !m_bGameOver)
//		m_Player.ProcessInput(Input, m_Ship);
	if(pPad->m_fY1 > 0.5f)
		m_Ship.Thrust();
	if(pPad->m_fX1 < 0.0f)
		m_Ship.TurnLeft();
	else if(pPad->m_fX1 > 0.0f)
		m_Ship.TurnRight();

	if(!m_bGameOver || bDemo)
	{
		m_Ship.MoveHorizontal(fTime);
		m_bGameOver = m_Ship.MoveVertical(HeightMap, fTime, bDemo);

		m_UniqGeom.FrameMove(m_Ship, HeightMap);
		m_Camera.FrameMove(m_Ship.GetPosition(), m_Ship.GetBearing());
	}
}

//-----------------------------------------------------------------------------

void CGame::ActivateViewPort() const
{
	m_ViewPort.Activate();
}

//-----------------------------------------------------------------------------

void CGame::FuelBonus(float fFuel)
{
	m_Ship.FuelBonus(fFuel);
}

//-----------------------------------------------------------------------------

const CCamera & CGame::GetCamera() const
{
	return(m_Camera);
}

//-----------------------------------------------------------------------------

const CShip & CGame::GetShip() const
{
	return(m_Ship);
}

//-----------------------------------------------------------------------------

const CUniqGeom & CGame::GetUniqGeom() const
{
	return(m_UniqGeom);
}

