//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>
#include "port.h"

#include ".\FuelTank.h"

#include "DxObjects.h"

//-----------------------------------------------------------------------------

CFuelTank::CFuelTank(void)
{
	m_dwFVF = D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE;

	m_pVB		= NULL;
	m_pIndexBuf	= NULL;

	ZeroMemory( &m_mtrl, sizeof(D3DMATERIAL8) );
	m_mtrl.Diffuse.r = m_mtrl.Ambient.r = 0.8f;
	m_mtrl.Diffuse.b = m_mtrl.Ambient.b = 0.8f;
	m_mtrl.Diffuse.g = m_mtrl.Ambient.g = 0.8f;
	m_mtrl.Diffuse.a = m_mtrl.Ambient.a = 1.0f;

	m_mtrl.Emissive.r = 0.1f;
	m_mtrl.Emissive.g = 0.0f;
	m_mtrl.Emissive.b = 0.3f;
	m_mtrl.Emissive.a = 1.0f;


	m_fScaleFactor	= 0.002f;
	m_fVertOffset	= -4.508030f * 0.5f;


	m_bRender = false;
}

//-----------------------------------------------------------------------------

CFuelTank::~CFuelTank(void)
{
}

//-----------------------------------------------------------------------------

HRESULT CFuelTank::InitDeviceObjects()
{
	HRESULT hr;
	if((hr = CreateVertexBuffer()) != S_OK)
	{
//        MessageBox(NULL, "FuelTank VBuf creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = CreateIndexBuffer()) != S_OK)
	{
//        MessageBox(NULL, "FuelTank IndBuf creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}

	m_bRender = true;

	return S_OK;
}

//-----------------------------------------------------------------------------

void CFuelTank::DeleteDeviceObjects()
{
	SAFE_RELEASE(m_pIndexBuf);
	SAFE_RELEASE(m_pVB);

	m_bRender = false;
}

//-----------------------------------------------------------------------------

void CFuelTank::Render(const D3DXMATRIX& matPickUp) const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		pDevice->SetRenderState(D3DRS_LIGHTING, true);
		pDevice->SetRenderState(D3DRS_FOGENABLE, true);

		pDevice->SetStreamSource(0, m_pVB, sizeof(CUSTOMVERTEX));
		pDevice->SetVertexShader(m_dwFVF);
		pDevice->SetIndices(m_pIndexBuf, 0);
		pDevice->SetTexture(0, NULL);
		pDevice->SetMaterial(&m_mtrl);

		D3DXMATRIX	matWorld;
		for(int z = -1; z < 2; ++z)
		{
			for(int x = -1; x < 2; ++x)
			{
				D3DXMatrixTranslation(&matWorld, (float)x, 0, (float)z);
				D3DXMatrixMultiply(&matWorld, &matPickUp, &matWorld);
				pDevice->SetTransform(D3DTS_WORLD, &matWorld);
				pDevice->DrawIndexedPrimitive(	D3DPT_TRIANGLELIST	,
												0, NUM_VERTS, 0,
												NUM_PRIMS			);
			}
		}

		//D3DXMATRIX	matWorld;
		//matWorld = matPickUp;
		//for(int z = -1; z < 2; ++z)
		//{
		//	for(int x = -1; x < 2; ++x)
		//	{
		//		matWorld._41 = matPickUp._41 + x;
		//		matWorld._43 = matPickUp._43 + z;
		//		pDevice->SetTransform(D3DTS_WORLD, &matWorld);
		//		pDevice->DrawIndexedPrimitive(	D3DPT_TRIANGLELIST	,
		//										0, 0, NUM_VERTS, 0,
		//										NUM_PRIMS			);
		//	}
		//}

		pDevice->SetRenderState(D3DRS_FOGENABLE, false);
		pDevice->SetRenderState(D3DRS_LIGHTING, false);
	}
}

//-----------------------------------------------------------------------------

HRESULT CFuelTank::CreateVertexBuffer()
{
	HRESULT hr;
	if((hr = CDxObjects::GetDevice()->CreateVertexBuffer
						(	NUM_VERTS * sizeof(CUSTOMVERTEX), 0		,
							m_dwFVF, D3DPOOL_MANAGED, &m_pVB)) != S_OK)
		return(hr);

	CFuelTank::CUSTOMVERTEX* pVertices;
	if((hr = m_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 )) != S_OK)
		return(hr);

	float fVerts[NUM_VERTS * 3] = {
   0.000000f,  4.508030f,  0.000000f,
   0.351364f,  4.473423f,  0.000000f,
   0.324618f,  4.473423f,  0.134461f,
   0.248452f,  4.473423f,  0.248452f,
   0.134461f,  4.473423f,  0.324618f,
   -0.000000f,  4.473423f,  0.351364f,
   -0.134461f,  4.473423f,  0.324618f,
   -0.248452f,  4.473423f,  0.248452f,
   -0.324618f,  4.473423f,  0.134461f,
   -0.351364f,  4.473423f,  -0.000000f,
   -0.324618f,  4.473423f,  -0.134461f,
   -0.248452f,  4.473423f,  -0.248452f,
   -0.134461f,  4.473423f,  -0.324618f,
   0.000000f,  4.473423f,  -0.351364f,
   0.134461f,  4.473423f,  -0.324618f,
   0.248452f,  4.473423f,  -0.248452f,
   0.324618f,  4.473423f,  -0.134461f,
   0.689225f,  4.370934f,  0.000000f,
   0.636760f,  4.370934f,  0.263755f,
   0.487355f,  4.370934f,  0.487355f,
   0.263755f,  4.370934f,  0.636761f,
   -0.000000f,  4.370934f,  0.689225f,
   -0.263755f,  4.370934f,  0.636760f,
   -0.487355f,  4.370934f,  0.487355f,
   -0.636761f,  4.370934f,  0.263755f,
   -0.689225f,  4.370934f,  -0.000000f,
   -0.636760f,  4.370934f,  -0.263755f,
   -0.487355f,  4.370934f,  -0.487355f,
   -0.263755f,  4.370934f,  -0.636761f,
   0.000000f,  4.370934f,  -0.689225f,
   0.263755f,  4.370934f,  -0.636760f,
   0.487355f,  4.370934f,  -0.487355f,
   0.636761f,  4.370934f,  -0.263755f,
   1.000599f,  4.204502f,  0.000000f,
   0.924433f,  4.204502f,  0.382913f,
   0.707530f,  4.204502f,  0.707530f,
   0.382913f,  4.204502f,  0.924433f,
   -0.000000f,  4.204502f,  1.000599f,
   -0.382913f,  4.204502f,  0.924433f,
   -0.707530f,  4.204502f,  0.707530f,
   -0.924433f,  4.204502f,  0.382913f,
   -1.000599f,  4.204502f,  -0.000000f,
   -0.924433f,  4.204502f,  -0.382913f,
   -0.707530f,  4.204502f,  -0.707530f,
   -0.382913f,  4.204502f,  -0.924433f,
   0.000000f,  4.204502f,  -1.000599f,
   0.382913f,  4.204502f,  -0.924433f,
   0.707530f,  4.204502f,  -0.707530f,
   0.924433f,  4.204502f,  -0.382913f,
   1.273521f,  3.980520f,  0.000000f,
   1.176580f,  3.980520f,  0.487355f,
   0.900515f,  3.980520f,  0.900515f,
   0.487355f,  3.980520f,  1.176580f,
   -0.000000f,  3.980520f,  1.273521f,
   -0.487355f,  3.980520f,  1.176580f,
   -0.900515f,  3.980520f,  0.900515f,
   -1.176580f,  3.980520f,  0.487355f,
   -1.273521f,  3.980520f,  -0.000000f,
   -1.176580f,  3.980520f,  -0.487356f,
   -0.900515f,  3.980520f,  -0.900515f,
   -0.487355f,  3.980520f,  -1.176580f,
   0.000000f,  3.980520f,  -1.273521f,
   0.487356f,  3.980520f,  -1.176580f,
   0.900515f,  3.980520f,  -0.900515f,
   1.176580f,  3.980520f,  -0.487355f,
   1.497502f,  3.707598f,  0.000000f,
   1.383512f,  3.707598f,  0.573069f,
   1.058894f,  3.707598f,  1.058894f,
   0.573069f,  3.707598f,  1.383512f,
   -0.000000f,  3.707598f,  1.497502f,
   -0.573069f,  3.707598f,  1.383512f,
   -1.058894f,  3.707598f,  1.058894f,
   -1.383512f,  3.707598f,  0.573069f,
   -1.497502f,  3.707598f,  -0.000000f,
   -1.383512f,  3.707598f,  -0.573069f,
   -1.058894f,  3.707598f,  -1.058894f,
   -0.573069f,  3.707598f,  -1.383512f,
   0.000000f,  3.707598f,  -1.497502f,
   0.573070f,  3.707598f,  -1.383512f,
   1.058894f,  3.707598f,  -1.058894f,
   1.383512f,  3.707598f,  -0.573069f,
   1.663935f,  3.396224f,  0.000000f,
   1.537276f,  3.396224f,  0.636761f,
   1.176580f,  3.396224f,  1.176580f,
   0.636760f,  3.396224f,  1.537276f,
   -0.000000f,  3.396224f,  1.663935f,
   -0.636761f,  3.396224f,  1.537276f,
   -1.176580f,  3.396224f,  1.176580f,
   -1.537276f,  3.396224f,  0.636760f,
   -1.663935f,  3.396224f,  -0.000000f,
   -1.537276f,  3.396224f,  -0.636761f,
   -1.176580f,  3.396224f,  -1.176580f,
   -0.636760f,  3.396224f,  -1.537276f,
   0.000000f,  3.396224f,  -1.663935f,
   0.636761f,  3.396224f,  -1.537276f,
   1.176580f,  3.396224f,  -1.176580f,
   1.537276f,  3.396224f,  -0.636760f,
   1.766424f,  3.058363f,  0.000000f,
   1.631963f,  3.058363f,  0.675981f,
   1.249051f,  3.058363f,  1.249051f,
   0.675981f,  3.058363f,  1.631963f,
   -0.000000f,  3.058363f,  1.766424f,
   -0.675981f,  3.058363f,  1.631963f,
   -1.249051f,  3.058363f,  1.249050f,
   -1.631963f,  3.058363f,  0.675981f,
   -1.766424f,  3.058363f,  -0.000000f,
   -1.631963f,  3.058363f,  -0.675981f,
   -1.249050f,  3.058363f,  -1.249051f,
   -0.675981f,  3.058363f,  -1.631963f,
   0.000000f,  3.058363f,  -1.766424f,
   0.675982f,  3.058363f,  -1.631963f,
   1.249051f,  3.058363f,  -1.249050f,
   1.631963f,  3.058363f,  -0.675981f,
   1.078739f,  2.563662f,  0.000000f,
   0.996625f,  2.563662f,  0.412816f,
   0.762784f,  2.563662f,  0.762784f,
   0.412816f,  2.563662f,  0.996625f,
   -0.000000f,  2.563662f,  1.078739f,
   -0.412816f,  2.563662f,  0.996625f,
   -0.762784f,  2.563662f,  0.762784f,
   -0.996625f,  2.563662f,  0.412816f,
   -1.078739f,  2.563662f,  -0.000000f,
   -0.996625f,  2.563662f,  -0.412816f,
   -0.762784f,  2.563662f,  -0.762784f,
   -0.412815f,  2.563662f,  -0.996625f,
   0.000000f,  2.563662f,  -1.078739f,
   0.412816f,  2.563662f,  -0.996625f,
   0.762784f,  2.563662f,  -0.762784f,
   0.996625f,  2.563662f,  -0.412815f,
   1.078739f,  1.944368f,  0.000000f,
   0.996625f,  1.944368f,  0.412816f,
   0.762784f,  1.944368f,  0.762784f,
   0.412816f,  1.944368f,  0.996625f,
   -0.000000f,  1.944368f,  1.078739f,
   -0.412816f,  1.944368f,  0.996625f,
   -0.762784f,  1.944368f,  0.762784f,
   -0.996625f,  1.944368f,  0.412816f,
   -1.078739f,  1.944368f,  -0.000000f,
   -0.996625f,  1.944368f,  -0.412816f,
   -0.762784f,  1.944368f,  -0.762784f,
   -0.412815f,  1.944368f,  -0.996625f,
   0.000000f,  1.944368f,  -1.078739f,
   0.412816f,  1.944368f,  -0.996625f,
   0.762784f,  1.944368f,  -0.762784f,
   0.996625f,  1.944368f,  -0.412815f,
   1.766424f,  1.449667f,  0.000000f,
   1.631963f,  1.449667f,  0.675981f,
   1.249051f,  1.449667f,  1.249051f,
   0.675981f,  1.449667f,  1.631963f,
   -0.000000f,  1.449667f,  1.766424f,
   -0.675981f,  1.449667f,  1.631963f,
   -1.249051f,  1.449667f,  1.249050f,
   -1.631963f,  1.449667f,  0.675981f,
   -1.766424f,  1.449667f,  -0.000000f,
   -1.631963f,  1.449667f,  -0.675981f,
   -1.249050f,  1.449667f,  -1.249051f,
   -0.675981f,  1.449667f,  -1.631963f,
   0.000000f,  1.449667f,  -1.766424f,
   0.675982f,  1.449667f,  -1.631963f,
   1.249051f,  1.449667f,  -1.249050f,
   1.631963f,  1.449667f,  -0.675981f,
   1.663935f,  1.111806f,  0.000000f,
   1.537276f,  1.111806f,  0.636761f,
   1.176580f,  1.111806f,  1.176580f,
   0.636760f,  1.111806f,  1.537276f,
   -0.000000f,  1.111806f,  1.663935f,
   -0.636761f,  1.111806f,  1.537276f,
   -1.176580f,  1.111806f,  1.176580f,
   -1.537276f,  1.111806f,  0.636760f,
   -1.663935f,  1.111806f,  -0.000000f,
   -1.537276f,  1.111806f,  -0.636761f,
   -1.176580f,  1.111806f,  -1.176580f,
   -0.636760f,  1.111806f,  -1.537276f,
   0.000000f,  1.111806f,  -1.663935f,
   0.636761f,  1.111806f,  -1.537276f,
   1.176580f,  1.111806f,  -1.176580f,
   1.537276f,  1.111806f,  -0.636760f,
   1.497502f,  0.800432f,  0.000000f,
   1.383512f,  0.800432f,  0.573069f,
   1.058894f,  0.800432f,  1.058894f,
   0.573069f,  0.800432f,  1.383512f,
   -0.000000f,  0.800432f,  1.497502f,
   -0.573069f,  0.800432f,  1.383512f,
   -1.058894f,  0.800432f,  1.058894f,
   -1.383512f,  0.800432f,  0.573069f,
   -1.497502f,  0.800432f,  -0.000000f,
   -1.383512f,  0.800432f,  -0.573069f,
   -1.058894f,  0.800432f,  -1.058894f,
   -0.573069f,  0.800432f,  -1.383512f,
   0.000000f,  0.800432f,  -1.497502f,
   0.573070f,  0.800432f,  -1.383512f,
   1.058894f,  0.800432f,  -1.058894f,
   1.383512f,  0.800432f,  -0.573069f,
   1.273521f,  0.527510f,  0.000000f,
   1.176580f,  0.527510f,  0.487355f,
   0.900515f,  0.527510f,  0.900515f,
   0.487355f,  0.527510f,  1.176580f,
   -0.000000f,  0.527510f,  1.273521f,
   -0.487355f,  0.527510f,  1.176580f,
   -0.900515f,  0.527510f,  0.900515f,
   -1.176580f,  0.527510f,  0.487355f,
   -1.273521f,  0.527510f,  -0.000000f,
   -1.176580f,  0.527510f,  -0.487356f,
   -0.900515f,  0.527510f,  -0.900515f,
   -0.487355f,  0.527510f,  -1.176580f,
   0.000000f,  0.527510f,  -1.273521f,
   0.487356f,  0.527510f,  -1.176580f,
   0.900515f,  0.527510f,  -0.900515f,
   1.176580f,  0.527510f,  -0.487355f,
   1.000599f,  0.303528f,  0.000000f,
   0.924433f,  0.303528f,  0.382913f,
   0.707530f,  0.303528f,  0.707530f,
   0.382913f,  0.303528f,  0.924433f,
   -0.000000f,  0.303528f,  1.000599f,
   -0.382913f,  0.303528f,  0.924433f,
   -0.707530f,  0.303528f,  0.707530f,
   -0.924433f,  0.303528f,  0.382913f,
   -1.000599f,  0.303528f,  -0.000000f,
   -0.924433f,  0.303528f,  -0.382913f,
   -0.707530f,  0.303528f,  -0.707530f,
   -0.382913f,  0.303528f,  -0.924433f,
   0.000000f,  0.303528f,  -1.000599f,
   0.382913f,  0.303528f,  -0.924433f,
   0.707530f,  0.303528f,  -0.707530f,
   0.924433f,  0.303528f,  -0.382913f,
   0.689225f,  0.137095f,  0.000000f,
   0.636760f,  0.137095f,  0.263755f,
   0.487355f,  0.137095f,  0.487355f,
   0.263755f,  0.137095f,  0.636761f,
   -0.000000f,  0.137095f,  0.689225f,
   -0.263755f,  0.137095f,  0.636760f,
   -0.487355f,  0.137095f,  0.487355f,
   -0.636761f,  0.137095f,  0.263755f,
   -0.689225f,  0.137095f,  -0.000000f,
   -0.636760f,  0.137095f,  -0.263755f,
   -0.487355f,  0.137095f,  -0.487355f,
   -0.263755f,  0.137095f,  -0.636761f,
   0.000000f,  0.137095f,  -0.689225f,
   0.263755f,  0.137095f,  -0.636760f,
   0.487355f,  0.137095f,  -0.487355f,
   0.636761f,  0.137095f,  -0.263755f,
   0.351364f,  0.034606f,  0.000000f,
   0.324618f,  0.034606f,  0.134461f,
   0.248452f,  0.034606f,  0.248452f,
   0.134461f,  0.034606f,  0.324618f,
   -0.000000f,  0.034606f,  0.351364f,
   -0.134461f,  0.034606f,  0.324618f,
   -0.248452f,  0.034606f,  0.248452f,
   -0.324618f,  0.034606f,  0.134461f,
   -0.351364f,  0.034606f,  -0.000000f,
   -0.324618f,  0.034606f,  -0.134461f,
   -0.248452f,  0.034606f,  -0.248452f,
   -0.134461f,  0.034606f,  -0.324618f,
   0.000000f,  0.034606f,  -0.351364f,
   0.134461f,  0.034606f,  -0.324618f,
   0.248452f,  0.034606f,  -0.248452f,
   0.324618f,  0.034606f,  -0.134461f,
   0.000000f,  0.000000f,  0.000000f
	};


	float fNorms[NUM_VERTS * 3] = {
   -0.000000f, -1.000000f, 0.000000f,
   -0.195019f, -0.980799f, -0.000000f,
   -0.180174f, -0.980799f, -0.074631f,
   -0.137899f, -0.980799f, -0.137899f,
   -0.074631f, -0.980799f, -0.180174f,
   0.000000f, -0.980799f, -0.195019f,
   0.074631f, -0.980799f, -0.180174f,
   0.137900f, -0.980799f, -0.137899f,
   0.180174f, -0.980799f, -0.074631f,
   0.195019f, -0.980799f, 0.000000f,
   0.180174f, -0.980799f, 0.074631f,
   0.137899f, -0.980799f, 0.137900f,
   0.074631f, -0.980799f, 0.180174f,
   -0.000000f, -0.980799f, 0.195019f,
   -0.074631f, -0.980799f, 0.180174f,
   -0.137900f, -0.980799f, 0.137899f,
   -0.180174f, -0.980799f, 0.074631f,
   -0.382560f, -0.923931f, -0.000000f,
   -0.353439f, -0.923931f, -0.146399f,
   -0.270511f, -0.923931f, -0.270511f,
   -0.146399f, -0.923931f, -0.353439f,
   0.000000f, -0.923931f, -0.382560f,
   0.146399f, -0.923931f, -0.353439f,
   0.270511f, -0.923931f, -0.270511f,
   0.353439f, -0.923931f, -0.146399f,
   0.382560f, -0.923931f, 0.000000f,
   0.353439f, -0.923931f, 0.146399f,
   0.270510f, -0.923931f, 0.270511f,
   0.146399f, -0.923931f, 0.353439f,
   -0.000000f, -0.923931f, 0.382560f,
   -0.146399f, -0.923931f, 0.353439f,
   -0.270511f, -0.923931f, 0.270510f,
   -0.353439f, -0.923931f, 0.146399f,
   -0.555426f, -0.831566f, -0.000000f,
   -0.513147f, -0.831566f, -0.212552f,
   -0.392745f, -0.831566f, -0.392745f,
   -0.212552f, -0.831566f, -0.513147f,
   0.000000f, -0.831566f, -0.555426f,
   0.212552f, -0.831566f, -0.513147f,
   0.392745f, -0.831566f, -0.392745f,
   0.513147f, -0.831566f, -0.212552f,
   0.555426f, -0.831566f, 0.000000f,
   0.513147f, -0.831566f, 0.212552f,
   0.392745f, -0.831566f, 0.392745f,
   0.212552f, -0.831566f, 0.513147f,
   -0.000000f, -0.831566f, 0.555426f,
   -0.212552f, -0.831566f, 0.513147f,
   -0.392745f, -0.831566f, 0.392745f,
   -0.513147f, -0.831566f, 0.212552f,
   -0.706975f, -0.707238f, -0.000000f,
   -0.653160f, -0.707238f, -0.270548f,
   -0.499907f, -0.707238f, -0.499907f,
   -0.270548f, -0.707238f, -0.653160f,
   0.000000f, -0.707238f, -0.706975f,
   0.270548f, -0.707238f, -0.653160f,
   0.499907f, -0.707238f, -0.499907f,
   0.653160f, -0.707238f, -0.270548f,
   0.706975f, -0.707238f, 0.000000f,
   0.653160f, -0.707238f, 0.270548f,
   0.499907f, -0.707238f, 0.499907f,
   0.270548f, -0.707238f, 0.653160f,
   -0.000000f, -0.707238f, 0.706975f,
   -0.270548f, -0.707238f, 0.653160f,
   -0.499907f, -0.707238f, 0.499907f,
   -0.653160f, -0.707238f, 0.270548f,
   -0.831375f, -0.555712f, -0.000000f,
   -0.768090f, -0.555712f, -0.318153f,
   -0.587871f, -0.555712f, -0.587871f,
   -0.318153f, -0.555712f, -0.768090f,
   0.000000f, -0.555712f, -0.831375f,
   0.318153f, -0.555712f, -0.768090f,
   0.587871f, -0.555712f, -0.587871f,
   0.768090f, -0.555712f, -0.318153f,
   0.831375f, -0.555712f, 0.000000f,
   0.768090f, -0.555712f, 0.318153f,
   0.587871f, -0.555712f, 0.587871f,
   0.318153f, -0.555712f, 0.768090f,
   -0.000000f, -0.555712f, 0.831375f,
   -0.318153f, -0.555712f, 0.768090f,
   -0.587871f, -0.555712f, 0.587871f,
   -0.768090f, -0.555712f, 0.318153f,
   -0.923830f, -0.382803f, -0.000000f,
   -0.853507f, -0.382803f, -0.353534f,
   -0.653246f, -0.382803f, -0.653246f,
   -0.353534f, -0.382803f, -0.853507f,
   0.000000f, -0.382803f, -0.923830f,
   0.353534f, -0.382803f, -0.853507f,
   0.653246f, -0.382804f, -0.653246f,
   0.853507f, -0.382803f, -0.353534f,
   0.923830f, -0.382803f, 0.000000f,
   0.853507f, -0.382803f, 0.353534f,
   0.653246f, -0.382803f, 0.653246f,
   0.353534f, -0.382803f, 0.853508f,
   -0.000000f, -0.382803f, 0.923830f,
   -0.353535f, -0.382803f, 0.853507f,
   -0.653246f, -0.382803f, 0.653246f,
   -0.853507f, -0.382804f, 0.353534f,
   -0.945945f, 0.324326f, -0.000000f,
   -0.873940f, 0.324326f, -0.361998f,
   -0.668884f, 0.324326f, -0.668884f,
   -0.361998f, 0.324326f, -0.873940f,
   0.000000f, 0.324326f, -0.945945f,
   0.361998f, 0.324326f, -0.873940f,
   0.668884f, 0.324326f, -0.668884f,
   0.873940f, 0.324326f, -0.361997f,
   0.945945f, 0.324326f, 0.000000f,
   0.873940f, 0.324326f, 0.361998f,
   0.668884f, 0.324326f, 0.668885f,
   0.361997f, 0.324326f, 0.873940f,
   -0.000000f, 0.324326f, 0.945945f,
   -0.361998f, 0.324326f, 0.873939f,
   -0.668885f, 0.324326f, 0.668884f,
   -0.873940f, 0.324326f, 0.361998f,
   -0.888446f, 0.458981f, -0.000000f,
   -0.820817f, 0.458981f, -0.339994f,
   -0.628226f, 0.458981f, -0.628226f,
   -0.339994f, 0.458981f, -0.820817f,
   0.000000f, 0.458981f, -0.888446f,
   0.339994f, 0.458981f, -0.820817f,
   0.628226f, 0.458981f, -0.628226f,
   0.820817f, 0.458981f, -0.339993f,
   0.888446f, 0.458981f, 0.000000f,
   0.820817f, 0.458981f, 0.339994f,
   0.628226f, 0.458981f, 0.628226f,
   0.339993f, 0.458981f, 0.820817f,
   -0.000000f, 0.458981f, 0.888446f,
   -0.339994f, 0.458981f, 0.820817f,
   -0.628226f, 0.458981f, 0.628226f,
   -0.820817f, 0.458981f, 0.339994f,
   -0.888446f, -0.458981f, -0.000000f,
   -0.820817f, -0.458981f, -0.339994f,
   -0.628226f, -0.458981f, -0.628226f,
   -0.339994f, -0.458981f, -0.820817f,
   0.000000f, -0.458981f, -0.888446f,
   0.339994f, -0.458981f, -0.820817f,
   0.628226f, -0.458981f, -0.628226f,
   0.820817f, -0.458981f, -0.339993f,
   0.888446f, -0.458981f, 0.000000f,
   0.820817f, -0.458981f, 0.339994f,
   0.628226f, -0.458981f, 0.628226f,
   0.339993f, -0.458981f, 0.820817f,
   -0.000000f, -0.458981f, 0.888446f,
   -0.339994f, -0.458981f, 0.820817f,
   -0.628226f, -0.458981f, 0.628226f,
   -0.820817f, -0.458981f, 0.339993f,
   -0.945945f, -0.324326f, -0.000000f,
   -0.873940f, -0.324326f, -0.361998f,
   -0.668884f, -0.324326f, -0.668884f,
   -0.361998f, -0.324326f, -0.873940f,
   0.000000f, -0.324326f, -0.945945f,
   0.361998f, -0.324326f, -0.873940f,
   0.668884f, -0.324326f, -0.668884f,
   0.873940f, -0.324326f, -0.361998f,
   0.945945f, -0.324326f, 0.000000f,
   0.873940f, -0.324326f, 0.361998f,
   0.668884f, -0.324326f, 0.668885f,
   0.361998f, -0.324326f, 0.873940f,
   -0.000000f, -0.324326f, 0.945945f,
   -0.361998f, -0.324326f, 0.873940f,
   -0.668885f, -0.324326f, 0.668884f,
   -0.873940f, -0.324326f, 0.361998f,
   -0.923830f, 0.382803f, -0.000000f,
   -0.853507f, 0.382803f, -0.353534f,
   -0.653246f, 0.382803f, -0.653246f,
   -0.353534f, 0.382803f, -0.853507f,
   0.000000f, 0.382803f, -0.923830f,
   0.353534f, 0.382803f, -0.853507f,
   0.653246f, 0.382803f, -0.653246f,
   0.853507f, 0.382803f, -0.353534f,
   0.923830f, 0.382803f, 0.000000f,
   0.853507f, 0.382803f, 0.353534f,
   0.653246f, 0.382803f, 0.653246f,
   0.353534f, 0.382803f, 0.853507f,
   -0.000000f, 0.382803f, 0.923830f,
   -0.353535f, 0.382803f, 0.853507f,
   -0.653246f, 0.382803f, 0.653246f,
   -0.853507f, 0.382804f, 0.353534f,
   -0.831375f, 0.555712f, -0.000000f,
   -0.768090f, 0.555712f, -0.318153f,
   -0.587871f, 0.555712f, -0.587871f,
   -0.318153f, 0.555712f, -0.768090f,
   0.000000f, 0.555712f, -0.831375f,
   0.318153f, 0.555712f, -0.768090f,
   0.587871f, 0.555712f, -0.587871f,
   0.768090f, 0.555712f, -0.318153f,
   0.831375f, 0.555712f, 0.000000f,
   0.768090f, 0.555712f, 0.318153f,
   0.587871f, 0.555712f, 0.587871f,
   0.318153f, 0.555712f, 0.768090f,
   -0.000000f, 0.555712f, 0.831375f,
   -0.318153f, 0.555712f, 0.768090f,
   -0.587871f, 0.555712f, 0.587871f,
   -0.768090f, 0.555712f, 0.318153f,
   -0.706975f, 0.707238f, -0.000000f,
   -0.653160f, 0.707238f, -0.270548f,
   -0.499907f, 0.707238f, -0.499907f,
   -0.270548f, 0.707238f, -0.653160f,
   0.000000f, 0.707238f, -0.706975f,
   0.270548f, 0.707238f, -0.653160f,
   0.499907f, 0.707238f, -0.499907f,
   0.653160f, 0.707238f, -0.270548f,
   0.706975f, 0.707238f, 0.000000f,
   0.653160f, 0.707238f, 0.270548f,
   0.499907f, 0.707238f, 0.499907f,
   0.270548f, 0.707238f, 0.653160f,
   -0.000000f, 0.707238f, 0.706975f,
   -0.270548f, 0.707238f, 0.653160f,
   -0.499907f, 0.707238f, 0.499907f,
   -0.653160f, 0.707238f, 0.270548f,
   -0.555426f, 0.831566f, -0.000000f,
   -0.513147f, 0.831566f, -0.212552f,
   -0.392745f, 0.831566f, -0.392745f,
   -0.212552f, 0.831566f, -0.513147f,
   0.000000f, 0.831566f, -0.555426f,
   0.212552f, 0.831566f, -0.513147f,
   0.392745f, 0.831566f, -0.392745f,
   0.513147f, 0.831566f, -0.212552f,
   0.555426f, 0.831566f, 0.000000f,
   0.513147f, 0.831566f, 0.212552f,
   0.392745f, 0.831566f, 0.392745f,
   0.212552f, 0.831566f, 0.513147f,
   -0.000000f, 0.831566f, 0.555426f,
   -0.212552f, 0.831566f, 0.513147f,
   -0.392745f, 0.831566f, 0.392745f,
   -0.513147f, 0.831566f, 0.212552f,
   -0.382560f, 0.923931f, -0.000000f,
   -0.353439f, 0.923931f, -0.146399f,
   -0.270511f, 0.923931f, -0.270511f,
   -0.146399f, 0.923931f, -0.353439f,
   0.000000f, 0.923931f, -0.382560f,
   0.146399f, 0.923931f, -0.353439f,
   0.270511f, 0.923931f, -0.270511f,
   0.353439f, 0.923931f, -0.146399f,
   0.382560f, 0.923931f, 0.000000f,
   0.353439f, 0.923931f, 0.146399f,
   0.270511f, 0.923931f, 0.270511f,
   0.146399f, 0.923931f, 0.353439f,
   -0.000000f, 0.923931f, 0.382560f,
   -0.146399f, 0.923931f, 0.353439f,
   -0.270511f, 0.923931f, 0.270511f,
   -0.353439f, 0.923931f, 0.146399f,
   -0.195019f, 0.980799f, 0.000000f,
   -0.180174f, 0.980799f, -0.074631f,
   -0.137900f, 0.980799f, -0.137899f,
   -0.074631f, 0.980799f, -0.180174f,
   0.000000f, 0.980799f, -0.195019f,
   0.074631f, 0.980799f, -0.180174f,
   0.137900f, 0.980799f, -0.137899f,
   0.180174f, 0.980799f, -0.074631f,
   0.195019f, 0.980799f, 0.000000f,
   0.180174f, 0.980799f, 0.074631f,
   0.137899f, 0.980799f, 0.137900f,
   0.074631f, 0.980799f, 0.180174f,
   -0.000000f, 0.980799f, 0.195019f,
   -0.074631f, 0.980799f, 0.180174f,
   -0.137900f, 0.980799f, 0.137899f,
   -0.180174f, 0.980799f, 0.074631f,
   -0.000000f, 1.000000f, 0.000000f
	};

	for(int i=0; i < NUM_VERTS; ++i)
	{
		pVertices[i].position.x = fVerts[i*3] * m_fScaleFactor;
		pVertices[i].position.y = (fVerts[i*3 + 1]  + m_fVertOffset) * m_fScaleFactor;
		pVertices[i].position.z = fVerts[i*3 + 2] * m_fScaleFactor;

		pVertices[i].normal.x = -fNorms[i*3];
		pVertices[i].normal.y = -fNorms[i*3 + 1];
		pVertices[i].normal.z = -fNorms[i*3 + 2];

		pVertices[i].diffuse = D3DCOLOR_RGBA(255, 255, 255, 255);
	}
	m_pVB->Unlock();

	return S_OK;
}

//-----------------------------------------------------------------------------

HRESULT CFuelTank::CreateIndexBuffer()
{
	int nIndices[NUM_PRIMS * 3] = {
				1,2,0,
				2,3,0,
				3,4,0,
				4,5,0,
				5,6,0,
				6,7,0,
				7,8,0,
				8,9,0,
				9,10,0,
				10,11,0,
				11,12,0,
				12,13,0,
				13,14,0,
				14,15,0,
				15,16,0,
				16,1,0,
				17,18,1,
				18,2,1,
				18,19,2,
				19,3,2,
				19,20,3,
				20,4,3,
				20,21,4,
				21,5,4,
				21,22,5,
				22,6,5,
				22,23,6,
				23,7,6,
				23,24,7,
				24,8,7,
				24,25,8,
				25,9,8,
				25,26,9,
				26,10,9,
				26,27,10,
				27,11,10,
				27,28,11,
				28,12,11,
				28,29,12,
				29,13,12,
				29,30,13,
				30,14,13,
				30,31,14,
				31,15,14,
				31,32,15,
				32,16,15,
				32,17,16,
				17,1,16,
				33,34,17,
				34,18,17,
				34,35,18,
				35,19,18,
				35,36,19,
				36,20,19,
				36,37,20,
				37,21,20,
				37,38,21,
				38,22,21,
				38,39,22,
				39,23,22,
				39,40,23,
				40,24,23,
				40,41,24,
				41,25,24,
				41,42,25,
				42,26,25,
				42,43,26,
				43,27,26,
				43,44,27,
				44,28,27,
				44,45,28,
				45,29,28,
				45,46,29,
				46,30,29,
				46,47,30,
				47,31,30,
				47,48,31,
				48,32,31,
				48,33,32,
				33,17,32,
				49,50,33,
				50,34,33,
				50,51,34,
				51,35,34,
				51,52,35,
				52,36,35,
				52,53,36,
				53,37,36,
				53,54,37,
				54,38,37,
				54,55,38,
				55,39,38,
				55,56,39,
				56,40,39,
				56,57,40,
				57,41,40,
				57,58,41,
				58,42,41,
				58,59,42,
				59,43,42,
				59,60,43,
				60,44,43,
				60,61,44,
				61,45,44,
				61,62,45,
				62,46,45,
				62,63,46,
				63,47,46,
				63,64,47,
				64,48,47,
				64,49,48,
				49,33,48,
				65,66,49,
				66,50,49,
				66,67,50,
				67,51,50,
				67,68,51,
				68,52,51,
				68,69,52,
				69,53,52,
				69,70,53,
				70,54,53,
				70,71,54,
				71,55,54,
				71,72,55,
				72,56,55,
				72,73,56,
				73,57,56,
				73,74,57,
				74,58,57,
				74,75,58,
				75,59,58,
				75,76,59,
				76,60,59,
				76,77,60,
				77,61,60,
				77,78,61,
				78,62,61,
				78,79,62,
				79,63,62,
				79,80,63,
				80,64,63,
				80,65,64,
				65,49,64,
				81,82,65,
				82,66,65,
				82,83,66,
				83,67,66,
				83,84,67,
				84,68,67,
				84,85,68,
				85,69,68,
				85,86,69,
				86,70,69,
				86,87,70,
				87,71,70,
				87,88,71,
				88,72,71,
				88,89,72,
				89,73,72,
				89,90,73,
				90,74,73,
				90,91,74,
				91,75,74,
				91,92,75,
				92,76,75,
				92,93,76,
				93,77,76,
				93,94,77,
				94,78,77,
				94,95,78,
				95,79,78,
				95,96,79,
				96,80,79,
				96,81,80,
				81,65,80,
				97,98,81,
				98,82,81,
				98,99,82,
				99,83,82,
				99,100,83,
				100,84,83,
				100,101,84,
				101,85,84,
				101,102,85,
				102,86,85,
				102,103,86,
				103,87,86,
				103,104,87,
				104,88,87,
				104,105,88,
				105,89,88,
				105,106,89,
				106,90,89,
				106,107,90,
				107,91,90,
				107,108,91,
				108,92,91,
				108,109,92,
				109,93,92,
				109,110,93,
				110,94,93,
				110,111,94,
				111,95,94,
				111,112,95,
				112,96,95,
				112,97,96,
				97,81,96,
				113,114,97,
				114,98,97,
				114,115,98,
				115,99,98,
				115,116,99,
				116,100,99,
				116,117,100,
				117,101,100,
				117,118,101,
				118,102,101,
				118,119,102,
				119,103,102,
				119,120,103,
				120,104,103,
				120,121,104,
				121,105,104,
				121,122,105,
				122,106,105,
				122,123,106,
				123,107,106,
				123,124,107,
				124,108,107,
				124,125,108,
				125,109,108,
				125,126,109,
				126,110,109,
				126,127,110,
				127,111,110,
				127,128,111,
				128,112,111,
				128,113,112,
				113,97,112,
				129,130,113,
				130,114,113,
				130,131,114,
				131,115,114,
				131,132,115,
				132,116,115,
				132,133,116,
				133,117,116,
				133,134,117,
				134,118,117,
				134,135,118,
				135,119,118,
				135,136,119,
				136,120,119,
				136,137,120,
				137,121,120,
				137,138,121,
				138,122,121,
				138,139,122,
				139,123,122,
				139,140,123,
				140,124,123,
				140,141,124,
				141,125,124,
				141,142,125,
				142,126,125,
				142,143,126,
				143,127,126,
				143,144,127,
				144,128,127,
				144,129,128,
				129,113,128,
				145,146,129,
				146,130,129,
				146,147,130,
				147,131,130,
				147,148,131,
				148,132,131,
				148,149,132,
				149,133,132,
				149,150,133,
				150,134,133,
				150,151,134,
				151,135,134,
				151,152,135,
				152,136,135,
				152,153,136,
				153,137,136,
				153,154,137,
				154,138,137,
				154,155,138,
				155,139,138,
				155,156,139,
				156,140,139,
				156,157,140,
				157,141,140,
				157,158,141,
				158,142,141,
				158,159,142,
				159,143,142,
				159,160,143,
				160,144,143,
				160,145,144,
				145,129,144,
				161,162,145,
				162,146,145,
				162,163,146,
				163,147,146,
				163,164,147,
				164,148,147,
				164,165,148,
				165,149,148,
				165,166,149,
				166,150,149,
				166,167,150,
				167,151,150,
				167,168,151,
				168,152,151,
				168,169,152,
				169,153,152,
				169,170,153,
				170,154,153,
				170,171,154,
				171,155,154,
				171,172,155,
				172,156,155,
				172,173,156,
				173,157,156,
				173,174,157,
				174,158,157,
				174,175,158,
				175,159,158,
				175,176,159,
				176,160,159,
				176,161,160,
				161,145,160,
				177,178,161,
				178,162,161,
				178,179,162,
				179,163,162,
				179,180,163,
				180,164,163,
				180,181,164,
				181,165,164,
				181,182,165,
				182,166,165,
				182,183,166,
				183,167,166,
				183,184,167,
				184,168,167,
				184,185,168,
				185,169,168,
				185,186,169,
				186,170,169,
				186,187,170,
				187,171,170,
				187,188,171,
				188,172,171,
				188,189,172,
				189,173,172,
				189,190,173,
				190,174,173,
				190,191,174,
				191,175,174,
				191,192,175,
				192,176,175,
				192,177,176,
				177,161,176,
				193,194,177,
				194,178,177,
				194,195,178,
				195,179,178,
				195,196,179,
				196,180,179,
				196,197,180,
				197,181,180,
				197,198,181,
				198,182,181,
				198,199,182,
				199,183,182,
				199,200,183,
				200,184,183,
				200,201,184,
				201,185,184,
				201,202,185,
				202,186,185,
				202,203,186,
				203,187,186,
				203,204,187,
				204,188,187,
				204,205,188,
				205,189,188,
				205,206,189,
				206,190,189,
				206,207,190,
				207,191,190,
				207,208,191,
				208,192,191,
				208,193,192,
				193,177,192,
				209,210,193,
				210,194,193,
				210,211,194,
				211,195,194,
				211,212,195,
				212,196,195,
				212,213,196,
				213,197,196,
				213,214,197,
				214,198,197,
				214,215,198,
				215,199,198,
				215,216,199,
				216,200,199,
				216,217,200,
				217,201,200,
				217,218,201,
				218,202,201,
				218,219,202,
				219,203,202,
				219,220,203,
				220,204,203,
				220,221,204,
				221,205,204,
				221,222,205,
				222,206,205,
				222,223,206,
				223,207,206,
				223,224,207,
				224,208,207,
				224,209,208,
				209,193,208,
				225,226,209,
				226,210,209,
				226,227,210,
				227,211,210,
				227,228,211,
				228,212,211,
				228,229,212,
				229,213,212,
				229,230,213,
				230,214,213,
				230,231,214,
				231,215,214,
				231,232,215,
				232,216,215,
				232,233,216,
				233,217,216,
				233,234,217,
				234,218,217,
				234,235,218,
				235,219,218,
				235,236,219,
				236,220,219,
				236,237,220,
				237,221,220,
				237,238,221,
				238,222,221,
				238,239,222,
				239,223,222,
				239,240,223,
				240,224,223,
				240,225,224,
				225,209,224,
				241,242,225,
				242,226,225,
				242,243,226,
				243,227,226,
				243,244,227,
				244,228,227,
				244,245,228,
				245,229,228,
				245,246,229,
				246,230,229,
				246,247,230,
				247,231,230,
				247,248,231,
				248,232,231,
				248,249,232,
				249,233,232,
				249,250,233,
				250,234,233,
				250,251,234,
				251,235,234,
				251,252,235,
				252,236,235,
				252,253,236,
				253,237,236,
				253,254,237,
				254,238,237,
				254,255,238,
				255,239,238,
				255,256,239,
				256,240,239,
				256,241,240,
				241,225,240,
				257,242,241,
				257,243,242,
				257,244,243,
				257,245,244,
				257,246,245,
				257,247,246,
				257,248,247,
				257,249,248,
				257,250,249,
				257,251,250,
				257,252,251,
				257,253,252,
				257,254,253,
				257,255,254,
				257,256,255,
				257,241,256
};


	
	HRESULT hr;
	if((hr = CDxObjects::GetDevice()->CreateIndexBuffer(NUM_PRIMS * 3 * sizeof(WORD),
							D3DUSAGE_WRITEONLY, D3DFMT_INDEX16, D3DPOOL_MANAGED,
							&m_pIndexBuf)) != S_OK)
		return(hr);

	WORD *pIndices = NULL;
	if((hr = m_pIndexBuf->Lock(0, 0, (BYTE**)&pIndices, 0)) != S_OK)
		return(hr);

	for(int i=0; i < NUM_PRIMS * 3; ++i)
		pIndices[i] = (WORD)nIndices[i];

	m_pIndexBuf->Unlock();

	return(S_OK);
}
