//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>
#include "port.h"


#include ".\CloudBox.h"

#include "DxObjects.h"
//-----------------------------------------------------------------------------
// y-values for CloudBox sections...
#define BOTTOM	-0.5f
#define HALFWAY	-0.05f
#define TOP		0.4f

// BOTTOM & HALFWAY = OPAKUE, TOP = TRANSP(arent)...
#define OPAKUE		D3DCOLOR_RGBA(255, 255, 255, 255)
#define TRANSP		D3DCOLOR_RGBA(255, 255, 255, 0)
//-----------------------------------------------------------------------------

CCloudBox::CCloudBox(void)
{
	m_dwFVF = D3DFVF_XYZ|D3DFVF_DIFFUSE;
	m_pVB	= NULL;

	m_bRender = false;
}

//-----------------------------------------------------------------------------

CCloudBox::~CCloudBox(void)
{
}

//-----------------------------------------------------------------------------

HRESULT CCloudBox::InitDeviceObjects()
{
	HRESULT hr;
	if((hr = CreateVertexBuffer()) != S_OK)
	{
//        MessageBox(NULL, "CloudBox VBuf creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}

	m_bRender = true;

	return S_OK;
}

//-----------------------------------------------------------------------------

void CCloudBox::DeleteDeviceObjects()
{
	SAFE_RELEASE(m_pVB);

	m_bRender=false;
}

//-----------------------------------------------------------------------------

void CCloudBox::Render() const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

		pDevice->SetTexture(0, NULL);
		pDevice->SetStreamSource(0, m_pVB, sizeof(CUSTOMVERTEX));
		pDevice->SetVertexShader(m_dwFVF);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, NUM_PRIMS);

		pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
	}
}

//-----------------------------------------------------------------------------

HRESULT CCloudBox::CreateVertexBuffer()
{
	HRESULT hr;
	if((hr = CDxObjects::GetDevice()->CreateVertexBuffer(	NUM_VERTS * sizeof(CUSTOMVERTEX), 0		,
															m_dwFVF, D3DPOOL_MANAGED, &m_pVB)) != S_OK)
		return(hr);

	CCloudBox::CUSTOMVERTEX* pVertices;
	if((hr = m_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 )) != S_OK)
		return(hr);

	// Anti-clockwise triangle list..
	float fVerts[NUM_VERTS * 3] = {
		// Front
			 1.0f, BOTTOM ,  1.0f,  1.0f, HALFWAY,  1.0f, -1.0f, BOTTOM ,  1.0f,
			-1.0f, BOTTOM ,  1.0f,  1.0f, HALFWAY,  1.0f, -1.0f, HALFWAY,  1.0f,
			 1.0f, HALFWAY,  1.0f,  1.0f, TOP    ,  1.0f, -1.0f, HALFWAY,  1.0f,
			-1.0f, HALFWAY,  1.0f,  1.0f, TOP    ,  1.0f, -1.0f, TOP    ,  1.0f,
		// Left
			-1.0f, BOTTOM ,  1.0f, -1.0f, HALFWAY,  1.0f, -1.0f, BOTTOM , -1.0f,
			-1.0f, BOTTOM , -1.0f, -1.0f, HALFWAY,  1.0f, -1.0f, HALFWAY, -1.0f,
			-1.0f, HALFWAY,  1.0f, -1.0f, TOP    ,  1.0f, -1.0f, HALFWAY, -1.0f,
			-1.0f, HALFWAY, -1.0f, -1.0f, TOP    ,  1.0f, -1.0f, TOP    , -1.0f,
		// Back
			-1.0f, BOTTOM , -1.0f, -1.0f, HALFWAY, -1.0f,  1.0f, BOTTOM , -1.0f,
			 1.0f, BOTTOM , -1.0f, -1.0f, HALFWAY, -1.0f,  1.0f, HALFWAY, -1.0f,
			-1.0f, HALFWAY, -1.0f, -1.0f, TOP    , -1.0f,  1.0f, HALFWAY, -1.0f,
			 1.0f, HALFWAY, -1.0f, -1.0f, TOP    , -1.0f,  1.0f, TOP    , -1.0f,
		// Right
			 1.0f, BOTTOM , -1.0f,  1.0f, HALFWAY, -1.0f,  1.0f, BOTTOM ,  1.0f,
			 1.0f, BOTTOM ,  1.0f,  1.0f, HALFWAY, -1.0f,  1.0f, HALFWAY,  1.0f,
			 1.0f, HALFWAY, -1.0f,  1.0f, TOP    , -1.0f,  1.0f, HALFWAY,  1.0f,
			 1.0f, HALFWAY,  1.0f,  1.0f, TOP    , -1.0f,  1.0f, TOP    ,  1.0f
	};

	float fScaleFactor = 4.0f;
	for(int i=0; i < NUM_VERTS; ++i)
	{
		pVertices[i].position.x = fVerts[i*3] * fScaleFactor;
		pVertices[i].position.y = fVerts[i*3 + 1] * fScaleFactor;
		pVertices[i].position.z = fVerts[i*3 + 2] * fScaleFactor;
		if(fVerts[i*3 + 1] == TOP)
			pVertices[i].diffuse = TRANSP;
		else
			pVertices[i].diffuse = OPAKUE;
	}
	m_pVB->Unlock();

	return S_OK;
}

//-----------------------------------------------------------------------------
