//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>




#include ".\camera.h"

#include "DxObjects.h"

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CCamera::CCamera(void)
{
	m_fCameraDistance	= 0.2f;
	m_fCameraAltitude	= 0.3f;

	D3DXMatrixIdentity(&m_matView);
	D3DXMatrixIdentity(&m_matViewNoTranslate);
}

//-----------------------------------------------------------------------------

CCamera::~CCamera(void)
{
}

//-----------------------------------------------------------------------------
/*
 * FrameMove(const D3DXVECTOR3 &vecTarget, float fBearing);
 *
 * effect: calculate new view matrices from vecTarget and fBearing
 *
 * modifies: m_matView, m_matViewNoTranslate
 */
void CCamera::FrameMove(const D3DXVECTOR3 &vecTarget, float fBearing)
{
	float fXOffset = (float)sin(fBearing) * m_fCameraDistance;
	float fZOffset = (float)cos(fBearing) * m_fCameraDistance;
	

	D3DXVECTOR3 vecFromPt;
	vecFromPt.x = vecTarget.x - fXOffset;
	vecFromPt.z = vecTarget.z - fZOffset;
	vecFromPt.y = m_fCameraAltitude;

	D3DXVECTOR3 vecUp    = D3DXVECTOR3(0.0f, 1.0f, 0.0f);

	D3DXMatrixLookAtLH(&m_matView, &vecFromPt, &vecTarget, &vecUp);




	D3DXVECTOR3 vecLookAt;
	vecLookAt.x = fXOffset;
	vecLookAt.z = fZOffset;
	vecLookAt.y = vecTarget.y - m_fCameraAltitude;

	vecFromPt = D3DXVECTOR3(0,0,0);

	D3DXMatrixLookAtLH(&m_matViewNoTranslate, &vecFromPt, &vecLookAt, &vecUp);

	//// Replace six lines above with four lines below

	//m_matViewNoTranslate = m_matView;
	//m_matViewNoTranslate._41 = 0.0f;
	//m_matViewNoTranslate._42 = 0.0f;
	//m_matViewNoTranslate._43 = 0.0f;
}

//-----------------------------------------------------------------------------

void CCamera::SetViewNoTranslate() const
{
	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
	
	pDevice->SetTransform(D3DTS_VIEW, &m_matViewNoTranslate);
}

//-----------------------------------------------------------------------------

void CCamera::SetView() const
{
	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
	
	pDevice->SetTransform(D3DTS_VIEW, &m_matView);
}

//-----------------------------------------------------------------------------
