// Altimeter.h: interface for the CAltimeter class.
//
//////////////////////////////////////////////////////////////////////
#pragma once


class CAltimeter
{
public:
	CAltimeter();
	virtual ~CAltimeter();

	HRESULT	RestoreDeviceObjects();
	void	InvalidateDeviceObjects();

	void	Render() const;
	void	FrameMove(float fShipAltitude, float fLandAltitude);

private:
	// Pixel offsets used to define geometry
	int		m_nRightPixels;
	int		m_nLeftPixels;
	int		m_nTopPixels;
	int		m_nBottomPixels;

	LPDIRECT3DVERTEXBUFFER8		m_pVB;
	struct CUSTOMVERTEX {
		D3DXVECTOR4 position;
		DWORD		diffuse;
	};
	DWORD		m_dwFVF;
	enum { NUM_PRIMS = 6, NUM_VERTS = 18 };

	bool		m_bRender;

	HRESULT CreateSimpleVertexBuffer();
	void	AssignWindowGeom();
};

