//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>

#include ".\shipmodel.h"

#include "DxObjects.h"


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CShipModel::CShipModel()
{
	m_pMesh				= NULL;
	m_pTextures			= NULL;

	float fScale = 0.006f;		// default 0.015
	D3DXMatrixScaling(&m_matXform, fScale, fScale, fScale);

	m_bRender = false;
}

//-----------------------------------------------------------------------------

CShipModel::~CShipModel(void)
{
}

//-----------------------------------------------------------------------------

HRESULT CShipModel::InitDeviceObjects()
{
 	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

    // Load the mesh from the specified file
	if( FAILED( D3DXLoadMeshFromX( "D:\\Ship.x", D3DXMESH_SYSTEMMEM, 
                                   pDevice, NULL, 
                                   NULL, NULL ,
                                   &m_pMesh ) ) )
    {
//        MessageBox(NULL, "Could not load Ship.x", "FlyPhil.exe", MB_OK);
        return(E_FAIL);
    }

	// Load textures...
	m_pTextures  = new LPDIRECT3DTEXTURE8[2];
	m_pTextures[0] = NULL;
	m_pTextures[1] = NULL;
    if( FAILED( D3DXCreateTextureFromFile( pDevice, 
		"D:\\ComboA.bmp", 
                                        &m_pTextures[0] ) ) )
    {
//        MessageBox(NULL, "Could not load Ship1 texture map", "FlyPhil.exe", MB_OK);
		return(E_FAIL);
    }
    if( FAILED( D3DXCreateTextureFromFile( pDevice, 
		"D:\\ComboA2.bmp", 
                                        &m_pTextures[1] ) ) )
    {
//        MessageBox(NULL, "Could not load Ship2 texture map", "FlyPhil.exe", MB_OK);
		return(E_FAIL);
    }



	m_bRender = true;

    return S_OK;
}

//-----------------------------------------------------------------------------

void CShipModel::DeleteDeviceObjects()
{
    if( m_pTextures )
    {
        if( m_pTextures[0] )
            m_pTextures[0]->Release();
        if( m_pTextures[1] )
            m_pTextures[1]->Release();
        delete[] m_pTextures;
    }

	if( m_pMesh != NULL )
        m_pMesh->Release();
}

//-----------------------------------------------------------------------------

void CShipModel::Render(int nPlayer, const D3DXMATRIX &mat) const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		D3DXMATRIX matWorld;
		D3DXMatrixMultiply(&matWorld, &m_matXform, &mat);
		pDevice->SetTransform(D3DTS_WORLD, &matWorld);

		pDevice->SetTexture(0, m_pTextures[nPlayer - 1]);
		m_pMesh->DrawSubset(0);
	}
}

//-----------------------------------------------------------------------------

void CShipModel::Render9(int nPlayer, const D3DXMATRIX &mat) const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		pDevice->SetTexture(0, m_pTextures[2 - nPlayer]);
		pDevice->SetRenderState(D3DRS_FOGENABLE, true);

		D3DXMATRIX matWorld;
		D3DXMatrixMultiply(&matWorld, &m_matXform, &mat);
		D3DXMATRIX matTile;
		for(int z = -1; z < 2; z++)
		{
			for(int x = -1; x < 2; x++)
			{
				D3DXMatrixTranslation(&matTile, (float)x, 0, (float)z);
				D3DXMatrixMultiply(&matTile, &matWorld, &matTile);
				pDevice->SetTransform(D3DTS_WORLD, &matTile);
				m_pMesh->DrawSubset(0);
			}
		}
		//D3DXMATRIX matWorld;
		//D3DXMatrixMultiply(&matWorld, &m_matXform, &mat);
		//D3DXMATRIX matTile = matWorld;
		//for(int z = -1; z < 2; z++)
		//{
		//	for(int x = -1; x < 2; x++)
		//	{
		//		matTile._41 = matWorld._41 + x;
		//		matTile._43 = matWorld._43 + z;
		//		pDevice->SetTransform(D3DTS_WORLD, &matTile);
		//		m_pMesh->DrawSubset(0);
		//	}
		//}

		pDevice->SetRenderState(D3DRS_FOGENABLE, false);
	}
}
