// GameOver.cpp: implementation of the CGameOver class.
//
//////////////////////////////////////////////////////////////////////
//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>
#include "port.h"

#include "DxObjects.h"

#include ".\GameOver.h"
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
LPDIRECT3DTEXTURE8			CGameOver::m_pTexture = NULL;
//-----------------------------------------------------------------------------

CGameOver::CGameOver()
{
	// Constant pixel offsets
	m_nWidthPixels	= 192;
	m_nHeightPixels	= 96;

	m_nLeftPixels	= 0;
	m_nMiddlePixels	= 0;
	m_nRightPixels	= 0;
	m_nBottomPixels	= 0;
	m_nTopPixels	= 0;

	m_pVB		= NULL;
	m_dwFVF		= D3DFVF_XYZRHW|D3DFVF_TEX1;

	m_bRender	= false;
}

//-----------------------------------------------------------------------------

CGameOver::~CGameOver()
{
}

//-----------------------------------------------------------------------------

HRESULT CGameOver::InitDeviceObjects()
{
	if(!m_pTexture)
	{
		HRESULT hr;
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		// Load the texture. Define the alpha channel
		if((hr = D3DXCreateTextureFromFileEx(pDevice, "D:\\gameover.bmp", D3DX_DEFAULT,
						D3DX_DEFAULT, D3DX_DEFAULT, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
						D3DX_DEFAULT, D3DX_DEFAULT, 0, NULL, NULL, &m_pTexture)) != S_OK)
		{
//			MessageBox(NULL, "Could not load GameOver texture map", "FlyPhil.exe", MB_OK);
			return(hr);
		}
		
		D3DSURFACE_DESC pDDS;
		if((hr=m_pTexture->GetLevelDesc(0, &pDDS)) != S_OK)
		{
//			MessageBox(NULL, "Can't GetLevelDesc() GameOver texture", "FlyPhil.exe", MB_OK);
			return hr;
		}
		int nNumPixels = pDDS.Width * pDDS.Height;

		D3DLOCKED_RECT lockedRect;
		if((hr=m_pTexture->LockRect(0, &lockedRect, NULL, 0)) != S_OK)
		{
//			MessageBox(NULL, "Can't LockRect() GameOver texture", "FlyPhil.exe", MB_OK);
			return hr;
		}

		BYTE *ptr = (BYTE *)(lockedRect.pBits);
		BYTE r;
		for(int i=0; i < nNumPixels; ++i)
		{
			r = *(ptr + (i * 4) + 2);
			if(r == 255)
				*(ptr + (i * 4) + 3) = 0;
			else
				*(ptr + (i * 4) + 3) = 255;
		}

		m_pTexture->UnlockRect(0);
	}

	return S_OK;
}

//-----------------------------------------------------------------------------

void CGameOver::DeleteDeviceObjects()
{
	SAFE_RELEASE(m_pTexture);

	m_bRender = false;
}

//-----------------------------------------------------------------------------

HRESULT	CGameOver::RestoreDeviceObjects()
{
	HRESULT hr;

	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
	
	// Determine pixel positions from viewport dimensions
	D3DVIEWPORT8 viewPort;
	pDevice->GetViewport(&viewPort);

	m_nLeftPixels	= (viewPort.Width - m_nWidthPixels) / 2;
	m_nMiddlePixels	= m_nLeftPixels + m_nWidthPixels / 2;
	m_nRightPixels	= m_nLeftPixels + m_nWidthPixels;
	m_nTopPixels	= ((viewPort.Height - m_nHeightPixels) / 2 ) + viewPort.Y;
	m_nBottomPixels	= m_nTopPixels + m_nHeightPixels;


	// Create vertex buffer
	if((hr = pDevice->CreateVertexBuffer(	NUM_VERTS * sizeof(CUSTOMVERTEX), D3DUSAGE_DYNAMIC,
											m_dwFVF, D3DPOOL_DEFAULT, &m_pVB)) != S_OK)
		return(hr);

	// Lock and fill in vertex buffer
	CUSTOMVERTEX* pVertices;
	if((hr = m_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0)) != S_OK)
		return(hr);

	for(int i=0; i < NUM_VERTS; ++i)
	{
		pVertices[i].position.z = 0.1f;
		pVertices[i].position.w = 1.0f;
	}

	// Game...
	pVertices[ 0].tu = 0.0f;
	pVertices[ 0].tv = 0.0f;
	pVertices[ 1].tu = 0.0f;
	pVertices[ 1].tv = 0.5f;
	pVertices[ 2].tu = 1.0f;
	pVertices[ 2].tv = 0.0f;
	pVertices[ 3].tu = 1.0f;
	pVertices[ 3].tv = 0.0f;
	pVertices[ 4].tu = 0.0f;
	pVertices[ 4].tv = 0.5f;
	pVertices[ 5].tu = 1.0f;
	pVertices[ 5].tv = 0.5f;

	// Over...
	pVertices[ 6].tu = 0.0f;
	pVertices[ 6].tv = 0.5f;
	pVertices[ 7].tu = 0.0f;
	pVertices[ 7].tv = 1.0f;
	pVertices[ 8].tu = 1.0f;
	pVertices[ 8].tv = 0.5f;
	pVertices[ 9].tu = 1.0f;
	pVertices[ 9].tv = 0.5f;
	pVertices[10].tu = 0.0f;
	pVertices[10].tv = 1.0f;
	pVertices[11].tu = 1.0f;
	pVertices[11].tv = 1.0f;

	// Game...
	pVertices[ 0].position.x = (float)m_nLeftPixels;
	pVertices[ 0].position.y = (float)m_nTopPixels;
	pVertices[ 1].position.x = (float)m_nLeftPixels;
	pVertices[ 1].position.y = (float)m_nBottomPixels;
	pVertices[ 2].position.x = (float)m_nMiddlePixels;
	pVertices[ 2].position.y = (float)m_nTopPixels;
	pVertices[ 3].position.x = (float)m_nMiddlePixels;
	pVertices[ 3].position.y = (float)m_nTopPixels;
	pVertices[ 4].position.x = (float)m_nLeftPixels;
	pVertices[ 4].position.y = (float)m_nBottomPixels;
	pVertices[ 5].position.x = (float)m_nMiddlePixels;
	pVertices[ 5].position.y = (float)m_nBottomPixels;

	// Over...
	pVertices[ 6].position.x = (float)m_nMiddlePixels;
	pVertices[ 6].position.y = (float)m_nTopPixels;
	pVertices[ 7].position.x = (float)m_nMiddlePixels;
	pVertices[ 7].position.y = (float)m_nBottomPixels;
	pVertices[ 8].position.x = (float)m_nRightPixels;
	pVertices[ 8].position.y = (float)m_nTopPixels;
	pVertices[ 9].position.x = (float)m_nRightPixels;
	pVertices[ 9].position.y = (float)m_nTopPixels;
	pVertices[10].position.x = (float)m_nMiddlePixels;
	pVertices[10].position.y = (float)m_nBottomPixels;
	pVertices[11].position.x = (float)m_nRightPixels;
	pVertices[11].position.y = (float)m_nBottomPixels;


	m_pVB->Unlock();

	m_bRender = true;

	return S_OK;
}

//-----------------------------------------------------------------------------

void CGameOver::InvalidateDeviceObjects()
{
	SAFE_RELEASE(m_pVB);
	m_bRender = false;
}

//-----------------------------------------------------------------------------

void CGameOver::Render() const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		pDevice->SetStreamSource(0, m_pVB, sizeof(CUSTOMVERTEX));
		pDevice->SetVertexShader(m_dwFVF);
		pDevice->SetTexture(0, m_pTexture);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, NUM_PRIMS);
	}
}

//-----------------------------------------------------------------------------

