#pragma once

class CGameMgr
{
public:
	CGameMgr(void);
	~CGameMgr(void);

	HRESULT	Initialise(HWND hWnd);
	
	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE8 pDevice);
	void	DeleteDeviceObjects();
	HRESULT	RestoreDeviceObjects(D3DSURFACE_DESC* pSurface);
	void	InvalidateDeviceObjects();

	void	FrameMove(float fAppTime, CGamePad *pPad);
	void	Render() const;

private:
	CHeightMap	m_HeightMap;

//	CInput		m_Input;

	CGame		m_Game1;
	CGame		m_Game2;

	CSharedGeom	m_SharedGeom;

	CPickUp		m_PickUp;

	CTitle		m_Title;
	CViewPort	m_ViewPortWhole;


	int			m_nFramesToTitle;	// Frames to pause for after GAMEOVER
	bool		m_bDemo;			// true if in title-screen mode
	int			m_nNumGames;


	void RenderGame(	const CGame	&game,
						const CShip	&ship1,
						const CShip *ship2,
						int			nGame) const;
};
