#pragma once

class CInput;
class CHeightMap;

class CGame
{
public:
	CGame(void);
	~CGame(void);

	bool	GameOver() const;
	void	StartGame();

	HRESULT	Initialise(int anKeys[] = NULL, D3DXVECTOR3 *pvecShip = NULL);
	HRESULT	InitDeviceObjects();
	void	DeleteDeviceObjects();
	HRESULT	RestoreDeviceObjects(DWORD y, DWORD height, DWORD width);
	void	InvalidateDeviceObjects();


	void FrameMove(CGamePad *pPad, const CHeightMap &HeightMap, float fTime, bool bDemo);

	void ActivateViewPort() const;
	void FuelBonus(float fFuel);

	const CCamera   & GetCamera()   const;
	const CShip     & GetShip()     const;
	const CUniqGeom & GetUniqGeom() const;

private:
	CCamera		m_Camera;
	CShip		m_Ship;
	CUniqGeom	m_UniqGeom;
//	CPlayer		m_Player;
	CViewPort	m_ViewPort;

	bool		m_bGameOver;
};
