#pragma once

class CFuelTank
{
public:
	CFuelTank(void);
	~CFuelTank(void);

	HRESULT	InitDeviceObjects();
	void	DeleteDeviceObjects();

	void	Render(const D3DXMATRIX& matPickUp) const;

private:
	LPDIRECT3DVERTEXBUFFER8		m_pVB;
	LPDIRECT3DINDEXBUFFER8		m_pIndexBuf;
	D3DMATERIAL8				m_mtrl;

	struct CUSTOMVERTEX {
		D3DXVECTOR3 position;
		D3DXVECTOR3	normal;
		DWORD		diffuse;
	};
	DWORD						m_dwFVF;
	enum { NUM_VERTS = 258, NUM_PRIMS = 512 };

	bool						m_bRender;

	HRESULT CreateVertexBuffer();
	HRESULT CreateIndexBuffer();

	float	m_fScaleFactor;
	float	m_fVertOffset;
};
