//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>

#include "Ship.h"

#include "Shadow.h"
#include "Altimeter.h"
#include "FuelGuage.h"
#include "GameOver.h"

#include "DxObjects.h"

#include ".\uniqgeom.h"

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CUniqGeom::CUniqGeom(void)
{
}

//-----------------------------------------------------------------------------

CUniqGeom::~CUniqGeom(void)
{
}

//-----------------------------------------------------------------------------

HRESULT CUniqGeom::InitDeviceObjects()
{
	HRESULT hr = S_OK;

	if((hr = m_Shadow.InitDeviceObjects()) != S_OK)
		return(hr);

	// All device objects for Altimeter are built in RestoreDeviceObjects()

	if((hr = m_FuelGuage.InitDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_GameOver.InitDeviceObjects()) != S_OK)
		return(hr);

	return(hr);
}

//-----------------------------------------------------------------------------

void CUniqGeom::DeleteDeviceObjects()
{
	m_Shadow.DeleteDeviceObjects();

	// All device objects for Altimeter are deleted by InvalidateDeviceObjects()

	m_FuelGuage.DeleteDeviceObjects();
	m_GameOver.DeleteDeviceObjects();
}

//-----------------------------------------------------------------------------

HRESULT CUniqGeom::RestoreDeviceObjects()
{
	HRESULT hr = S_OK;

	if((hr = m_Shadow.RestoreDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_Altimeter.RestoreDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_FuelGuage.RestoreDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_GameOver.RestoreDeviceObjects()) != S_OK)
		return(hr);

	return(hr);
}

//-----------------------------------------------------------------------------

void  CUniqGeom::InvalidateDeviceObjects()
{
	m_Shadow.InvalidateDeviceObjects();
	m_Altimeter.InvalidateDeviceObjects();
	m_FuelGuage.InvalidateDeviceObjects();
	m_GameOver.InvalidateDeviceObjects();
}

//-----------------------------------------------------------------------------

void CUniqGeom::FrameMove(const CShip &Ship, const CHeightMap &HeightMap)
{
	m_Shadow.FrameMove(Ship.GetPosition(), Ship.GetBearing(), HeightMap);
	m_Altimeter.FrameMove(Ship.GetAltitude(), Ship.GetLandHeight());
	m_FuelGuage.FrameMove(Ship.GetFuel());
}

//-----------------------------------------------------------------------------

void CUniqGeom::Render(bool bGameOver) const
{
	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
	pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

	m_Shadow.Render();
	m_Altimeter.Render();
	m_FuelGuage.Render();

	if(bGameOver)
		m_GameOver.Render();

	pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
}

