// Title.cpp: implementation of the CTitle class.
//
//////////////////////////////////////////////////////////////////////
//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>
#include "port.h"

#include "DxObjects.h"

#include <assert.h>

#include ".\Title.h"
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CTitle::CTitle()
{
	m_pVB		= NULL;
	m_pTexture	= NULL;
	m_dwFVF		= D3DFVF_XYZRHW | D3DFVF_TEX1;

	m_bRender = false;
}

//-----------------------------------------------------------------------------

CTitle::~CTitle()
{
}

//-----------------------------------------------------------------------------

HRESULT CTitle::InitDeviceObjects()
{
	HRESULT hr;

	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

	// Load the texture. Define the alpha channel
	if((hr = D3DXCreateTextureFromFileEx(pDevice, "D:\\title2.bmp", D3DX_DEFAULT,
					D3DX_DEFAULT, D3DX_DEFAULT, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
					D3DX_DEFAULT, D3DX_DEFAULT, 0, NULL, NULL, &m_pTexture)) != S_OK)
	{
//        MessageBox(NULL, "Could not load title texture map", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	
	D3DSURFACE_DESC pDDS;
	if((hr=m_pTexture->GetLevelDesc(0, &pDDS)) != S_OK)
	{
//        MessageBox(NULL, "Can't GetLevelDesc() title texture", "FlyPhil.exe", MB_OK);
		return hr;
	}
	int nNumPixels = pDDS.Width * pDDS.Height;

	D3DLOCKED_RECT lockedRect;
	if((hr=m_pTexture->LockRect(0, &lockedRect, NULL, 0)) != S_OK)
	{
//        MessageBox(NULL, "Can't LockRect() title texture", "FlyPhil.exe", MB_OK);
		return hr;
	}

	BYTE *ptr = (BYTE *)(lockedRect.pBits);
	BYTE r;
	for(int i=0; i < nNumPixels; ++i)
	{
		r = *(ptr + (i * 4) + 2);
		if(r == 255)
			*(ptr + (i * 4) + 3) = 0;
		else
			*(ptr + (i * 4) + 3) = 255;
	}

	m_pTexture->UnlockRect(0);

	return S_OK;
}

//-----------------------------------------------------------------------------

void CTitle::DeleteDeviceObjects()
{
	SAFE_RELEASE(m_pTexture);
	m_bRender = false;
}

//-----------------------------------------------------------------------------

HRESULT	CTitle::RestoreDeviceObjects()
{
	HRESULT hr;

	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
	if((hr = pDevice->CreateVertexBuffer(	NUM_VERTS * sizeof(CUSTOMVERTEX), D3DUSAGE_DYNAMIC,
											m_dwFVF, D3DPOOL_DEFAULT, &m_pVB)) != S_OK)
		return(hr);

	CUSTOMVERTEX* pVertices;
	if((hr = m_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 )) != S_OK)
		return(hr);

	for(int i=0; i < NUM_VERTS; ++i)
	{
		pVertices[i].position.z = 0.1f;
		pVertices[i].position.w = 1.0f;
	}

	D3DVIEWPORT8 viewPort;
	pDevice->GetViewport(&viewPort);

	pVertices[0].position.x = 0;
	pVertices[0].position.y = 0;
	pVertices[0].tu = 0.0f;
	pVertices[0].tv = 0.0f;
	pVertices[1].position.x = 0;
	pVertices[1].position.y = (float)viewPort.Height;
	pVertices[1].tu = 0.0f;
	pVertices[1].tv = 1.0f;
	pVertices[2].position.x = (float)viewPort.Width;
	pVertices[2].position.y = 0;
	pVertices[2].tu = 1.0f;
	pVertices[2].tv = 0.0f;
	pVertices[3].position.x = (float)viewPort.Width;
	pVertices[3].position.y = 0;
	pVertices[3].tu = 1.0f;
	pVertices[3].tv = 0.0f;
	pVertices[4].position.x = 0;
	pVertices[4].position.y = (float)viewPort.Height;
	pVertices[4].tu = 0.0f;
	pVertices[4].tv = 1.0f;
	pVertices[5].position.x = (float)viewPort.Width;
	pVertices[5].position.y = (float)viewPort.Height;
	pVertices[5].tu = 1.0f;
	pVertices[5].tv = 1.0f;

	m_pVB->Unlock();

	m_bRender = true;

	return(S_OK);
}

//-----------------------------------------------------------------------------

void CTitle::InvalidateDeviceObjects()
{
	SAFE_RELEASE(m_pVB);
	m_bRender = false;
}

//-----------------------------------------------------------------------------

void CTitle::Render() const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

		pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

		pDevice->SetTexture(0, m_pTexture);
		pDevice->SetStreamSource(0, m_pVB, sizeof(CUSTOMVERTEX));
		//pDevice->SetFVF(m_dwFVF);
		pDevice->SetVertexShader(m_dwFVF);
		pDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, NUM_PRIMS);

		pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
	}
}

//-----------------------------------------------------------------------------
