#pragma once

class CHeightMap;

class CShadow
{
public:
	CShadow(void);
	~CShadow(void);

	HRESULT	InitDeviceObjects();
	void	DeleteDeviceObjects();
	HRESULT	RestoreDeviceObjects();
	void	InvalidateDeviceObjects();

	void	Render() const;
	void	FrameMove(const D3DXVECTOR3 &vecPos, float fBearing, const CHeightMap &HeightMap);

private:
	static LPDIRECT3DTEXTURE8		m_pTexture;

	struct CUSTOMVERTEX
	{
		D3DXVECTOR3 position;       // vertex position
		float		tu, tv;
	};
	DWORD	m_dwFVF;
	LPDIRECT3DVERTEXBUFFER8	m_pVB;

	D3DXMATRIX				m_matWorld;
	LPDIRECT3DINDEXBUFFER8	m_pIndexBuf;

	bool	m_bRender;

	enum { NUM_VERTS = 256 };
	int		m_nNumVertsX;
	int		m_nNumPrims;


	struct TEXCOORDS
	{
		float tu, tv;
	};
	TEXCOORDS	m_pTexCoords[NUM_VERTS];


	HRESULT CreateNullVertexBuffer();
	HRESULT CreateIndexBuffer();


	//bool ValidInXZ(CUSTOMVERTEX* pVertices);
};
