//#include <d3dx9.h>
#include <xtl.h>

#include "gamepad.h"

#include "HeightMap.h"

	#include "Camera.h"
	#include "Ship.h"
		#include "Shadow.h"
		#include "Altimeter.h"
		#include "FuelGuage.h"
		#include "GameOver.h"
	#include "UniqGeom.h"
	#include "Player.h"
	#include "ViewPort.h"
#include "Game.h"

#include ".\pickup.h"

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CPickUp::CPickUp(void)
{
	m_fFuelLevel	= 0.12f;

	m_fMinAltitude	= 0.02254f;
	m_fMaxAltitude	= 0.3f;

	m_fAttractDistance	= 0.1f;
	m_fCollectDistance	= 0.005f;
	m_fCollectSpeed		= 0.2f;	// when attracting, pickup->ship unit vector, is
									// scaled by this*time to determine pickup move vector

	// set state to floating
	m_nPickingUp = 0;


	m_vecPos	= D3DXVECTOR3(0.5f, 0.2f, 0.5f);
	m_fRotation	= 0;
}

//-----------------------------------------------------------------------------

CPickUp::~CPickUp(void)
{
}

//-----------------------------------------------------------------------------

const D3DXVECTOR3& CPickUp::GetPosition() const
{
	return(m_vecPos);
}

//-----------------------------------------------------------------------------

float CPickUp::GetRotation() const
{
	return(m_fRotation);
}

//-----------------------------------------------------------------------------

bool CPickUp::CollisionTest(const D3DXVECTOR3& vecShip, float fCollideDistance)
{
	D3DXVECTOR3 vecDistance = vecShip - m_vecPos;
	float fDistance = D3DXVec3Length(&vecDistance);

	if(fDistance < fCollideDistance)
		return(true);
	else
		return(false);
}

//-----------------------------------------------------------------------------

/*
 * MoveTowardShip(const D3DXVECTOR3& vecShip, float fDistance)
 *
 * pickup is being attracted to a ship. update m_vecPos, check if
 * entered ships collection range.
 *
 * pvecShip  - pointer to ship position vector
 * fDistance - how far to move this frame
 * 
 * returns - true if moved into collection range
 *
 */
bool CPickUp::MoveTowardShip(const D3DXVECTOR3& vecShip, float fDistance)
{
	// Normalised vector pickup->collector
	D3DXVECTOR3 vecDir;
	D3DXVec3Subtract(&vecDir, &vecShip, &m_vecPos);
	D3DXVec3Normalize(&vecDir, &vecDir);

	// Translate by (vecDir * fDistance)
	D3DXVec3Scale(&vecDir, &vecDir, fDistance);
	D3DXVec3Add(&m_vecPos, &m_vecPos, &vecDir);

	return(CollisionTest(vecShip, m_fCollectDistance));
}

//-----------------------------------------------------------------------------

void CPickUp::UpdatePosition(const CHeightMap &HeightMap, CGame &Game1, CGame *pGame2, float fTime)
{
	// Get ship position(s)
	const D3DXVECTOR3* vecShip[2];
	vecShip[0] = &(Game1.GetShip().GetPosition());
	if(pGame2)
		vecShip[1] = &(pGame2->GetShip().GetPosition());
	else
		vecShip[1] = NULL;


	if(m_nPickingUp)	// Move pickup to ship, respawn if collected
	{
		if(MoveTowardShip(*vecShip[m_nPickingUp - 1], m_fCollectSpeed * fTime))
		{
			if(m_nPickingUp == 1)
				Game1.FuelBonus(m_fFuelLevel);
			else if(m_nPickingUp == 2)
				pGame2->FuelBonus(m_fFuelLevel);
			SpawnInNewPosition(HeightMap);
			m_nPickingUp = 0;
		}
	}
	else				// Check for ship(s) in attraction range, set flag.
	{
		if(CollisionTest(*vecShip[0], m_fAttractDistance))
			m_nPickingUp = 1;
		else
		{
			if(vecShip[1])
			{
				if(CollisionTest(*vecShip[1], m_fAttractDistance))
					m_nPickingUp = 2;
			}
		}
	}


	// Spin fuel tank
	m_fRotation += fTime * 4.0f;
}

//-----------------------------------------------------------------------------

void CPickUp::SpawnInNewPosition(const CHeightMap &HeightMap)
{
	float fX = (float)rand() / RAND_MAX;
	float fZ = (float)rand() / RAND_MAX;

	float fLandHeight = HeightMap.GetData(fZ, fX);
	float minY = fLandHeight + m_fMinAltitude;
	float maxY = fLandHeight + m_fMaxAltitude;
	float rangeY = maxY - minY;

	float fY = ((float)rand() / RAND_MAX) * rangeY + minY;


	m_vecPos.x = fX;
	m_vecPos.y = fY;
	m_vecPos.z = fZ;

	m_fRotation = 0.0f;
}