// GameOver.h: interface for the CGameOver class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

class CGameOver
{
public:
	CGameOver();
	virtual ~CGameOver();

	HRESULT	InitDeviceObjects();
	void	DeleteDeviceObjects();
	HRESULT	RestoreDeviceObjects();
	void	InvalidateDeviceObjects();

	void	Render() const;

private:
	static LPDIRECT3DTEXTURE8			m_pTexture;

	struct CUSTOMVERTEX {
		D3DXVECTOR4 position;       // vertex position
		float		tu, tv;
	};
	DWORD	m_dwFVF;
	LPDIRECT3DVERTEXBUFFER8		m_pVB;

	enum { NUM_PRIMS = 4, NUM_VERTS = 12 };

	bool	m_bRender;

	// Constant pixel offsets...
	int m_nWidthPixels;
	int m_nHeightPixels;

	// Variable pixel offsets (dependent on window size)
	int		m_nLeftPixels;
	int		m_nMiddlePixels;
	int		m_nRightPixels;
	int		m_nBottomPixels;
	int		m_nTopPixels;
};
