#include <stdio.h>

//#include <d3dx9.h>
//#define DIRECTINPUT_VERSION 0x0800
//#include <dinput.h>
#include <xtl.h>
#include "xbresource.h"


#include "gamepad.h"




#include "HeightMap.h"


//#include "Input.h"


	#include "Camera.h"
	#include "Ship.h"
		#include "Shadow.h"
		#include "Altimeter.h"
		#include "FuelGuage.h"
		#include "GameOver.h"
	#include "UniqGeom.h"
	#include "Player.h"
	#include "ViewPort.h"
#include "Game.h"


	#include "LandScape.h"
		#include "CloudBox.h"
	#include "SkyBox.h"
	#include "ShipModel.h"
	#include "FuelTank.h"
#include "SharedGeom.h"


#include "PickUp.h"



#include "Title.h"



#include ".\GameMgr.h"

#include "DxObjects.h"

#include "PhilBuf.h"

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CGameMgr::CGameMgr(void)
{
	m_nFramesToTitle	= 0;		// Pause frames after game end

	m_bDemo				= true;		// Show title screen and drone ships

	m_nNumGames			= 1;
}

//-----------------------------------------------------------------------------

CGameMgr::~CGameMgr(void)
{
}

//-----------------------------------------------------------------------------

HRESULT	CGameMgr::Initialise(HWND hWnd)
{
	HRESULT hr = S_OK;

	if((hr = m_HeightMap.Initialise()) != S_OK)
	{
//        MessageBox(NULL, "HeightMap Initialise error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
//	if((hr = m_Input.Initialise(hWnd)) != S_OK)
//	{
////        MessageBox(NULL, "Input Initialise error", "FlyPhil.exe", MB_OK);
//		return(hr);
//	}
	
	// Keyboard controls & ship position for Player2
	//  (m_Game1 uses default, no Initialise() necessary)
//	int anKeys[] = { DIK_A, DIK_D, DIK_W };
//	D3DXVECTOR3 vecPos = D3DXVECTOR3(0.5f, 0.2f, 0.0f);
//	m_Game2.Initialise(anKeys, &vecPos);

	return hr;
}

//-----------------------------------------------------------------------------
/*
 * HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE8 pDevice)
 *
 * effects: register device ptr with CDxObjects
 *			build Dx resources in managed memory
 */
HRESULT	CGameMgr::InitDeviceObjects(LPDIRECT3DDEVICE8 pDevice)
{
	HRESULT hr = S_OK;

	CDxObjects::SetDevice(pDevice);

    if((hr = m_SharedGeom.InitDeviceObjects(m_HeightMap)) != S_OK)
		return(hr);

	// Each CGame object has unique geometry
	if((hr = m_Game1.InitDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_Game2.InitDeviceObjects()) != S_OK)
		return(hr);

	if((hr = m_Title.InitDeviceObjects()) != S_OK)
		return(hr);

	return hr;
}

//-----------------------------------------------------------------------------

void CGameMgr::DeleteDeviceObjects()
{
	m_SharedGeom.DeleteDeviceObjects();

	m_Game1.DeleteDeviceObjects();
	m_Game2.DeleteDeviceObjects();

	m_Title.DeleteDeviceObjects();

//	m_Input.CleanUp();
}

//-----------------------------------------------------------------------------

HRESULT	CGameMgr::RestoreDeviceObjects(D3DSURFACE_DESC* pSurface)
{
	// Set the projection matrix
	FLOAT fAspect;
	if(m_nNumGames == 1)
		fAspect = (float)pSurface->Width / pSurface->Height;
	else
		fAspect = (float)pSurface->Width * 2.0f / pSurface->Height;
	D3DXMATRIX matProj;
    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, fAspect, 0.01f, 10.0f );
	CDxObjects::GetDevice()->SetTransform( D3DTS_PROJECTION, &matProj );


	// Set render states, lights 
	HRESULT hr = S_OK;
	if((hr = m_SharedGeom.RestoreDeviceObjects()) != S_OK)
		return(hr);


	// Rebuild each game's unique geometry
	if(m_nNumGames == 1)
	{
		if((hr = m_Game1.RestoreDeviceObjects(0, pSurface->Height, pSurface->Width)) != S_OK)
			return(hr);
	}
	else
	{
		DWORD dwHeight = pSurface->Height / 2;
		if((hr = m_Game1.RestoreDeviceObjects(0, dwHeight, pSurface->Width)) != S_OK)
			return(hr);
		if((hr = m_Game2.RestoreDeviceObjects(dwHeight, dwHeight, pSurface->Width)) != S_OK)
			return(hr);
	}

	// Rebuild VBuf for Title object
	m_ViewPortWhole.SetViewPort(0, pSurface->Height, pSurface->Width);
	m_ViewPortWhole.Activate();
	if((hr = m_Title.RestoreDeviceObjects()) != S_OK)
		return(hr);

	return hr;
}

//-----------------------------------------------------------------------------

void CGameMgr::InvalidateDeviceObjects()
{
	m_Game1.InvalidateDeviceObjects();
	m_Game2.InvalidateDeviceObjects();

	m_Title.InvalidateDeviceObjects();
}

//-----------------------------------------------------------------------------

void CGameMgr::FrameMove(float fAppTime, CGamePad *pPad)
{
//	m_Input.ReadInput();


	// Update game displays
	m_Game1.FrameMove(pPad, m_HeightMap, fAppTime, m_bDemo);
	if(m_nNumGames == 1)
	{
		m_PickUp.UpdatePosition(m_HeightMap, m_Game1, NULL, fAppTime);
	}
	else
	{
		m_Game2.FrameMove(pPad, m_HeightMap, fAppTime, m_bDemo);

		m_PickUp.UpdatePosition(m_HeightMap, m_Game1, &m_Game2, fAppTime);
	}


	// Start game?
	if(m_bDemo)
	{
		bool bStartGame = false;
		//if(m_Input.KeyPressed(DIK_1) || m_Input.KeyPressed(DIK_NUMPAD1))
		//{
		//	m_nNumGames = 1;
		//	bStartGame = true;
		//}
		//else if(m_Input.KeyPressed(DIK_2) || m_Input.KeyPressed(DIK_NUMPAD2))
		//{
		//	m_nNumGames = 2;
		//	m_Game2.StartGame();
		//	bStartGame = true;
		//}
		if(pPad->m_wPressedButtons & XINPUT_GAMEPAD_START)
			bStartGame = true;

		if(bStartGame)
		{
			m_Game1.StartGame();

			m_bDemo = false;

			// Invalidate and Restore DeviceObjects to ensure
			// potential change in num viewports is registered
			LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
			IDirect3DSurface8* pISurface;
			pDevice->GetRenderTarget(&pISurface);
			D3DSURFACE_DESC SurfaceDesc;
			pISurface->GetDesc(&SurfaceDesc);

			InvalidateDeviceObjects();
			RestoreDeviceObjects(&SurfaceDesc);

			pISurface->Release();
		}
	}
	else if(m_nFramesToTitle)		// Pause before returning to title screen
	{
		--m_nFramesToTitle;
		m_bDemo = (m_nFramesToTitle == 0);
	}
	else	// End game?
	{
		bool bEndGame = false;

		if(m_nNumGames == 1)
			bEndGame = m_Game1.GameOver();
		else
			bEndGame = (m_Game1.GameOver() && m_Game2.GameOver());

		if(bEndGame)
			m_nFramesToTitle = 180;
	}
}

//-----------------------------------------------------------------------------

void CGameMgr::Render() const
{
	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();
    pDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 
                         D3DCOLOR_XRGB(238,168,117), 1.0f, 0);

	if(m_nNumGames == 1)
		RenderGame(m_Game1, m_Game1.GetShip(), NULL, 1);
	else
	{
		RenderGame(m_Game1, m_Game1.GetShip(), &m_Game2.GetShip(), 1);
		RenderGame(m_Game2, m_Game2.GetShip(), &m_Game1.GetShip(), 2);
	}

	if(m_bDemo)
	{
		m_ViewPortWhole.Activate();
		m_Title.Render();
	}
}

//-----------------------------------------------------------------------------

void CGameMgr::RenderGame(	const CGame	&game,
							const CShip	&ship1,
							const CShip	*ship2,
							int			nGame) const
{
	if(m_nNumGames == 2)
		game.ActivateViewPort();

	game.GetCamera().SetViewNoTranslate();
	m_SharedGeom.RenderSkyBox();

	game.GetCamera().SetView();
	m_SharedGeom.RenderScene(nGame, ship1, ship2, m_PickUp);

	game.GetUniqGeom().Render(game.GameOver());
}
