/*
 * Abombniball
 * Copyright (C) 2001 Martin Donlon, akawaka@csn.ul.ie
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */


#ifndef GFX_H
#define GFX_H
#include "SDL.h"

#define FONT_WIDTH 16
#define FONT_HEIGHT 24
#define FONT_GLYPHS 127

#define SCROLLER_IDLE 0
#define SCROLLER_IN 1
#define SCROLLER_REST 2
#define SCROLLER_OUT 3

typedef struct Rect{
  SDL_Rect rect;
  struct Rect *next;
} Rect;

typedef struct Sprite{
  int x, y;
  int width, height;
  int num_frames;
  int current_frame;
  int priority;
  int hidden;
  SDL_Surface **frames;
  
  struct Sprite *next;
} Sprite;

typedef struct SpriteType{
  char *name;
  Sprite *sprite;
  struct SpriteType *next;
} SpriteType;

typedef struct String{
  struct Gfx *gfx;
  int length;
  char *string;
  int need_redraw;

  int x,y;
  int width, height;
  SDL_Surface *image;
  struct String *next;
} String;

typedef struct Gfx{
  SDL_Surface *screen;
  SDL_Surface *background;
  
  Uint8 rothstein24[3 * 24];
  
  float frame_delta;
  float time;
  int frame_count;
  Uint32 last_time;
  
  Sprite *sprites;
  String *strings;
  
  String *scroller;
  int scroller_status;
  float scroller_pos;
  float scroller_inpps, scroller_outpps, scroller_resttime;
  SDL_Rect scroller_rect;
   
  SDL_Surface *glyphs[FONT_GLYPHS];
  
  Rect *_dirty_rects;
  Rect *_clean_rects;

  void *_rect_mem;

  SpriteType *_sprite_types;
} Gfx;

Gfx *gfxInit(int width, int height, int fullscreen, int num_rects);
void gfxDirtyRectangle(Gfx *gfx, SDL_Rect *rect);
void gfxUpdate(Gfx *gfx, int screen_shot);
void gfxQuit(Gfx *gfx);
void mathCreateRothstein(int p, int q, Uint8 *code);

void gfxShrinkBlit16(SDL_Surface *src, SDL_Surface *dest, SDL_Rect *dest_rect,
    Uint8 *rothstein);

void spriteNewType(Gfx *gfx, char *name, int width, int height, int num_frames,
    SDL_Surface *image, Uint8 ck_red, Uint8 ck_green, Uint8 ck_blue);
void spriteDelete(Sprite *sprite);
Sprite *gfxAddSprite(Gfx *gfx, char *name);
void gfxRemoveSprite(Gfx *gfx, Sprite *sprite);


SDL_Surface *gfxLoadImage(char *filename);
SDL_Surface *gfxLoadImageTrans(char *filename, int rle);

String *stringNew(Gfx *gfx, int length);
void stringDelete(String *str);
void stringSet(String *str, char *string, int centre);
void stringMove(String *str, int x, int y);

int gfxScrollerSet(Gfx *gfx, char *text, int force);
int gfxScrollerStatus(Gfx *gfx);
void gfxScrollerArgs(Gfx *gfx, int scrollin_time, int scrollout_time,
        int rest_time);
void gfxScrollerReset(Gfx *gfx);
void gfxScrollerStart(Gfx *gfx);
void gfxScrollerUpdate(Gfx *gfx);
#endif
