;;; 
;;; Compile this with NASM.
;;;
;;; Allocate contiguous memory for the initialized data segment and
;;; video encoder data segment. Then allocate the corresponding section of
;;; the flash rom to make the pages present and copy the data. Then free
;;; the temporary flash rom allocation. The flash rom is no longer needed.
;;; 
;;; Intended to be patched into M8 at 0x80054922 (jmp). This patch can be
;;; placed anywhere, including INIT section. I put it at offset 0x8002f0de.
;;;
;;; To make a working BFM kernel, you'll also need to replace the byte 0xc1
;;; at offset 0x8001e7b7 with byte 0x00. Additionally you need to set the
;;; flags at 0x8003c138 from byte 0x00 to byte 0x03.
;;; 


BITS 32
ORG 8002F0DEh

	pushad

	mov	esi,80010000h
	push	esi
	call	8001DDD4h	; MmGetPhysicalAddress

	dec	eax
	mov	ebx,[esi+2Ch]
	add	ebx,[esi+38h]

	push	byte 4
	push	byte 0
	push	eax
	push	byte 0
	push	ebx
	call	8001DE22h	; MmAllocateContiguousMemoryEx
	mov	edi,eax

	push	byte 1
	push	ebx
	push	edi
	call	8001E021h	; MmPersistContiguousMemory

	mov	edx,[esi+30h]

	push	edi
	
	lea	ecx,[ebx+0FFFh]
	mov	ebp,07FFFF000h
	lea	eax,[edx+ecx]
	add	ecx,edi
	and	edx,ebp
	and	edi,ebp
	and	eax,ebp
	and	ecx,ebp

	;; EDX = src start
	;; EAX = src end
	;; EDI = dest start
	;; ECX = dest end

	cmp	edx,edi
	jae	highsrc
	cmp	eax,edi
	jbe	srcalloc
	mov	eax,edi
	jmp	short srcalloc
highsrc:cmp	edx,ecx
	jae	srcalloc
	mov	edx,ecx

srcalloc:
	pop	edi

	cmp	eax,edx
	je	skipsa
	
	push	byte 4
	push	byte 0
	dec	eax
	push	eax
	push	edx
	sub	eax,edx
	inc	eax
	push	eax
	call	8001DE22h	; MmAllocateContiguousMemoryEx
	push	eax		; push argument for MmFreeContiguousMemory


	pushf
	push	dword [esi+30h]
	cli
	mov	eax,0C0200040h
	push	dword [eax]
	or	dword [eax],byte 03h
	mov	ecx,cr3
	mov	cr3,ecx
	
	mov	[esi+30h],edi
	wbinvd

	pop	dword [eax]
	mov	cr3,ecx
	pop	esi
	
	cmp	esi,edi
	ja	copy
	je	nocopy

	lea	ecx,[esi+ebx]
	cmp	ecx,edi
	jbe	copy

	lea	esi,[ecx-1]
	lea	edi,[edi+ebx-1]
	std

copy:	mov	ecx,ebx
	rep	movsb
nocopy:
	popf
	
	call	8001E4E7h	; MmFreeContiguousMemory

skipsa:
	popad
	jmp	800B145Ah
