#include "xboxkrnl.h"
#include "strh.h"
#include "cfgparser.h"

extern unsigned char DebugFlag;

static int parse_config(char *path, char *buf, CONFIGENTRY *entry);



NTSTATUS cfgparser_get_config(CONFIGENTRY *entry)
{
    char path[MAX_PATHNAME];
    char filename[MAX_PATHNAME];
    char config[CONFIG_FILE_BUFSIZE];
    ANSI_STRING ConfigFileString;
    HANDLE ConfigFile;
    OBJECT_ATTRIBUTES ConfigFileAttributes;
    IO_STATUS_BLOCK IoStatusBlock;
    NTSTATUS Error;

    /* get the directory of the bootloader executable */

    memset(path, 0, MAX_PATHNAME);
    strncpy(path, XeImageFileName->Buffer,
	    XeImageFileName->Length < (MAX_PATHNAME - 1) ?
	    XeImageFileName->Length : (MAX_PATHNAME - 1));
    strrchr(path, '\\')[1] = 0;

    /* read the config file from there */

    strh_dnzcpy(filename, path, MAX_PATHNAME);
    strh_dnzcat(filename, CONFIG_FILE, MAX_PATHNAME);
    
    RtlInitAnsiString(&ConfigFileString, filename);
    
    ConfigFileAttributes.Attributes = OBJ_CASE_INSENSITIVE;
    ConfigFileAttributes.ObjectName = &ConfigFileString;
    ConfigFileAttributes.RootDirectory = NULL;
    
    Error = NtCreateFile(&ConfigFile,
			 GENERIC_READ | SYNCHRONIZE,
			 &ConfigFileAttributes,
			 &IoStatusBlock,
			 NULL,
			 0,
			 FILE_SHARE_READ | FILE_SHARE_WRITE |
			 FILE_SHARE_DELETE,
			 FILE_OPEN,
			 FILE_NON_DIRECTORY_FILE |
			 FILE_SYNCHRONOUS_IO_NONALERT);

    if (!NT_SUCCESS(Error))
	return Error;
    
    Error = NtReadFile(ConfigFile, NULL, NULL, NULL, &IoStatusBlock,
		       config, CONFIG_FILE_BUFSIZE - 2, NULL);
    
    if (!NT_SUCCESS(Error))
	return Error;

    config[IoStatusBlock.Information] = 0xA;
    config[IoStatusBlock.Information+1] = 0;
    
    parse_config(path, config, entry);
    
    return STATUS_SUCCESS;
}



static int parse_config(char *path, char *buf, CONFIGENTRY *entry)
{
    char *ptr;
    char *prm;
    unsigned int linenum;
    int ok;
    
    memset(entry, 0, sizeof(CONFIGENTRY));

    strh_dnzcpy(entry->path, path, MAX_PATHNAME);
    entry->err_linenum = 0;

    linenum = 0;

    for (;;) {
	linenum++;
	ptr = strh_get_token(&buf, 10);
	if (!ptr)
	    break;

	ptr = strh_eat_space(ptr);

	if (*ptr == '\0' || *ptr == '#')	/* empty or comment line */
	    continue;

	prm = strh_eat_nonspace(ptr);
	if (*prm != '\0') {
	    *prm++ = '\0';
	}
	prm = strh_eat_space(prm);
	strh_eat_trailing_space(prm);

	ok = TRUE;

	if (!strcmp(ptr, "PrimaryBackupDir")) {
	    strh_dnzcpy(entry->primary_backup_dir, prm, MAX_PATHNAME);
	}
	else if (!strcmp(ptr, "SecondaryBackupDir")) {
	    strh_dnzcpy(entry->secondary_backup_dir, prm, MAX_PATHNAME);
	}
	else if (!strcmp(ptr, "SliceSize")) {
	    entry->iso_slice_size = strtoul(prm, NULL, 0);
	}
	else if (!strcmp(ptr, "Debug"))  {
	    if (!strcmp(prm, "true"))
		DebugFlag = TRUE;
	}
	else if (!strcmp(ptr, "DebugLog"))  {
	    strh_dnzcpy(entry->log, path, MAX_PATHNAME);
	    strh_dnzcat(entry->log, prm, MAX_PATHNAME);
	}
	else {
	    ok = FALSE;
	}

	if (!ok && entry->err_linenum == 0)
	    entry->err_linenum = linenum;
    }
    
    return (entry->err_linenum > 0 ? FALSE : TRUE);
}
