/*
 * detach.c
 *
 * Copyright 2004 rmenhal
 *
 * Licensed under GNU General Public License version 2. See the file COPYING
 * for details.
 */

#include "xboxkrnl.h"
#include "virtualcdrom.h"


static void mainthread(PVOID parm1, PVOID parm2);



/* Main thread setup code from Phoenix Bios Loader */

void boot(void)
{
    HANDLE hThread = 0;
    ULONG Id = 0;
    LARGE_INTEGER Timeout;
    ULONG Status = 0;
    
    Timeout.QuadPart = 0;
    
    
    if(!NT_SUCCESS(PsCreateSystemThreadEx(&hThread,
					  0,
					  65536,
					  0,
					  &Id,
					  NULL,
					  NULL,
					  FALSE,
					  FALSE, 
					  (PVOID)&mainthread))) {
	
	HalReturnToFirmware(2);
    }
    while(1) {
	Status = NtWaitForSingleObjectEx(hThread, 1 /* UserMode */ ,
					 FALSE, &Timeout);
	if (Status == STATUS_SUCCESS) {
	    NtClose(hThread);
	    HalReturnToFirmware(2);
	}
    }
}


static void mainthread(PVOID parm1, PVOID parm2)
{
    NTSTATUS status;
    OBJECT_ATTRIBUTES obj_attr;
    HANDLE h;
    IO_STATUS_BLOCK io_status;
    ANSI_STRING dev_name;

    RtlInitAnsiString(&dev_name, "\\Device\\CdRom1");

    obj_attr.RootDirectory = NULL;
    obj_attr.ObjectName = &dev_name;
    obj_attr.Attributes = OBJ_CASE_INSENSITIVE;

    status = NtOpenFile(&h, GENERIC_READ | SYNCHRONIZE, &obj_attr, &io_status,
			FILE_SHARE_READ,
			FILE_SYNCHRONOUS_IO_NONALERT);
    
    if (!NT_SUCCESS(status)) {
	HalReturnToFirmware(2);
    }
    
    status = NtDeviceIoControlFile(h, NULL, NULL, NULL, &io_status,
				   IOCTL_VIRTUAL_CDROM_DETACH,
				   NULL, 0, NULL, 0);
    
    NtClose(h);
    
    HalReturnToFirmware(2);
}
