#ifndef _LMATH_H
#define _LMATH_H

extern "C" float sin(float d);
extern "C" void *malloc(int size);

#define CUTOFF 10

float *sine_table;

#define BIG_360_MULTIPLE (360*40)
#define SIN(angle)     sine_table[(angle)%(360*res)]
#define COS(angle)     sine_table[(angle + 90000)%(360*res)]
#define res 100

void sinlut()
{
	float c;
	float step=1.0f/res;
	int i=0;
	sine_table = (float*)malloc(sizeof(float)*(res*360));
	for(c=step;c<360;c+=step)
	{
		sine_table[i++]=sin(c);
	}

}

float lsin(float d)
{
	if (d < 0)
		return -(SIN(-((int)(d*100))));
	else
		return SIN((int)(d*100));
}

float lcos(float d)
{
	if (d < 0)
		return -(COS(-((int)(d*100))));
	else
		return COS((int)(d*100));
}


//these could be done with libc....
inline float fabs(float i)
{
	if(i<0)
		return -i;
	return i;
}


inline double sqrt(double r) {
double x,y;
double tempf;
unsigned long *tfptr = ((unsigned long *)&tempf)+1;

    tempf = r;
    *tfptr=(0xbfcd4600-*tfptr)>>1;
    x=tempf;
    y=r*0.5; 
    x*=1.5-x*x*y; 
    x*=1.5-x*x*y;
    x*=1.5-x*x*y; 
    x*=1.5-x*x*y; 
    return x*r;
}


#endif // _LMATH_H

