;;;
;;; Compile:	nasm -o nkpatcher.xbe xboxapp.asm
;;;
;;; Originally nkpatcher patches were adapted and expanded from Complex !Loader
;;; 4034 patches (which are from EvoX 2.2 bios). Some patches were taken from
;;; EvoX M7. By now (nkpatcher7) the patching has been quite heavily modified
;;; and features go well past those of EvoX M7.
;;;
;;; Supports kernels 3944, 4034, 4627, 4817, 5101, 5530, 5713 and 5838.
;;;


;;; --------------------------------------------------------------------------
;;; Configuration for nkpatcher's Xbox application
;;; --------------------------------------------------------------------------

;;; nkpatcher reboot behaviour after patching has been done:	
;;; 
;;; BOOT_DASH_ONLY = Don't boot DVD.
;;; NORMAL_BOOT_ALWAYS = Always boot first DVD then dashboard.
;;; 
;;; default is to boot DVD first, unless doing IGR to dash.

; %define BOOT_DASH_ONLY
; %define NORMAL_BOOT_ALWAYS


;;; --------------------------------------------------------------------------
;;; Configuration end
;;; --------------------------------------------------------------------------

	
	

%include "header.asm"


	align 4
kernel_thunk:	
HalReturnToFirmware:	
	dd	0x80000000 + 49
HalWriteSMBusValue:	
	dd	0x80000000 + 50
LaunchDataPage:	
	dd	0x80000000 + 164
MmAllocateContiguousMemory:	
	dd	0x80000000 + 165
MmFreeContiguousMemory:	
	dd	0x80000000 + 171
MmPersistContiguousMemory:	
	dd	0x80000000 + 178
KeRaiseIrqlToDpcLevel:
	dd	0x80000000 + 129
KfLowerIrql:
	dd	0x80000000 + 161
XboxKrnlVersion:
	dd	0x80000000 + 324
XePublicKeyData:	
	dd	0x80000000 + 355

	dd	0		; end of table

			

defbootflags	dd 0
bootflags_addr	dd defbootflags	; This is only for the rebooting decision
				; after all patching is done


start:
	cld

chkkernelversion:
	mov	esi,[XboxKrnlVersion]
	test	esi,esi
	jz	near reboot

	cmp	dword [esi],byte 1
	jne	near reboot
	cmp	word [esi+6],byte 1
	jne	near reboot

patchkernel:		
	call	dword [KeRaiseIrqlToDpcLevel]
	push	eax

	cli
	mov	eax,cr0
	push	eax
	and	eax,0FFFEFFFFh
	mov	cr0,eax

	mov	eax,cr3
	mov	cr3,eax
	wbinvd

	call	patchmskeyback

	push	80010000h
	call	nkpatcher_patch_kernel
	test	eax,eax
	jz	.nobootfl
	mov	[bootflags_addr],eax
.nobootfl:	

	mov	eax,cr3
	mov	cr3,eax
	wbinvd

	pop	eax
	mov	cr0,eax
	sti

	pop	ecx
	call	dword [KfLowerIrql]


reboot:
	mov	esi,[LaunchDataPage]
	mov	ebx,[esi]

%ifndef BOOT_DASH_ONLY
%ifndef NORMAL_BOOT_ALWAYS
	mov	eax,[bootflags_addr]
	test	byte [eax],80h
	jnz	.bootdash
%endif

	test	ebx,ebx
	jz	.doboot

	push	ebx
	and	dword [esi],byte 0
	call	dword [MmFreeContiguousMemory]
	jmp	short .doboot
%endif	; BOOT_DASH_ONLY

.bootdash:
	mov	edi,1000h
	test	ebx,ebx
	jnz	.memok

	push	edi
	call	dword [MmAllocateContiguousMemory]
	test	eax,eax
	jz	.doboot
	mov	ebx,eax
	mov	[esi],eax
.memok:	

	push	byte 1
	push	edi
	push	ebx
	call	dword [MmPersistContiguousMemory]

	mov	edi,ebx
	xor	eax,eax
	mov	ecx,400h
	rep	stosd

	or	dword [ebx],byte -1

.doboot:
	push	byte 2
	call	dword [HalReturnToFirmware]
.inf:	jmp	short .inf





patchmskeyback:
	mov	eax,[XePublicKeyData]
	test	eax,eax
	jz	.fail

	mov	dword [eax+10h],10001h
	mov	dword [eax+110h],0A44B1BBDh
.fail:
	ret



;;; --------------------------------------------------------------------------
;;; Include patcher source
;;; --------------------------------------------------------------------------

%define INCLUDE_MODE
%define CODE_SECTION
%define DATA_SECTION

%include "nkpatcher.asm"

;;; --------------------------------------------------------------------------
;;; Patcher source included
;;; --------------------------------------------------------------------------


		
;;; 
;;; END OF CODE
;;; 


%include "footer.asm"
