;;; --------------------------------------------------------------------------
;;; Configuration for nkpatcher
;;; --------------------------------------------------------------------------

;;; Dashboard path

%define DASHBOARD_PATH '\Device\Harddisk0\Partition2\evoxdash.xbe'
	

;;; Reset-on-eject behaviour:	
;;;
;;; EJECT_FIX = Never reset on eject.
;;; CD_DVD_ALWAYS_ROE = Always reset on eject for CD/DVD loaded XBEs, never
;;;                     reset on eject for hard disk loaded XBEs.
;;;
;;; Default is to never reset on eject for hard disk loaded XBEs, but reset
;;; on eject CD/DVD loaded XBEs based on the ROE flag in the XBE header.

; %define EJECT_FIX
; %define CD_DVD_ALWAYS_ROE

	
;;; Automatic game region settings:
;;;
;;; GAME_REGION_AUTO = Set game region automatically based on the game region
;;;                    field in XBE header. Since the header may have several
;;;                    regions enabled there's a choice to be made. First
;;;                    tried is the game region from EEPROM, then the primary
;;;                    through tertiary regions below.
;;; GAME_REGION_IGNORE_REAL = Ignore the region stored in EEPROM and only
;;;                           use primary through tertiary regions below.
;;;
;;; Default is to use only the game region stored in the EEPROM and not
;;; change it.

%define GAME_REGION_AUTO
; %define GAME_REGION_IGNORE_REAL
	
%ifdef GAME_REGION_AUTO

;;; Game regions:
;;; 
;;; 1 = North America
;;; 2 = Japan
;;; 4 = Rest of world

%define GAME_REGION_PRIMARY	4
%define GAME_REGION_SECONDARY	1
%define GAME_REGION_TERTIARY	2

%endif	; GAME_REGION_AUTO


;;; In-Game Reset settings:	
;;;
;;; IGR = Enable IGR code
;;;
;;; Button combinations:
;;;	* triggers+back+start
;;;	* triggers+back+black
;;;	* triggers+start+black
;;; 
;;; IGR_TO_DASHBOARD = Reset to dashboard, not DVD. Changed button combos:
;;;	* triggers+back+start to dashboard
;;;	* triggers+back+black to dashboard
;;;	* triggers+tart+black to first DVD, then dashboard
;;;
;;; IGR_FULL_REBOOT = Do a full reboot instead of the default quick reboot.
;;;                   Some games hang (Soul Calibur 2 during a match) with
;;;                   quick reboot.
;;;
;;; IGR_MASTER_PORT #port_number = Only allow IGR from pad port #port_number,
;;;                                where #port_number is 0-3 (0 the left-most
;;;                                port, 3 the right-most.)
;;;
;;; IGR is not enabled by default.

%define IGR
%define IGR_TO_DASHBOARD
; %define IGR_FULL_REBOOT
; %define IGR_MASTER_PORT 0


;;; Xbox Live blocking:
;;;
;;; XBL_BLOCK = Enable blocking
;;;
;;; Blocking not enabled by default.

%define XBL_BLOCK


;;; Patches inside INIT section (boot unlocked HDs etc.)
;;;
;;; INIT_SEC_PATCHES = enable
;;;
;;; Do NOT enable these for nkpatcher.xbe executed on the Xbox (will crash
;;; and/or weird behaviour.)

; %define INIT_SEC_PATCHES


;;; --------------------------------------------------------------------------
;;; Configuration end
;;; --------------------------------------------------------------------------
