;;;
;;; Compile:	nasm -o nkpatcher.xbe nkpatcher.asm
;;;
;;; Supports kernels 3944, 4034, 4627, 4817, 5101, 5530, 5713 and 5838.
;;; 
;;; Kernel patches are adapted and expanded from Complex !Loader 4034 patches
;;; (which are from EvoX 2.2 bios). Some patches are taken from EvoX M7.
;;;
;;; Define EVOX_M7 to include some additional EvoX M7 patches (see the
;;; definition of the m7extra macro below for some comments.)
;;; 
;;; Define NORMAL_BOOT_SEQ to make nkpatcher boot DVD first, then dashboard.
;;; The default behaviour is to boot to dashboard only.
;;;


; %define NORMAL_BOOT_SEQ
; %define EVOX_M7



%include "header.asm"


	align 4
kernel_thunk:	
; MmAllocateContiguousMemoryEx:
; 	dd	0x80000000 + 166
; MmGetPhysicalAddress:
; 	dd	0x80000000 + 173
; NtAllocateVirtualMemory:
; 	dd	0x80000000 + 184
HalReturnToFirmware:	
	dd	0x80000000 + 49
HalWriteSMBusValue:	
	dd	0x80000000 + 50
LaunchDataPage:	
	dd	0x80000000 + 164
MmAllocateContiguousMemory:	
	dd	0x80000000 + 165
MmFreeContiguousMemory:	
	dd	0x80000000 + 171
MmPersistContiguousMemory:	
	dd	0x80000000 + 178
KeRaiseIrqlToDpcLevel:
	dd	0x80000000 + 129
KfLowerIrql:
	dd	0x80000000 + 161
XboxKrnlVersion:
	dd	0x80000000 + 324
XePublicKeyData:	
	dd	0x80000000 + 355

	dd	0		; end of table

			


dashstr		db '\Device\Harddisk0\Partition2\evoxdash.xbe',0
DASHSTRLEN	equ $-dashstr



start:
	cld

getkernelversion:
	mov	esi,[XboxKrnlVersion]
	test	esi,esi
	jz	near reboot

	cmp	dword [esi],byte 1
	jne	near reboot
	cmp	word [esi+6],byte 1
	jne	near reboot

patchkernel:		
	call	dword [KeRaiseIrqlToDpcLevel]
	push	eax

	cli
	mov	eax,cr0
	push	eax
	and	eax,0FFFEFFFFh
	mov	cr0,eax

	mov	eax,cr3
	mov	cr3,eax
	wbinvd

	movzx	eax,word [esi+4]
	push	dword .patchdone

	cmp	eax,3944
	je	near patch3944
	cmp	eax,4034
	je	near patch4034
	cmp	eax,4627
	je	near patch4627
	cmp	eax,4817
	je	near patch4817
	cmp	eax,5101
	je	near patch5101
	cmp	eax,5530
	je	near patch5530
	cmp	eax,5713
	je	near patch5713
	cmp	eax,5838
	je	near patch5838
	ret
	jmp	short .nopatching
.patchdone:	

	call	patchmskeyback

	mov	eax,cr3
	mov	cr3,eax
	wbinvd

.nopatching:	

	pop	eax
	mov	cr0,eax
	sti

	pop	ecx
	call	dword [KfLowerIrql]


%ifdef NORMAL_BOOT_SEQ

	;; This will boot DVD first, then dash. Game save exploiters
	;; wouldn't like it.
reboot:
	mov	esi,[LaunchDataPage]
	mov	ebx,[esi]
	test	ebx,ebx
	jz	.doboot

	push	ebx
	and	dword [esi],byte 0
	call	dword [MmFreeContiguousMemory]

.doboot:
	push	byte 2
	call	dword [HalReturnToFirmware]
.inf:	jmp	short .inf

		
%else	; NORMAL_BOOT_SEQ
	

	;; This will boot to dashboard.
reboot:	
	mov	esi,[LaunchDataPage]
	mov	edi,1000h
	mov	ebx,[esi]
	test	ebx,ebx
	jnz	.memok

	push	edi
	call	dword [MmAllocateContiguousMemory]
	test	eax,eax
	jz	.doboot
	mov	ebx,eax
	mov	[esi],eax
.memok:	

	push	byte 1
	push	edi
	push	ebx
	call	dword [MmPersistContiguousMemory]

	mov	edi,ebx
	xor	eax,eax
	mov	ecx,400h
	rep	stosd

	or	dword [ebx],byte -1

.doboot:
	push	byte 2
	call	dword [HalReturnToFirmware]
.inf:	jmp	short .inf


%endif	; NORMAL_BOOT_SEQ





patchmskeyback:
	mov	eax,[XePublicKeyData]
	test	eax,eax
	jz	.fail

	mov	dword [eax+10h],10001h
	mov	dword [eax+110h],0A44B1BBDh
.fail:
	ret

	


%macro	saveregs 0
	push	ebx
	push	esi
	push	edi
	push	ebp
%endmacro

%macro	restoreregs 0
	pop	ebp
	pop	edi
	pop	esi
	pop	ebx
%endmacro

	
;;; signature check, media type, region patch

%macro	mediapatch 4
	mov	edi,%1
	mov	eax,%2
	mov	ecx,%3
	call	patchmediatype

	;; section hash patch
	
	mov	dword [%4],0EB5FA5F3h
%endmacro

	
;;; partition 6 and dashstr patch (assumes mediapatch has been applied)

%macro	p6patch 6
	mov	edi,%1
	mov	ebp,%2
	mov	ecx,%3
	mov	edx,%4
	mov	eax,%5
	mov	ebx,%6
	call	patchpart6
%endmacro


;;; Some extra patches seen in EvoX M7

%macro	m7extra 5
%ifdef EVOX_M7

	;; This patches the exported function AvSendTVEncoderOption. I don't
	;; know what's the purpose.
	
	mov	dword [%1],%2
	mov	dword [%1+9*4],%3

	;; Complex !Loader kernel plugin source code claimed this would crash
	;; the box. If I run nkpatcher twice (second from boxplorer), my
	;; xbox crashes. Seems to work otherwise. Don't know what's the
	;; purpose of this patch, though. :P
	
; 	mov	word [%4],9090h

	;; This bypasses a failure check after some dvd-drive fiddling (?).
	;; Crashes my xbox similar to the patch above. So there's something
	;; wrong with this one too.
	
; 	mov	byte [%5],0EBh

%endif	; EVOX_M7
%endmacro
	
	



	;; OUT:	EDI = address to some free space
patchmediatype:
	mov	[.rreg+2],eax
	mov	[.rback+1],ecx
	
	mov	esi,.patch
	push	byte (.end_patch-.patch)
	pop	ecx
	rep	movsb

	ret

.patch:
	mov	ecx,80000000h
	mov	eax,[10158h]
	test	eax,ecx
	jnz	.dbgxbe
	xor	eax,05B6D40B6h
	xor	dword [10128h],0A8FC57ABh
	jmp	.adxok
.dbgxbe:xor	eax,0EFB1F152h
	xor	dword [10128h],094859D4Bh
.adxok:	mov	[10158h],eax
	mov	esi,[10118h]
	or	dword [esi+9Ch],80FFFFFFh
.cadj:	mov	[ebp-18h],esi
	mov	eax,[esi+0A0h]
.rreg:	test	[8003B2B8h],ecx
	jz	.mrsk
	and	eax,ecx
.mrsk:	mov	[ebp-10h],eax
	cmp	dword [esi],1D8h
	jbe	.rback
	and	byte [esi+1D8h],0FEh
.rback:	push	8002F181h
	ret
.end_patch:	



	;; For kernels 5713 and 5838
	;; 
	;; OUT:	EDI = address to some free space
patchmpoverwritefix:
	mov	[.rerrp+1],eax

	lea	eax,[edi-4]
	sub	eax,edx
	mov	[edx],eax
	
	mov	esi,.patch
	push	byte (.end_patch-.patch)
	pop	ecx
	rep	movsb

	ret

.patch:
	mov	esi,0C000003Ah
.rerrp:	push	8002F6B0h
	ret
.end_patch:

	
	
	;; OUT:	EDI = address to some free space
patchpart6:
	mov	[.rsize+1],eax
	mov	[.rfail+1],ecx
	mov	[.rok+1],edx

	mov	esi,.patch
	push	edi
	push	byte (.end_patch-.patch)
	pop	ecx
	rep	movsb

	push	edi
	mov	esi,dashstr
	push	byte DASHSTRLEN
	pop	ecx
	rep	movsb
	pop	dword [ebx]
	
	xchg	edi,ebp
	mov	al,68h		; push dword
	stosb
	pop	eax
	stosd
	mov	al,0C3h		; ret
	stosb
	mov	eax,0FEEB9090h
	stosd

	mov	edi,ebp
	ret

.patch:
	cmp	ebx,byte 6
	je	.rsize
.fail:	mov	eax,0C0000034h
.rfail:	push	800247BBh
	ret
.rsize:	mov	eax,[8003B438h]
	sub	eax,0EE8AB0h
	jbe	.fail
	mov	edx,512
	mul	edx
	mov	[ebp-20h],eax
	mov	[ebp-1Ch],edx
	mov	eax,0EE8AB0h
.rok:	push	80024731h
	ret
.end_patch:



;;; Some v1.0 kernels have it a slightly different

%macro	mpadjust 0
	mov	byte [patchmediatype.cadj+2],byte -14h
%endmacro



;;; Fix damage done by the media patch overwrite (kernels 5713, 5838)

%macro	mpoverwritefix 2
	mov	edx,%1
	mov	eax,%2
	call	patchmpoverwritefix
%endmacro




patch3944:
	saveregs
	mediapatch 80030262h,8003BE74h,80030309h,8002FD7Dh
	p6patch 8002FE6Ah,8002598Fh,80025A5Bh,800259D1h,8003BFF8h,8003049Ch
	m7extra 800315F8h,800315F1h,8003155Dh,80054F27h,800552BEh
	restoreregs
	ret

patch4034:
	saveregs
	mpadjust
	mediapatch 80030262h,8003BF34h,8003033Ch,8002FD7Dh
	p6patch 8002FE6Ah,800259AFh,80025A7Bh,800259F1h,8003C0B8h,800304D1h
	m7extra 80031235h,8003122Eh,8003119Ah,800551E6h,8005558Dh
	restoreregs
	ret
	
patch4627:
	saveregs
	mpadjust
	mediapatch 8002EFB2h,8003B158h,8002F0A6h,8002EACDh
	p6patch 8002EBBAh,8002464Fh,8002471Bh,80024691h,8003B2D8h,8002F23Bh
	m7extra 80030410h,80030409h,80030323h,80055A66h,80055DFFh
	restoreregs
	ret

patch4817:
	saveregs	
	mediapatch 8002F049h,8003B1B8h,8002F141h,8002EB5Dh
	p6patch 8002EC4Ah,800246DFh,800247ABh,80024721h,8003B338h,8002F2D6h
	m7extra 80030436h,8003042Fh,80030349h,80055A66h,80055DFFh
	restoreregs
	ret

patch5101:
	saveregs	
	mediapatch 8002F089h,8003B2B8h,8002F181h,8002EB9Dh
	p6patch 8002EC8Ah,800246EFh,800247BBh,80024731h,8003B438h,8002F316h
	m7extra 800304FBh,800304F4h,80030429h,80055A71h,80055E6Ch
	restoreregs
	ret

patch5530:
	saveregs	
	mediapatch 8002F456h,8003C138h,8002F54Eh,8002EF6Ch
	p6patch 8002F057h,800248BBh,80024987h,800248FDh,8003C2D0h,8002F6E3h
	m7extra 80030ED7h,80030ED0h,80030D40h,800552FEh,800556F4h
	restoreregs
	ret

patch5713:
patch5838:	
	saveregs	
	mediapatch 8002F450h,8003C158h,8002F574h,8002EF6Ch
	mpoverwritefix 8002F5D4h,8002F6B0h
	p6patch 8002F057h,800248BBh,80024987h,800248FDh,8003C2F0h,8002F6FDh
	m7extra 80030EF1h,80030EEAh,80030D5Ah,8005531Eh,80055714h
	restoreregs
	ret

	

	
;;; 
;;; END OF CODE
;;; 


%include "footer.asm"
