;;; 
;;; Compile this with NASM.
;;;
;;; Metoo BFM footer for Evox M8+ bios 2bl.
;;; 
;;; Compile and paste this at offset 0x35b0
;;; into the 2bl (or 0x3feb0 into the 256k bios image).
;;;


BITS 32
ORG 0x4035b0

loader:	
	cli
	cld
	mov	edx,ecx
	mov	edi,0x8000f000
	mov	ecx,0x40
	mov	eax,0xe3
pmempagesl:
	mov	[edi+0x800],eax
	stosd
	add	eax,0x400000
	loop	pmempagesl

	mov	ecx,0x1c0
	xor	eax,eax
nmpagesl:	
	mov	[edi+0x800],eax
	stosd
	loop	nmpagesl

	mov	edi,0x8000f000
	mov	eax,0xf063
	mov	[edi+0xc00],eax
	sub	eax,0x1000
	mov	[edi+0xff0],eax
	mov	[edi+0xff4],eax
	mov	[edi+0xff8],eax
	mov	[edi+0xffc],eax

	sub	edi,0x1000
	mov	ebp,4
maprommirl:
	lea	eax,[edx+0x63]
	mov	ecx,0x100
maproml:stosd
	add	eax,0x1000
	loop	maproml
	dec	ebp
	jnz	maprommirl

	mov	eax,0xf000
	mov	cr3,eax
	lgdt	[0x4001c0]
	jmp	0x8:dtcj
dtcj:	
	mov	eax,0x10
	mov	ds,ax
	mov	es,ax
	mov	ss,ax
	mov	esp,0x80400000
	xor	eax,eax
	mov	fs,ax
	mov	gs,ax

	add	edx,0x80100000


unpackandrun:
	push	edx
	and	dword [0x80403586],byte 0

	call	0x40075e

	mov	ebx,0x80010000
	pop	eax
	add	[ebx+0x30],eax

	push	ebx
	call	0x4027db
	test	eax,eax
	jnz	.hok
	call	0x400748
.hok:	
	mov	edx,[eax+0x28]
	add	edx,ebx

	cld
	mov	ecx,[ebx+0x2c]
	shr	ecx,2
	mov	esi,[ebx+0x30]
	mov	edi,[ebx+0x34]
	rep	movsd

	mov	ecx,[ebx+0x28]
	xor	eax,eax
	shr	ecx,2
	rep	stosd

	push	eax
	push	(kernel_param+0x80000000)
	call	edx
.inf:	jmp	short .inf	


kernel_param:	
	times (0x150-20-$+$$) db 0
.end:	


metoobfm_footer:
	dd 0
	dw loader-0x400000
	dw kernel_param.end-kernel_param
	dw kernel_param-0x400000
	dw $-0x400000+10
	dd 0x400000
	dd 'BFM1'
.end:	
	