#ifndef         __XBOXKRNL_H__
#define         __XBOXKRNL_H__

#ifdef  __cplusplus
extern "C" {
#endif

#include "types.h"

typedef VOID
(*PIO_APC_ROUTINE)(PVOID ApcContext,
                   struct _IO_STATUS_BLOCK* IoStatusBlock,
                   ULONG Reserved);

/* Xbox Kernel Functions */
extern VOID __attribute__((__stdcall__))
(*RtlInitAnsiString)(PANSI_STRING, PCSZ);
extern LONG __attribute__((__stdcall__))(*RtlCompareString)(
	PSTRING String1,
	PSTRING String2,
	BOOLEAN CaseInSensitive
);
extern NTSTATUS __attribute__((__stdcall__))(*RtlUnicodeStringToAnsiString)(
	PANSI_STRING DestinationString,
	PUNICODE_STRING SourceString,
	BOOLEAN AllocateDestinationString
);
extern NTSTATUS __attribute__((__stdcall__))(*RtlAnsiStringToUnicodeString)(
	PUNICODE_STRING DestinationString,
	PANSI_STRING SourceString,
	BOOLEAN AllocateDestinationString
);
extern NTSTATUS __attribute__((__stdcall__))
(*NtClose)(HANDLE);
extern PVOID __attribute__((__stdcall__))
(*MmAllocateContiguousMemory)(ULONG);
extern PVOID __attribute__((__stdcall__))
(*MmAllocateContiguousMemoryEx)(ULONG, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, ULONG, ULONG);
extern PVOID __attribute__((__stdcall__))
(*MmAllocateSystemMemory)(ULONG,ULONG);
extern VOID __attribute__((__stdcall__))
(*MmFreeContiguousMemory)(PVOID);
extern PHYSICAL_ADDRESS __attribute__((__stdcall__))
(*MmGetPhysicalAddress)(PVOID);
extern NTSTATUS __attribute__((__stdcall__))
(*NtAllocateVirtualMemory)(PVOID*, ULONG, PULONG, ULONG, ULONG);
extern PANSI_STRING XeImageFileName;
extern PUCHAR XboxEEPROMKey;
extern PUCHAR XboxHDKey;
extern NTSTATUS __attribute__((__stdcall__))
(*HalWriteSMBusValue)(UCHAR, UCHAR, BOOLEAN, DWORD);
extern NTSTATUS __attribute__((__stdcall__))
(*HalReadSMBusValue)(UCHAR, UCHAR, BOOLEAN, PDWORD);
extern VOID __attribute__((__stdcall__))
(*RtlZeroMemory)(PVOID Destination,ULONG Length);
extern ULONG __attribute__((__stdcall__))
(*MmQueryAllocationSize)(PVOID   BaseAddress);
extern VOID __attribute__((__stdcall__))
(*MmPersistContiguousMemory)(PVOID BaseAddress,ULONG NumberOfBytes,BOOLEAN Persist);
extern VOID __attribute__((__stdcall__))
(*RtlMoveMemory)(VOID *Destination,CONST VOID *Source,SIZE_T Length);
extern VOID __attribute__((__stdcall__))
(*XcRC4Crypt)(PRC4_SBOX Sbox, SIZE_T DataLength, CONST BYTE *Data);
extern VOID __attribute__((__stdcall__))
(*XcRC4Key)(PRC4_SBOX Sbox, SIZE_T KeyLength, CONST BYTE *Key);
extern PVOID __attribute__((__stdcall__))
(*ExAllocatePoolWithTag)(SIZE_T NumberOfBytes,ULONG Tag);
extern VOID __attribute__((__stdcall__))
(*ExFreePool)(PVOID P);
extern NTSTATUS __attribute__((__stdcall__))(*NtReadFile)(
        HANDLE  FileHandle,
        HANDLE  Event,
        PIO_APC_ROUTINE ApcRoutine,
        PVOID   ApcContext,
        PIO_STATUS_BLOCK IoStatusBlock,
        PVOID   Buffer,
        ULONG   Length,
        PLARGE_INTEGER ByteOffset
);
extern NTSTATUS __attribute__((__stdcall__))(*NtWriteFile)(
        HANDLE  FileHandle,
        HANDLE  Event,
        PIO_APC_ROUTINE ApcRoutine,
        PVOID   ApcContext,
        PIO_STATUS_BLOCK IoStatusBlock,
        PVOID   Buffer,
        ULONG   Length,
        PLARGE_INTEGER ByteOffset
);
extern NTSTATUS __attribute__((__stdcall__))(*NtCreateFile) (
	PHANDLE FileHandle,
	ACCESS_MASK DesiredAccess,
	POBJECT_ATTRIBUTES ObjectAttributes,
	PIO_STATUS_BLOCK IoStatusBlock,
	PLARGE_INTEGER AllocationSize OPTIONAL,
	ULONG FileAttributes,
	ULONG ShareAccess,
	ULONG CreateDisposition,
	ULONG CreateOptions
);
extern NTSTATUS __attribute__((__stdcall__))(*NtOpenFile) (
	PHANDLE FileHandle,
	ACCESS_MASK DesiredAccess,
	POBJECT_ATTRIBUTES ObjectAttributes,
	PIO_STATUS_BLOCK IoStatusBlock,
	ULONG ShareAccess,
	ULONG OpenOptions
);
extern NTSTATUS __attribute__((__stdcall__))(*NtQueryInformationFile)(
        HANDLE FileHandle,
        PIO_STATUS_BLOCK IoStatusBlock,
        PVOID FileInformation,
        ULONG FileInformationLength,
        FILE_INFORMATION_CLASS FileInformationClass
);
extern NTSTATUS __attribute__((__stdcall__))(*NtSetInformationFile)(
        HANDLE  FileHandle,
        PVOID   IoStatusBlock,
        PVOID   FileInformation,
        ULONG   Length,
        ULONG   FileInformationClass
);
extern NTSTATUS __attribute__((__stdcall__))(*IoCreateSymbolicLink)(
	PANSI_STRING SymbolicLinkName,
	PANSI_STRING DeviceName
);
extern NTSTATUS __attribute__((__stdcall__))(*IoDeleteSymbolicLink)(
	PANSI_STRING SymbolicLinkName
);
extern NTSTATUS __attribute__((__stdcall__))(*IoDismountVolumeByName)(
	PANSI_STRING DeviceName
);
extern VOID __attribute__((__stdcall__))(*HalReturnToFirmware)(
	UINT	value
);
extern NTSTATUS __attribute__((__stdcall__))(*NtWaitForSingleObject)(
	HANDLE	Handle,
	BOOLEAN	Alertable,
	PLARGE_INTEGER Timeout
);
extern NTSTATUS __attribute__((__stdcall__))(*NtWaitForSingleObjectEx)(
	HANDLE	Handle,
	DWORD	WaitMode,
	BOOLEAN	Alertable,
	PLARGE_INTEGER Timeout
);
extern NTSTATUS __attribute__((__stdcall__))(*PsCreateSystemThreadEx)(
	PHANDLE	ThreadHandle,
	ULONG	ThreadExtraSize,
	ULONG	KernelStackSize,
	ULONG	TlsDataSize,
	PULONG	ThreadId,
	PVOID	StartContext1,
	PVOID	StartContext2,
	BOOLEAN	CreateSuspended,
	BOOLEAN	DebugStack,
	PVOID	StartRoutine
);
extern DWORD __attribute__((__stdcall__))(*AvSendTVEncoderOption)(
	DWORD   VideoBase,
	DWORD	unknown1,
	DWORD	unknown2,
	PDWORD	outdata
);
extern VOID __attribute__((__stdcall__))(*AvSetDisplayMode)(
	DWORD	VideoBase,
	DWORD	unknown1,
	DWORD	unknown2,
	DWORD	unknown3,
	DWORD	Pitch, /* maybe */
	DWORD	FramePhysPos /* maybe */
);
extern PVOID __attribute__((__stdcall__))(*AvGetSavedDataAddress)(VOID);
extern VOID __attribute__((__stdcall__))(*AvSetSavedDataAddress)(
	PVOID	data
);
extern NTSTATUS __attribute__((__stdcall__))(*NtDeviceIoControlFile)(
	HANDLE	Handle,
	HANDLE	Event,
	PIO_APC_ROUTINE ApcRoutine,
	PVOID	ApcContext,
	PIO_STATUS_BLOCK IoStatusBlock,
	ULONG	IoControlCode,
	PVOID	InputBuffer,
	ULONG	InputBufferLength,
	PVOID	OutputBuffer,
	ULONG	OutputBufferLength
);
extern NTSTATUS __attribute__((__stdcall__))(*NtQueryDirectoryFile)(
	HANDLE	Handle,
	HANDLE	Event,
	PIO_APC_ROUTINE ApcRoutine,
	PVOID	ApcContext,
	PIO_STATUS_BLOCK IoStatusBlock,
	PVOID	FileInformation,
	ULONG	Length,
	ULONG	FileInformationClass,
	PANSI_STRING FileName,
	BOOLEAN RestartScan
);
extern NTSTATUS __attribute__((__stdcall__))(*NtQueryVolumeInformationFile)(
        HANDLE FileHandle,
        PIO_STATUS_BLOCK IoStatusBlock,
        PVOID FsInformation,
        ULONG FsInformationLength,
        ULONG FsInformationClass
);
extern PVOID *LaunchDataPage;
extern VOID __attribute__((__stdcall__))(*KeQuerySystemTime)(
	PLARGE_INTEGER CurrentTime
);
extern BOOLEAN __attribute__((__stdcall__))(*RtlTimeToTimeFields)(
	PLARGE_INTEGER Time,
	PTIME_FIELDS TimeFields
);


#ifdef  __cplusplus
};
#endif

#endif          //__XBOXKRNL_H__
