/*
 * shadowcmaker.c
 *
 * Copyright 2004 rmenhal
 *
 * Licensed under GNU General Public License version 2. See the file COPYING
 * for details.
 */

#include "xboxkrnl.h"
#include "virtualcdrom.h"
#include "strh.h"


#define COPY_BUFFER_SIZE		(16*1024*1024)

#define MAX_PATHNAME		256


static char source_partition_name[] = "\\Device\\Harddisk0\\Partition2";
static char destination_root_name[] = "\\Device\\Harddisk0\\Partition1\\";
static char destination_path_name[] = "shadowc\\shadowc.img";


static void mainthread(PVOID parm1, PVOID parm2);



/* Main thread setup code from Phoenix Bios Loader */

void boot(void)
{
    HANDLE hThread = 0;
    ULONG Id = 0;
    LARGE_INTEGER Timeout;
    ULONG Status = 0;
    
    Timeout.QuadPart = 0;
    
    
    if(!NT_SUCCESS(PsCreateSystemThreadEx(&hThread,
					  0,
					  65536,
					  0,
					  &Id,
					  NULL,
					  NULL,
					  FALSE,
					  FALSE, 
					  (PVOID)&mainthread))) {
	
	HalReturnToFirmware(2);
    }
    while(1) {
	Status = NtWaitForSingleObjectEx(hThread, 1 /* UserMode */ ,
					 FALSE, &Timeout);
	if (Status == STATUS_SUCCESS) {
	    NtClose(hThread);
	    HalReturnToFirmware(2);
	}
    }
}


static NTSTATUS get_partition_info(PPARTITION_INFORMATION info, char *name)
{
    NTSTATUS status;
    OBJECT_ATTRIBUTES obj_attr;
    HANDLE h;
    IO_STATUS_BLOCK io_status;
    ANSI_STRING part_name;

    RtlInitAnsiString(&part_name, name);
    
    obj_attr.RootDirectory = NULL;
    obj_attr.ObjectName = &part_name;
    obj_attr.Attributes = OBJ_CASE_INSENSITIVE;

    status = NtOpenFile(&h, GENERIC_READ | SYNCHRONIZE, &obj_attr, &io_status,
			FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE,
			FILE_SYNCHRONOUS_IO_NONALERT);
    
    if (!NT_SUCCESS(status))
	return status;

    status = NtDeviceIoControlFile(h, NULL, NULL, NULL, &io_status,
				   IOCTL_DISK_GET_PARTITION_INFO,
				   NULL, 0,
				   info, sizeof(PARTITION_INFORMATION));
    
    NtClose(h);
    
    return status;
}


static NTSTATUS open_create_intermediate(PHANDLE last_dir,
					 char **open_create_unparsed,
					 HANDLE root,
					 char *open_path,
					 char *open_create_path)
{
    NTSTATUS status;
    HANDLE current_root, next_root;
    OBJECT_ATTRIBUTES obj_attr;
    ANSI_STRING ansi_str;
    IO_STATUS_BLOCK io_status;
    char path[MAX_PATHNAME];
    char *p, *nextp;

    RtlInitAnsiString(&ansi_str, open_path);

    obj_attr.RootDirectory = root;
    obj_attr.ObjectName = &ansi_str;
    obj_attr.Attributes = OBJ_CASE_INSENSITIVE;

    status = NtOpenFile(&current_root,
			GENERIC_READ | GENERIC_WRITE | SYNCHRONIZE,
			&obj_attr, &io_status,
			FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE,
			FILE_SYNCHRONOUS_IO_NONALERT |
			FILE_DIRECTORY_FILE);

    if (!NT_SUCCESS(status))
	return status;

    strh_dnzcpy(path, open_create_path, sizeof(path));
    nextp = path;

    if (open_create_unparsed)
	*open_create_unparsed = open_create_path;
    
    while ((p = strh_get_token(&nextp, '\\')) != NULL) {

	if (open_create_unparsed)
	    *open_create_unparsed = open_create_path + (nextp - path);

	if (*p == '\0')
	    continue;

	RtlInitAnsiString(&ansi_str, p);
	
	obj_attr.RootDirectory = current_root;
	obj_attr.ObjectName = &ansi_str;
	obj_attr.Attributes = OBJ_CASE_INSENSITIVE;

	status = NtCreateFile(&next_root,
			      GENERIC_READ | GENERIC_WRITE | SYNCHRONIZE,
			      &obj_attr, &io_status, NULL, 0,
			      FILE_SHARE_READ | FILE_SHARE_WRITE |
			      FILE_SHARE_DELETE,
			      FILE_OPEN_IF,
			      FILE_SYNCHRONOUS_IO_NONALERT |
			      FILE_DIRECTORY_FILE);

	NtClose(current_root);

	if (!NT_SUCCESS(status))
	    return status;

	current_root = next_root;
    }

    if (last_dir)
	*last_dir = current_root;
    else
	NtClose(current_root);

    return STATUS_SUCCESS;
}



static void mainthread(PVOID parm1, PVOID parm2)
{
    NTSTATUS status;
    OBJECT_ATTRIBUTES dev_attr;
    OBJECT_ATTRIBUTES file_attr;
    ANSI_STRING dev_name;
    ANSI_STRING file_name;
    HANDLE dev_handle;
    HANDLE file_handle;
    IO_STATUS_BLOCK io_status;
    PARTITION_INFORMATION part_info;
    void *membuf;
    unsigned long membuf_size;
    LARGE_INTEGER ofs;
    LARGE_INTEGER data_left;
    ULONG chunk_size;
    char *file_name_sz;


    status = get_partition_info(&part_info, source_partition_name);

    if (!NT_SUCCESS(status)) {
	HalReturnToFirmware(2);
    }

    
    membuf = NULL;
    membuf_size = COPY_BUFFER_SIZE;

    status = NtAllocateVirtualMemory(&membuf, 0, &membuf_size,
				     MEM_COMMIT | MEM_NOZERO, PAGE_READWRITE);
    
    if (!NT_SUCCESS(status)) {
	HalReturnToFirmware(2);
    }


    RtlInitAnsiString(&dev_name, "\\Device\\Harddisk0\\Partition0");

    dev_attr.RootDirectory = NULL;
    dev_attr.ObjectName = &dev_name;
    dev_attr.Attributes = OBJ_CASE_INSENSITIVE;

    status = NtOpenFile(&dev_handle,
			GENERIC_READ | SYNCHRONIZE, &dev_attr, &io_status,
			FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE,
			FILE_SYNCHRONOUS_IO_NONALERT);
    
    if (!NT_SUCCESS(status)) {
	HalReturnToFirmware(2);
    }


    status = open_create_intermediate(&file_attr.RootDirectory,
				      &file_name_sz,
				      NULL, destination_root_name,
				      destination_path_name);

    if (!NT_SUCCESS(status)) {
	HalReturnToFirmware(2);
    }

    RtlInitAnsiString(&file_name, file_name_sz);

    file_attr.ObjectName = &file_name;
    file_attr.Attributes = OBJ_CASE_INSENSITIVE;

    status = NtCreateFile(&file_handle,
			  GENERIC_WRITE | SYNCHRONIZE,
			  &file_attr, &io_status,
			  &part_info.PartitionLength,
			  0,
			  FILE_SHARE_READ | FILE_SHARE_WRITE,
			  FILE_CREATE,
			  FILE_SYNCHRONOUS_IO_NONALERT |
			  FILE_NON_DIRECTORY_FILE);

    NtClose(file_attr.RootDirectory);
    
    if (!NT_SUCCESS(status)) {
	HalReturnToFirmware(2);
    }


    ofs = part_info.StartingOffset;
    data_left = part_info.PartitionLength;
    
    while (data_left.QuadPart > 0) {
	chunk_size = data_left.QuadPart < COPY_BUFFER_SIZE ?
	    data_left.QuadPart : COPY_BUFFER_SIZE;
	
	status = NtReadFile(dev_handle, NULL, NULL, NULL, &io_status,
			    membuf, chunk_size, &ofs);

	if (NT_SUCCESS(status)) {
	    status = NtWriteFile(file_handle, NULL, NULL, NULL, &io_status,
				 membuf, chunk_size, NULL);
	}

	if (!NT_SUCCESS(status))
	    break;

	ofs.QuadPart += chunk_size;
	data_left.QuadPart -= chunk_size;
    }


    NtClose(dev_handle);
    NtClose(file_handle);
    
    HalReturnToFirmware(2);
}
