/*
 * video-related stuff
 * note we are not yet able to init the video to get a raster.... help needed
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boot.h"


#define XBV_ATTR_REG_INDEX	0xfd6013c0
#define XBV_ATTR_REG_DATA	0xfd6013c1
#define XBV_CRTC_REG_INDEX	0xfd6013d4
#define XBV_CRTC_REG_DATA	0xfd6013d5
#define XBV_GRA_REG_INDEX	0xfd0C03ce
#define XBV_GRA_REG_DATA	0xfd0C03cf
#define XBV_SEQ_REG_INDEX	0xfd0C03c4
#define XBV_SEQ_REG_DATA	0xfd0C03c5
#define XBV_MISC_REG	0xfd0C03c2
#define XBV_PRAMDAC_VPLL_COEFF	0xfd680508
#define XBV_PRAMDAC_MPLL_COEFF	0xfd680504
#define XBV_PRAMDAC_PLL_COEFF_SELECT	0xfd68050C
#define XBV_PRAMDAC_GENERAL_CONTROL	0xfd680600
#define XBV_PRAMDAC_GRCURSOR_START_POS	0xfd680300
#define XBV_PMC_INTR_0	0x00000100
#define XBV_PMC_INTR_EN_0	0x00000140
#define XBV_PMC_ENABLE	0x00000200
#define XBV_PFIFO_INTR_0	0x00002100
#define XBV_PFIFO_INTR_EN_0	0x00002140
#define XBV_PFIFO_CONFIG_0	0x00002200
#define XBV_PFIFO_RAMHT	0x00002210
#define XBV_PFIFO_RAMFC	0x00002214
#define XBV_PFIFO_RAMRO	0x00002218
#define XBV_PFIFO_CACHES	0x00002500
#define XBV_PFIFO_CACHE0_PUSH0	0x00003000
#define XBV_PFIFO_CACHE1_PUSH0	0x00003200
#define XBV_PFIFO_CACHE0_PUSH1	0x00003004
#define XBV_PFIFO_CACHE1_PUSH1	0x00003204
#define XBV_PFIFO_CACHE1_DMA0	0x00003220
#define XBV_PFIFO_CACHE1_DMA1	0x00003224
#define XBV_PFIFO_CACHE1_DMA2	0x00003228
#define XBV_PFIFO_CACHE0_PULL0	0x00003040
#define XBV_PFIFO_CACHE1_PULL0	0x00003240
#define XBV_PFIFO_CACHE1_PULL1	0x00003250
#define XBV_PFIFO_CACHE1_PUT	0x00003210
#define XBV_PFIFO_CACHE1_GET	0x00003270
#define XBV_PFIFO_RUNOUT_PUT	0x00002410
#define XBV_PFIFO_RUNOUT_GET	0x00002420
#define XBV_PFIFO_RUNOUT_STATUS	0x00002400
#define XBV_PFB_BOOT_0	0xfd100000
#define XBV_PFB_CONFIG_0	0xfd100200
#define XBV_PEXTDEV_BOOT_0	0xfd101000
#define XBV_PBUS_DEBUG_0	0xfd001080
#define XBV_PBUS_DEBUG_1	0xfd001084
#define XBV_PFB_BOOT_0	0xfd100000
#define XBV_PFB_DELAY_1	0xfd100044
#define XBV_PFB_DEBUG_0	0xfd100080
#define XBV_PFB_GREEN_0	0xfd1000C0
#define XBV_PRAMDAC_MPLL_COEFF	0xfd680504
#define XBV_PRAMDAC_VPLL_COEFF	0xfd680508
#define XBV_PRAMDAC_VSERR_WIDTH	0xfd680700
#define XBV_PRAMDAC_VEQU_END	0xfd680704
#define XBV_PRAMDAC_VBBLANK_END	0xfd680708
#define XBV_PRAMDAC_VBLANK_END	0xfd68070C
#define XBV_PRAMDAC_VBLANK_START	0xfd680710
#define XBV_PRAMDAC_VBBLANK_START	0xfd680714
#define XBV_PRAMDAC_VEQU_START	0xfd680718
#define XBV_PRAMDAC_VTOTAL	0xfd68071C
#define XBV_PRAMDAC_HSYNC_WIDTH	0xfd680720
#define XBV_PRAMDAC_HBURST_START	0xfd680724
#define XBV_PRAMDAC_HBURST_END	0xfd680728
#define XBV_PRAMDAC_HBLANK_START	0xfd68072C
#define XBV_PRAMDAC_HBLANK_END	0xfd680730
#define XBV_PRAMDAC_HTOTAL	0xfd680734
#define XBV_PRAMDAC_HEQU_WIDTH	0xfd680738
#define XBV_PRAMDAC_HSERR_WIDTH	0xfd68073C

// these two arrays were captured being sent into the Conextant chip over I2C
// on a working machine.  We have confirmed we are sending the same sequences, but we are getting
// different results on I2C reads from the chip as of 2002-07-26

const WORD waVideoEncoder[] = {
0xBA80, 0xBA3F, 0x6C46, 0x6CC6, 0x2E00, 0x3000, 0x3228, 0x3480, 0x3800, 0x3A00, 0x3C80, 0x4080, 0x6000, 0x6200,
0x6400, 0x6C46, 0x6E00, 0x700F, 0x7200, 0x7401, 0xC401, 0xC69C, 0xC89B, 0xCAC0, 0xCCC0, 0xD840, 0xD600, 0x36E4,
0x3E80, 0x5A00, 0x5C00, 0x6641, 0x6835, 0x6A03, 0x763C, 0x7888, 0x7A76, 0x7C8C, 0x7E44, 0x8015, 0x8216, 0x8420,
0x86A6, 0x8800, 0x8AB6, 0x8CF7, 0x8E03, 0x900D, 0x9223, 0x94E0, 0x9606, 0x98E1, 0x9A4A, 0x9C55, 0x9E15, 0xA00B,
0xA224, 0xA4F0, 0xA65E, 0xA8D9, 0xAA9B, 0xACA3, 0xAE33, 0xB098, 0xB283, 0xB42D, 0xB652, 0xCE19, 0xDA05, 0xDC57,
0xDE20, 0xE040, 0xE26E, 0xE47E, 0xE6F4, 0xE851, 0xEA0F, 0xECF1, 0xEE05, 0xF0D3, 0xF278, 0xF4A2, 0xF625, 0xF854,
0xFAA5, 0xFC00, 0x0000, 0x0000, 0x0000
};

const WORD waVideoEncoder2[] = {
0xBA80, 0xBA3F, 0x6C46, 0x6CC6, 0x2E00, 0x3000, 0x3228, 0x3480, 0x3800, 0x3A00, 0x3C80, 0x4080, 0x6000, 0x6200,
0x6400, 0x6C46, 0x6E00, 0x700F, 0x7200, 0x7401, 0xC401, 0xC69C, 0xC89B, 0xCAC0, 0xCCC0, 0xD840, 0xD600, 0x36D2,
0x3E80, 0x5AFF, 0x5C00, 0x66AD, 0x683F, 0x6A03, 0x7628, 0x7888, 0x7A74, 0x7C8A, 0x7E42, 0x800A, 0x8216, 0x8422,
0x86A6, 0x8800, 0x8A14, 0x8C7E, 0x8E03, 0x9071, 0x922A, 0x9440, 0x960A, 0x9800, 0x9A50, 0x9CC7, 0x9EF1, 0xA00A,
0xA224, 0xA4F0, 0xA65E, 0xA8D9, 0xAA9A, 0xACA4, 0xAE18, 0xB075, 0xB217, 0xB42E, 0xB600, 0xCE19, 0xDA05, 0xDC57,
0xDE20, 0xE040, 0xE26E, 0xE47E, 0xE6F4, 0xE851, 0xEA0F, 0xECF1, 0xEE05, 0xF0D3, 0xF278, 0xF4A2, 0xF625, 0xF854,
0xFAA5, 0xFC00, 0x0000, 0x0000, 0x0000
};

// these arrays were read out of a functional nForce motherboard in 80 x 25 text mode

	const unsigned char reg3D4[] = { 0x5F, 0x4F, 0x50, 0x82, 0x54, 0x80,
0xBF, 0x1F, 0x0, 0x4F, 0xE, 0xF, 0x0, 0x0, 0x3, 0x97, 0x9C, 0x8E, 0x8F,
0x28, 0x1F, 0x96, 0xB9, 0xA3, 0xFF, 0x0, 0x3D, 0x3, 0x18, 0x0, 0x0, 0x3,
0x80, 0xFA, 0x20, 0x10, 0x80, 0x0, 0x3F, 0xB1, 0x0, 0x0, 0x0, 0x3, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x11, 0x3E, 0x30, 0x0, 0xFF,
0x0, 0x20, 0x9, 0x0, 0x1, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x66, 0x0, 0x33, 0x30, 0x4, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0 };
	const unsigned char reg3CE[] = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0,
0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0,
0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0, 0x0, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0, 0xFF, 0x0,
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xE, 0x0,
0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
0xE, 0x0, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 };
	const unsigned char reg3C4[] = { 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0,
0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0,
0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0,
0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0,
0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0,
0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0,
0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0,
0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0,
0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0,
0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0,
0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0,
0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0,
0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0,
0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0 };

// memory mapped IO

void vgaout(unsigned int port, unsigned char reg, unsigned char data) {
	*((volatile unsigned char*)(port)) = reg;
	*((volatile unsigned char*)(port+1)) = data;
}

void voutb(int nAds, BYTE b) {
	*((volatile unsigned char*)(nAds)) = b;
}


void BootVgaInitialization() {

	int i=0;



	voutb(0xFd0c0094,0x0);  // enable access to port 0x102
 	voutb(0xfd0c46E8,0x08); // ADDEN VSE ?? <-- not sure on this one
 	voutb(0xfd0c0102,0x01); // enable VGA
 	voutb(0xfd0c03c3,0x01); // enable VGA
 	voutb(0xfd0c03cc,0x02); // enable RAM access
 	voutb(0xfd0c094,0x28);  // disable access to port 0x102
/*
	voutb(0xFd0c46E8, 0x10);  // Put into setup mode
	voutb(0xFd0c03C3, 0x10);
	voutb(0xFd0c0102, 0x01);   // Enable registers
	voutb(0xFd0c46E8, 0x08);  // Enable video
	voutb(0xFd0c03C3, 0x08);
	voutb(0xFd0c4AE8, 0x00);
*/


	for (i = 0; i < 256; i++) {
		vgaout(XBV_CRTC_REG_INDEX, i, reg3D4[i]);
	}
	for (i = 0; i < 256; i++) {
		vgaout(XBV_GRA_REG_INDEX, i, reg3CE[i]);
	}
	for (i = 0; i < 256; i++) {
		vgaout(XBV_SEQ_REG_INDEX, i, reg3C4[i]);
	}



	I2CTransmitWord( 0x10, 0x0b01, false);

	for(i=0;i<(sizeof(waVideoEncoder)/sizeof(WORD));i++) {
		I2CTransmitWord(0x45, waVideoEncoder[i], false);
	}
	i= I2CTransmitByteGetReturn(0x45, 0x6c);
//		bprintf(" vidrx(Enc ads 6c normally 46)=%02X\n",i);

		I2CTransmitWord(0x45, 0x6cc6, false);
		I2CTransmitWord(0x45, 0xba24, false);
		I2CTransmitWord(0x45, 0x60c8, false);
		I2CTransmitWord(0x45, 0x6200, false);
		I2CTransmitWord(0x45, 0x6400, false);

		I2CTransmitWord( 0x10, 0x0b00, false);
		i=I2CTransmitByteGetReturn(0x10, 0x11);
//		bprintf(" vidrx(PIC ads 11 normally 04)=%02X\n", i&0xff);
		I2CTransmitWord( 0x10, 0x0d00 | (i&0xff), false);
		i=I2CTransmitByteGetReturn(0x10, 0x03);
//		bprintf(" vidrx(PIC ads 03 normally 10)=%02X\n",i);

		I2CTransmitWord( 0x10, 0x1a01, false);

		i=I2CTransmitByteGetReturn(0x45, 0xc8);
//		bprintf(" vidrx(Enc ads C8 normally 9b)=%02X\n", i);

		I2CTransmitWord(0x45, 0xc880, false);
		I2CTransmitWord(0x45, 0x3480, false);
		i=I2CTransmitByteGetReturn(0x45, 0x96);
//		bprintf(" vidrx(Enc ads 96 normally 06)=%02X\n", i);
		I2CTransmitWord(0x45, 0x9606, false);

	for(i=0;i<(sizeof(waVideoEncoder2)/sizeof(WORD));i++) {
		I2CTransmitWord(0x45, waVideoEncoder2[i], false);
	}

		i= I2CTransmitByteGetReturn(0x45, 0x6c);
	//	bprintf(" vidrx(Enc ads 6c normally 46)=%02X\n",i);
		I2CTransmitWord(0x45, 0x6cc6, false);
		I2CTransmitWord(0x45, 0xba24, false);
		I2CTransmitWord(0x45, 0x60c8, false);
		I2CTransmitWord(0x45, 0x6200, false);
		I2CTransmitWord(0x45, 0x6400, false);

		i= I2CTransmitByteGetReturn(0x45, 0x06);
//		bprintf(" vidrx(Enc ads 06 normally 00)=%02X\n", i);

	return;
//This works in the STPC, worth a try.  However, you still need to put it into
//character mode:
#if 0
        // sequencer setup
        vgaout(XBV_SEQ_REG_INDEX,0x0, 3); // reg 0  turn off reset
        vgaout(XBV_SEQ_REG_INDEX,0x2, 0x0f); // reg 2 turn on all planes
        vgaout(XBV_SEQ_REG_INDEX,0x4, 6); // reg 4 256k mem and O/E addressing
        vgaout(XBV_GRA_REG_INDEX,0x06, 0); // reg 6  turn on char mode, addr map  = A000

/*
//And then, the CRTC needs to be setup or you won't get any sync output.  I am
//still working on that.  Haven't tested this.

        // CRTC setup
#define HORIZ_TOTAL 100
#define HORIZ_DISPLAY_END 80
#define HORIZ_START_BLANKING 80
#define HORIZ_END_BLANKING  100
#define HORIZ_START_RETRACE  85
#define HORIZ_END_RETRACE 95
#define VERT_TOTAL 800
#define VERT_DISPLAY_END 640
#define VERT_START_BLANKING 640
#define VERT_END_BLANKING 800
	  // Horizontal sync
        outb(0x3b4,0);  // reg 0 offset
        outb(0x3b5,HORIZ_TOTAL-5); // Horiz Total less 5 put in this reg

        outb(0x3b4,1);  // reg 1 offset
        outb(0x3b5,HORIZ_DISPLAY_END-1); // Horiz display end STPC: less 1

        outb(0x3b4,2);  // reg 2 offset
        outb(0x3b5,HORIZ_START_BLANKING); // Start Horizontal Blanking

        outb(0x3b4,3);  // reg 3 offset
        outb(0x3b5,0x80 | (HORIZ_END_BLANKING  & 0x1F) ); // End Horiz Blanking

        outb(0x3b4,4);  // reg 4 offset
        outb(0x3b5,HORIZ_START_RETRACE); // Start Horiz pulse

        outb(0x3b4,5);  // reg 5 offset
        outb(0x3b5,((HORIZ_END_BLANKING & 0x20) << 2) | (HORIZ_END_RETRACE & 0x1f)); // End Horiz pulse

	 // vertical sync
*/

		{  // spam some visible junk on to the video buffer... one day we will see this
			int n=0;
			BYTE * pb=(BYTE *)0xf0000000;
			for( n=0;n<10000;n++) { pb[n]=0xaa; }
		}
#endif

}


