/*
 * Sequences the necessary post-reset actions from as soon as we are able to run C
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boot.h"

/*
Hints:

1) We are in a funny environment, executing out of ROM.  That means it is not possible to
 define filescope non-const variables with an initializer.  If you do so, the linker will oblige and you will end up with
 a 4MByte image instead of a 1MByte one, the linker has added the RAM init at 400000.
*/


// CPU global cache enable/disable

void BootCpuCache(bool fEnable) {
	DWORD dwOr=0x040000000, dwAnd=0xffffffff;
	if(fEnable) { dwOr=0; dwAnd = ~0x040000000; }
	__asm__ (
        "pushf ;"
        "push %%eax ;"
        "cli    ;"
        "mov     %%cr0, %%eax ;"
        "or      %%ebx, %%eax ;"
        "and      %%ecx, %%eax ;"
        "mov     %%eax, %%cr0 ;"
        "wbinvd ;"
			"pop %%eax ;"
			"popf"
		: : "ebx" (dwOr), "ecx" (dwAnd)
	);
}


//
// ----------------------------  ACTUAL RESET CODE -----------------------------------------------------------
//  Gains control after minimal setup from X-Codes and x86
//

extern void BootResetAction ( void ) {
	int n;
	int i;

#if INCLUDE_FILTROR
		// clear down channel quality stats
	bfcqs.m_dwBlocksFromPc=0;
	bfcqs.m_dwCountChecksumErrorsSeenFromPc=0;
	bfcqs.m_dwBlocksToPc=0;
	bfcqs.m_dwCountTimeoutErrorsSeenToPc=0;
#endif

	__asm__ (  "cli" );

	 	BootPerformXCodeActions();
		
			// display solid red frontpanel LED while we start up
		I2cSetFrontpanelLed(I2C_LED_RED0 | I2C_LED_RED1 | I2C_LED_RED2 | I2C_LED_RED3);

#if INCLUDE_FILTROR
		BootFiltrorSendArrayToPc("BOOT: starting BootResetAction()\n", 33);
#endif

			// if we don't make the PIC happy within 200mS, the damn thing will reset us
		BootPerformPicChallengeResponseAction();
		bprintf("BOOT: PIC done\n");

			// initialize the PCI devices
		BootPciPeripheralInitialization();
		bprintf("BOOT: PCI done\n");

			// try to bring up VGA - does not work yet
		BootVgaInitialization();
		bprintf("BOOT: BootVgaInitialization done\n");

			// we are working on this!!! at the moment it returns after some delay
		//BootLinux();

		/*  Dump I2c EEPROM contents if you're interested
		for (i=0; i<256; i++) {
			bprintf("%02x ", I2CTransmitByteGetReturn(0x54, i));
		}
	*/

		// set the fontpanel LEDs to a stable state
		// note the PIC will flash the LEDs itself if there is no AV cable connected

	I2cSetFrontpanelLed(I2C_LED_GREEN0 | I2C_LED_GREEN1 | I2C_LED_GREEN2 | I2C_LED_GREEN3);

		// jump into Debug Shell - the q command can make it return

#if INCLUDE_FILTROR
		BootFiltrorDebugShell();
#endif
			// spin without filtror or if we quit the debug shell

		while(1) { bprintf("Actually there is no code here yet\n"); }
	}


