/************************************************************/
/* BIOS Linux boot                                      /
/*  Michael Steil                                            /
/*  kernel image (vmlinuz) must be at 32 KB in ROM:          /
/*  lmilk -d image.bin -b vmlinuz -a 8000                    /
/************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "boot.h"

const unsigned long long
real_mode_gdt_entries [] = {
        0x0000000000000000ULL,  /* 00h: Null descriptor */
	0x0000000000000000ULL,  /* 08h: Unused... */
	0x00cf9a000000ffffULL,	/* 10h: 32-bit 4GB code at 0x00000000 */
	0x00cf92000000ffffULL,	/* 18h: 32-bit 4GB data at 0x00000000 */
        0x00009a000000ffffULL,  /* 20h: 16-bit 64k code at 0x00000000 */
        0x000092000000ffffULL	/* 28h: 16-bit 64k data at 0x00000000 */
};


struct gdt_t {
        unsigned short       size __attribute__ ((packed));
        unsigned long long * base __attribute__ ((packed));
};

const struct gdt_t real_mode_gdt = { sizeof (real_mode_gdt_entries)-1, (unsigned long long  * )real_mode_gdt_entries };
const struct gdt_t real_mode_idt = { 0x3ff, 0 };


void memcpy(void *dest, void *src,  int size) {
    bprintf("memcpy(0x%x,0x%x,0x%x);\n", dest, src, size);
    __asm__  (
              "    push %%esi    \n"
              "    push %%edi    \n"
              "    push %%ecx    \n"
              "    mov %0, %%esi \n"
              "    mov %1, %%edi \n"
              "    mov %2, %%ecx \n"
              "    shr $2, %%ecx \n"
              "    rep movsl     \n" /* using rep movsl is very important, because everything else would be *SLOW* */
              "    pop %%ecx     \n"
              "    pop %%edi     \n"
              "    pop %%esi     \n"
              : : "S" (src), "D" (dest), "c" (size)
		);
}

struct kernel_setup_t {
    char __pad1[32];
    unsigned short cmd_magic;	/*  32: Command line magic 0xA33F */
    unsigned short cmd_offset;	/*  34: Command line offset from 0x90000 */
    char __pad2[461];
    unsigned char  setup_sects; /* 497: setup size in sectors (512) */
    unsigned short root_flags;	/* 498: 1 = ro ; 0 = rw */
    unsigned short kernel_para;	/* 500: kernel size in paragraphs (16) */
    unsigned short swap_dev;	/* 502: */
    unsigned short ram_size;	/* 504: */
    unsigned short vid_mode;	/* 506: */
    unsigned short root_dev;	/* 508: */
    unsigned short boot_flag;	/* 510: signature*/
    unsigned short jump;        /* 512: jump to startup code */
    char signature[4];          /* 514: "HdrS" */
    unsigned short version;     /* 518: header version */
    unsigned short x,y,z;       /* 520: LOADLIN hacks */
    unsigned short ver_offset;  /* 526: kernel version string */
    unsigned char loader;       /* 528: loader type */
    unsigned char flags;        /* 529: loader flags */
    unsigned short a;           /* 530: more LOADLIN hacks */
    unsigned long start;        /* 532: kernel start, filled in by loader */
    unsigned long ramdisk;      /* 536: RAM disk start address */
    unsigned long ramdisk_size; /* 540: RAM disk size */
    unsigned short b,c;         /* 544: bzImage hacks */
    unsigned short heap_end_ptr;/* 548: end of free area after setup code */
};

void BootLinux() {
#define KERNEL_IMAGE   0xFF008000
#define KERNEL_SIZE    (800*1024)
#define PM_KERNEL_DEST 0x100000
#define KERNEL_SETUP   0x90000

    unsigned char* vmlinuz = (unsigned char*) KERNEL_IMAGE;
    unsigned char* pm_kernel;
    unsigned char* version_string;
    struct kernel_setup_t *kernel_setup = (struct kernel_setup_t *)KERNEL_SETUP;

    bprintf("\nBooting Linux...\n");

    version_string = vmlinuz + 512 + (((DWORD)vmlinuz[0x20e]) | (((DWORD)vmlinuz[0x20f]) <<8));
    pm_kernel = vmlinuz + (vmlinuz[0x1F1]+1) * 512;

		bprintf("Kernel ID: %s\n", (const char *)version_string);
    bprintf("Start of kernel:              0x%x\n", vmlinuz);
    bprintf("Start of protected mode part: 0x%x\n", pm_kernel);
    bprintf("Copying kernel into RAM...\n");

		memcpy((void*)PM_KERNEL_DEST, pm_kernel, KERNEL_SIZE);		/* the actual protected mode kernel data */
  	memcpy((void*)kernel_setup, vmlinuz, pm_kernel - vmlinuz);	/* kernel boot data */

//		I2cSetFrontpanelLed(0xff);
		bprintf("done.");

    kernel_setup->loader = 0xFF;		/* must be != 0 */
    /* probably a lot more has to be done here */


//    __asm (
//    "lidt  %0             \n"
//    "lgdt  %1             \n"
//    "mov  $0x18, %%ax     \n" /* 32-bit, 4GB data from GDT */
//    "mov  %%ax, %%ds      \n"
//    "mov  %%ax, %%es      \n"
//    "xor %%bx, %%bx       \n"
//    "ljmp $0x10, $0x100000 \n" : :
//    "m" (real_mode_idt), "m" (real_mode_gdt));


    bprintf("\n");
}
