;;; 
;;; Compile this with NASM.
;;;
;;; BFM patch for EvoX M8 bios 2bl. Compile and paste this at offset 0x1cc
;;; into the 2bl (or 0x3d1cc into the 256k bios image).
;;;


BITS 32
ORG 0x4001cc

	cli
	cld
	mov	edx,ecx
	mov	edi,0x8000f000
	mov	ecx,0x40
	mov	eax,0xe3
pmempagesl:
	mov	[edi+0x800],eax
	stosd
	add	eax,0x400000
	loop	pmempagesl

	mov	ecx,0x1c0
	xor	eax,eax
nmpagesl:	
	mov	[edi+0x800],eax
	stosd
	loop	nmpagesl

	mov	edi,0x8000f000
	mov	eax,0xf063
	mov	[edi+0xc00],eax
	sub	eax,0x1000
	mov	[edi+0xff0],eax
	mov	[edi+0xff4],eax
	mov	[edi+0xff8],eax
	mov	[edi+0xffc],eax

	sub	edi,0x1000
	mov	ebp,4
maprommirl:
	lea	eax,[edx+0x63]
	mov	ecx,0x100
maproml:stosd
	add	eax,0x1000
	loop	maproml
	dec	ebp
	jnz	maprommirl

	mov	eax,0xf000
	mov	cr3,eax
	lgdt	[0x4001c0]
	jmp	0x8:dtcj
dtcj:	
	mov	eax,0x10
	mov	ds,ax
	mov	es,ax
	mov	ss,ax
	mov	esp,0x80400000
	xor	eax,eax
	mov	fs,ax
	mov	gs,ax

	add	edx,0x80100000
	mov	[shadowromtop],edx

	mov	eax,unpackandrun
	call	eax
.inf:	jmp short .inf


align 4
shadowromtop	dd 0


unpackandrun:
	and	dword [0x80402e51],byte 0

	call	0x40071f

	mov	eax,[shadowromtop]
	add	[0x80010030],eax
	jmp	0x4005c1
