
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <XBApp.h>
#include <XBFont.h>
#include <XBMesh.h>
#include <XBResource.h>
#include <XBHelp.h>
#include <XBUtil.h>

#include "debug.h"
#include "flash.h"
#include "fileselector.h"
#include "xflash.h"

//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXport xbApp;
    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}

CXport::CXport()
            :CXBApplication()
{
}



HRESULT CXport::Initialize()
{
	// Minum work before any activity
	mpDebug = new CXBoxDebug(20.0,20.0);

	mFont.Create(m_pd3dDevice, "font.xpr");

	// Pretty Blue background
	RenderGradientBackground(0xff404040, 0xff4040C0);
	m_pd3dDevice->Present(NULL,NULL,NULL,NULL);

	mpFlash = new CXBoxFlash(mpDebug);

	StartUpMessage();

	// Create Fileselector
	RECT filerect={55,90,584,386};
	mpFileSelector = new CXBoxFileSelector(NULL,NULL,mFont);
	mpFileSelector->SetDirectory("d:\\flash\\*");
	mpFileSelector->SetDisplayRect(filerect);

	mCounter=0;
	mFileName[0]='\0';

	return S_OK;
}


void CXport::StartUpMessage(void)
{
	// Startup messages
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"Welcome to XFlash");
	mpDebug->Message(L"Build 001");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING WARNING WARNING WARNING WARNING WARNING");
	mpDebug->Message(L"WARNING WARNING WARNING WARNING WARNING WARNING");
	mpDebug->Message(L"WARNING WARNING WARNING WARNING WARNING WARNING");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING - This program is designed to overwrite your Flash BIOS");
	mpDebug->Message(L"WARNING - If you dont wish to do this then switch OFF NOW !!!");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING - For this procedure to work then RD/OE and WR/WE jumpers");
	mpDebug->Message(L"WARNING - on the motherboard must be linked. You must also be able");
	mpDebug->Message(L"WARNING - to switch back in your original Xbox BIOS.");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING - If your modchip does not have the OE signal wired up to");
	mpDebug->Message(L"WARNING - disable outputs the your Xbox may be damaged during the");
	mpDebug->Message(L"WARNING - attempt to write the flash.");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING - If you dont understand any of this then SWITCH OFF NOW!");
	mpDebug->Message(L"");
	mpDebug->MessageInstant(L"Press <START> open file selector.");
	mpDebug->MessageInstant(L"Press <BACK> to dump flash.");
}


HRESULT CXport::FrameMove()
{
	static DWORD loop=0;
	switch(mCounter)
	{
		case 0:
			if((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START))
			{
				mCounter++;
			}
			else if((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_BACK))
			{
				mCounter=10;
			}
			break;
		case 1:
			mpFileSelector->ProcessFileSelect(m_DefaultGamepad);
			if((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START))
			{
				strcpy(mFileName,"d:\\flash\\");
				strcat(mFileName,mpFileSelector->GetSelected());
				mpDebug->Message(L"");
				mpDebug->Message(L"You have selected: %hs",mFileName);
				mpDebug->Message(L"");
				mpDebug->Message(L"Last chance to abort. Flash Erase will begin after you press <START>");
				mpDebug->Message(L"(Make sure you have the Flash BIOS switched in before pressing start)");
				mCounter++;
			}
			break;
		case 2:
			if((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START))
			{
				mpDebug->MessageInstant(L"Checking Flash ID");
				if(!mpFlash->CheckID())
				{
					mpDebug->MessageInstant(L"Flash ID Check Failed, are you sure you have flash enabled ?");
					mpDebug->MessageInstant(L"Press <START> to begin again!!");
					mCounter=0;
				}
				else
				{
					mpDebug->MessageInstant(L"Started ERASE Cycle, takes 8-30 Seconds");
					if(!mpFlash->EraseDevice())
					{
						mpDebug->MessageInstant(L"Erase Failed!!");
						mpDebug->MessageInstant(L"Press <START> to begin again!!");
						mCounter=0;
					}
					else
					{
						mCounter++;
					}
				}
			}
			break;
		case 3:
			mpDebug->MessageInstant(L"Starting Programming");
			if(!mpFlash->ProgramDevice(mFileName))
			{
				mpDebug->MessageInstant(L"Programming Failed!!");
			}
			mpDebug->MessageInstant(L"Finsished, press <START> to begin again!!");
			mCounter=0;
			break;

		case 10:
			mpDebug->MessageInstant(L"Dumping Flash to X:");
			{
				FILE *fp;
				BYTE data;
				DWORD addr=FLASH_BASE_ADDRESS;
				if((fp=fopen("u:\\bios.bin","wb"))!=NULL)
				{
					for(loop=0;loop<0x100000;loop++)
					{
						data=mpFlash->Read(addr++);
						fwrite(&data,1,sizeof(BYTE),fp);
						if((addr&0xffff)==0) mpDebug->MessageInstant(L"Dumped block %d",(addr>>16)&0x1f);
					}
					fclose(fp);
				}
				mpDebug->MessageInstant(L"Sucessful Dump, press START/BACK to continue.");
			}
			mCounter=0;
		default:
			break;
	}
	return S_OK;
}

HRESULT CXport::Render()
{
	RenderGradientBackground(0xff404040, 0xff4040C0);
	if(mCounter==1)
	{
		mpFileSelector->RenderFileSelect();
	}
	else
	{
		mpDebug->Display();
	}
	m_pd3dDevice->Present(NULL,NULL,NULL,NULL);
	return S_OK;
}

HRESULT CXport::Cleanup()
{
	return S_OK;
}

