#!/bin/bash
#
# sample flash.sh bourne shell script by modrobert
# 
# variables that might come in handy:
#
# $CDROMDIR	;cdrom directory
# $EURTMPDIR	;temp directory on xbox hdd E:
# $FLASHED	;leave this script with FLASHED=1 to end flashing procedure, 
#		;FLASHED=0 to load another bios disc
# $CDROMDEV	;current device for the cdrom
# $HDDEV	;current device for the hdd
#
# commands available (* linked from busybox):
#
# bash
# busybox
# *cat
# *chmod
# *cp
# *dmesg
# dos2unix
# eject.xbox.real	;use -t option to close tray
# *find
# halt			;halt -n -f -p for powerdown
# insmod
# *ls
# *mkdir
# modprobe
# *mount
# raincoat
# *sleep
# *syslogd
# test
# *umount


# lets copy bios file from cdrom (not icluded on sample bios disc)
cp $CDROMDIR/bios.bin $EURTMPDIR

# uncomment below to copy your own cool raincoat binary with 500 flash types ;)

# cp $CDROMDIR/raincoat $EURTMPDIR
# chmod 777 $EURTMPDIR/raincoat

# do this forever
while : 
do
	echo
	echo "     Commencing BIOS flash loop (sweatshops, beware!)..."
	echo
	# uncomment below to flash for real using eurasia custom raincoat
	# /bin/raincoat -p $EURTMPDIR/bios.bin -v
	# uncomment below to flash for real using your raincoat from bios disc
	# $EURTMPDIR/raincoat -p $EURTMPDIR/bios.bin -v
	FLASHRTN=$?
	if test $FLASHRTN -eq 0
        then
		echo
		echo "     Ok, Mount the next flash or something..."
		echo
	else
		echo
		echo "     There was an error during flash!"
		echo "     Check raincoat output above for details."
		echo
	fi

	# wait 10 sec before we try again
	sleep 10
done
