/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 /* 2003-01-07  andy@warmcat.com  Created
 */

#include "boot.h"
#include "BootFlash.h"

const KNOWN_FLASH_TYPE aknownflashtypesDefault[] = {
	{ 0xbf, 0x61, "SST49LF020", 0x40000 },  // default flash types
	{ 0x01, 0xd5, "Am29F080B", 0x100000 },  // default flash types
	{ 0x04, 0xd5, "Fujitsu MBM29F080A", 0x100000 },  // default flash types
	{ 0xad, 0xd5, "Hynix HY29F080", 0x100000 },  // default flash types
	{ 0x20, 0xf1, "ST M29F080A", 0x100000 },  // default flash types
	{ 0x89, 0xA6, "Sharp LHF08CH1", 0x100000 }, // default flash types
	{ 0xbf, 0x50, "256 bank 1", 0x100000 },
	{ 0xbf, 0x51, "256 bank 2", 0x100000 },
	{ 0xbf, 0x52, "256 bank 3", 0x100000 },
	{ 0xbf, 0x53, "256 bank 4", 0x100000 },

	{ 0xda, 0x8c, "Winbond W49F020",0x40000 },
	{ 0x01, 0xa4, "AMD - Am29F040B",0x80000 },
	{ 0xda, 0x0b, "Winbond - W49F002U",0x40000 },
	{ 0xc2, 0x36, "MACRONIX - MX29F022NTPC",0x40000 },
	{ 0x20, 0xb0, "ST M29f002BT",0x40000 },

	{ 0, 0, "\0", 0 }
};


 // callback to show progress

void draw_box(int val, int max, unsigned long col);
void draw_box(int val, int max, unsigned long col){
        int x,y,l,w,h,m;
        DWORD *fb=(DWORD*)FRAMEBUFFER_START;

        if(max<2){
                return;
        }

        w=currentvideomodedetails.m_dwWidthInPixels;
        h=currentvideomodedetails.m_dwHeightInLines;
        l=w-50;
        y=h-100;
        m=((w-100)>>2)*val/max;
        m*=4;
        m+=50;
        for(x=50;x<l;x++){
                fb[y*w+x]=0xffffffff;
                fb[(y+1)*w+x]=0xffffffff;
                if(x>55 && x<m){
                        int z;
                        for(z=5;z<45;z++){
                                fb[(y+z)*w+x]=col;
                        }

                }
                fb[(y+50)*w+x]=0xffffffff;
                fb[(y+51)*w+x]=0xffffffff;
        }
        for(;y<h-50;y++){
                fb[y*w+51]=0xffffffff;
                fb[y*w+50]=0xffffffff;
                fb[y*w+l-1]=0xffffffff;
                fb[y*w+l-2]=0xffffffff;
        }



}

bool BootFlashUserInterface(void * pvoidObjectFlash, ENUM_EVENTS ee, DWORD dwPos, DWORD dwExtent) {
	if(ee==EE_ERASE_UPDATE){
		draw_box(dwPos,dwExtent,0xffffff00);
	}
	if(ee==EE_PROGRAM_UPDATE){
		draw_box(dwPos,dwExtent,0xff00ff00);
	}
	return true;
}

int BootReflashAndReset(BYTE *pbNewData, DWORD dwStartOffset, DWORD dwLength)
{
	OBJECT_FLASH of;
	bool fMore=true;

	// prep our flash object with start address and params
	of.m_pbMemoryMappedStartAddress=(BYTE *)LPCFlashadress;
	of.m_dwStartOffset=dwStartOffset;
	of.m_dwLengthUsedArea=dwLength;
	of.m_pcallbackFlash=BootFlashUserInterface;


	if(!BootFlashGetDescriptor(&of, (KNOWN_FLASH_TYPE *)&aknownflashtypesDefault[0])) {
		printk("Unknown flash! Halting\n");
		while(1);
	}

	VIDEO_ATTR=0xffc8c8c8;
	printk("Found Flash: ");
	VIDEO_ATTR=0xffc8c800;

	printk("%s (%02x %02x)\n",of.m_szFlashDescription,
	       of.m_bManufacturerId,of.m_bDeviceId);
	
	if(!of.m_fIsBelievedCapableOfWriteAndErase){
		printk("Flash writeprotected? Halting\n");
		while(1);
	}
	if(of.m_dwLengthInBytes<(dwStartOffset+dwLength)){
		printk("Flash to small for biosimage. Halting\n");
		while(1);
	}

	__asm__ __volatile__ ( "cli ");  // ISRs are in flash, no interrupts possible now until reset

	while(fMore) {
		printk("\n\n");
		printk("\2FLASH UPDATE IN PROGRESS...\n");
		printk("\2\n");
		VIDEO_ATTR=0xffc8c8c8;
		printk("WARNING - PLEASE DO NOT TOUCH THE CONSOLE WHILST FLASHING IS IN PROGRESS!\n"
		       "YOUR CONSOLE SHOULD SHUTDOWN AUTOMATICALLY WHEN FLASHING IS COMPLETED.\n"
		       "IF YOUR CONSOLE DOES NOT TURN OFF PLEASE DO SO MANUALLY WHEN THE POWER\n"
		       "LED TURNS AMBER.\n");

		if(BootFlashEraseMinimalRegion(&of)) {
			if(BootFlashProgram(&of, pbNewData)) {
				fMore=false;  // good situation
			} else { // failed program
				printk("Programming failed: %s\n",of.m_szAdditionalErrorInfo);
				while(1);
			}
		} else { // failed erase
			printk("Erase failed\n");
			while(1);
		}
	}

	// okay, try to restart by cycling power


#define XBOX_SMB_IO_BASE 0xC000
#define XBOX_SMB_HOST_ADDRESS       (0x4 + XBOX_SMB_IO_BASE)
#define XBOX_SMB_HOST_COMMAND       (0x8 + XBOX_SMB_IO_BASE)
#define XBOX_SMB_HOST_DATA          (0x6 + XBOX_SMB_IO_BASE)
#define XBOX_SMB_GLOBAL_ENABLE      (0x2 + XBOX_SMB_IO_BASE)

#define XBOX_PIC_ADDRESS 0x10

#define SMC_CMD_POWER 0x02
#define SMC_SUBCMD_POWER_OFF 0x80

	/* poweroff */

        IoOutputWord(XBOX_SMB_HOST_ADDRESS, ((XBOX_PIC_ADDRESS) << 1));
        IoOutputByte(XBOX_SMB_HOST_COMMAND, SMC_CMD_POWER);
        IoOutputWord(XBOX_SMB_HOST_DATA, SMC_SUBCMD_POWER_OFF);
        IoOutputWord(XBOX_SMB_IO_BASE, IoInputWord(XBOX_SMB_IO_BASE));
        IoOutputByte(XBOX_SMB_GLOBAL_ENABLE, 0x0a);

	while(1);

	return 0; // keep compiler happy
}
