
#include "boot.h"
#include "memory_layout.h"
#include "BootFATX.h"
#include "BootIde.h"

#define XBOX_SMB_IO_BASE 0xC000
#define XBOX_SMB_HOST_ADDRESS       (0x4 + XBOX_SMB_IO_BASE)
#define XBOX_SMB_HOST_COMMAND       (0x8 + XBOX_SMB_IO_BASE)
#define XBOX_SMB_HOST_DATA          (0x6 + XBOX_SMB_IO_BASE)
#define XBOX_SMB_GLOBAL_ENABLE      (0x2 + XBOX_SMB_IO_BASE)

#define XBOX_PIC_ADDRESS 0x10

#define SMC_CMD_POWER 0x02
#define SMC_SUBCMD_POWER_OFF 0x80

#define SMC_SUBCMD_POWER_RESET 0x01

static char *banks[8]={
	"Bank 0",
	"Bank 1",
	"Bank 2",
	"Bank 3",
	"Bank 4",
	"Bank 5",
	"Bank 6",
	"Bank 7",
};

static char *main_menu[]={
	"Enable Network Flashing",
	"Load BIOS from HDD (C:\\Bios)",
	"Load BIOS from Disc",
	"Unlock HDD",
	"Lock HDD",
	"Flash EEPROM v1.0 (Danger!  Do not use!)",
	"Flash EEPROM v1.1 (Danger!  Do not use!)",
	"Flash EEPROM v1.2 / v1.3 (Danger!  Do not use!)",
	"Flash EEPROM v1.4 / v1.5 (Danger!  Do not use!)",
	"Flash EEPROM v1.6 (Danger!  Do not use!)",
};

int NiceMenu(char **alts, int nAlts);
void HddFlash(void);
void UnlockHDD(void);
void LockHDD(void);
int CDFlash(void);
void FlashEEPROM10(void);
void FlashEEPROM11(void);
void FlashEEPROM12(void);
void FlashEEPROM14(void);
void FlashEEPROM16(void);

int FATXListDir(FATXPartition *partition, int clusterId, char **res, int reslen, char *prefix);
int FATXFindDir(FATXPartition *partition, int clusterId, char *dir);
extern void etherboot(void);

void FlashBIOS(void){
	int n;

	while (1) {
		n = NiceMenu (main_menu, 10);

		switch (n) {
		case 0:
			etherboot();
			break;
		case 1:
			HddFlash();
			break;
		case 2:
			CDFlash();
			break;
		case 3:
			UnlockHDD();
			break;
		case 4:
			LockHDD();
			break;
		case 5:
			FlashEEPROM10();
			break;
		case 6:
			FlashEEPROM11();
			break;
		case 7:
			FlashEEPROM12();
			break;
		case 8:
			FlashEEPROM14();
			break;
		case 9:
			FlashEEPROM16();
			break;
		}
	}
}

int LockUnlockHDD(int nIndexDrive, int command){
	BYTE baMagic[0x200], baKeyFromEEPROM[0x10], baEeprom[0x30];
	int nVersionHashing;
	unsigned uIoBase;
	DWORD BootHddKeyGenerateEepromKeyData(BYTE *eeprom_data,BYTE *HDKey);
				
	int nVersionSuccessfulDecrypt=0;

	nVersionHashing = 0;

	uIoBase = tsaHarddiskInfo[nIndexDrive].m_fwPortBase;
	
	// first 0x30 bytes from EEPROM image we picked up earlier
	memcpy(&baEeprom[0], &eeprom, 0x30);

	memset(&baKeyFromEEPROM,0x00,0x10);
	nVersionHashing = BootHddKeyGenerateEepromKeyData( &baEeprom[0], &baKeyFromEEPROM[0]);

	memset(&baMagic,0x00,0x200);

	// Calculate the hdd pw from EEprom and Serial / Model Number
	HMAC_SHA1 (&baMagic[2], baKeyFromEEPROM, 0x10,
			   tsaHarddiskInfo[nIndexDrive].m_szIdentityModelNumber,
			   tsaHarddiskInfo[nIndexDrive].m_length,
			   tsaHarddiskInfo[nIndexDrive].m_szSerial,
			   tsaHarddiskInfo[nIndexDrive].s_length);
	
	if (nVersionHashing == 0) {
		printk("Unable to generate password from EEPROM - corrupt?\n");
		return 0;
	}

	{ int i;
	VIDEO_ATTR=0xffc8c8c8;
	printk ("Key: ");
	VIDEO_ATTR=0xffc8c800;
	for (i = 0; i < 20; i++) {
		printk("%x", baMagic[i+2] & 0xff);
	}
	printk("\n");
	}
	
	return DriveSecurityChange(uIoBase, nIndexDrive, command, &baMagic[2]);
}

void UnlockHDD(void){
	printk("\n");
	printk ("Unlocking HDD...\n");
	LockUnlockHDD(0,IDE_CMD_SECURITY_DISABLE);

	// reset
  IoOutputWord(XBOX_SMB_HOST_ADDRESS, ((XBOX_PIC_ADDRESS) << 1));
  IoOutputByte(XBOX_SMB_HOST_COMMAND, SMC_CMD_POWER);
  IoOutputWord(XBOX_SMB_HOST_DATA, SMC_SUBCMD_POWER_RESET);
  IoOutputWord(XBOX_SMB_IO_BASE, IoInputWord(XBOX_SMB_IO_BASE));
  IoOutputByte(XBOX_SMB_GLOBAL_ENABLE, 0x0a);

	while (1)
		;
}
void LockHDD(void){
	printk("\n");
	printk ("Locking HDD...\n");
	LockUnlockHDD(0,IDE_CMD_SECURITY_SET_PASSWORD);
	
	/* reset */

  IoOutputWord(XBOX_SMB_HOST_ADDRESS, ((XBOX_PIC_ADDRESS) << 1));
  IoOutputByte(XBOX_SMB_HOST_COMMAND, SMC_CMD_POWER);
  IoOutputWord(XBOX_SMB_HOST_DATA, SMC_SUBCMD_POWER_RESET);
  IoOutputWord(XBOX_SMB_IO_BASE, IoInputWord(XBOX_SMB_IO_BASE));
  IoOutputByte(XBOX_SMB_GLOBAL_ENABLE, 0x0a);
        
	while (1)
		;
}

void HddFlash(){
	FATXPartition *partition;
	int bioscluster;
	int offset;
	char *alts[258];
	int n = 1;
	
	partition = OpenFATXPartition(0,SECTOR_SYSTEM,SYSTEM_SIZE);

	alts[0] = "Back to menu";

	// Messy, but fun!
	bioscluster = FATXFindDir(partition, FATX_ROOT_FAT_CLUSTER, "bios");
	if (bioscluster == -1 || bioscluster == 1) {
		bioscluster = FATXFindDir(partition, FATX_ROOT_FAT_CLUSTER, "Bios");
		if (bioscluster == -1 || bioscluster == 1) {
			bioscluster = FATXFindDir(partition, FATX_ROOT_FAT_CLUSTER, "BIOS");
			if (bioscluster == -1 || bioscluster == 1) {
				printk("No C:\\Bios found...\n");
				while(1);
			} else {
				n = FATXListDir(partition, bioscluster, &alts[1], 256, "C:\\BIOS\\");
			}
		} else {
			n = FATXListDir(partition, bioscluster, &alts[1], 256, "C:\\Bios\\");
		}
	} else {
		n = FATXListDir(partition, bioscluster, &alts[1], 256, "C:\\bios\\");
	}

	n = NiceMenu (alts, n+1);

	if (n > 0) {
		int res;
		FATXFILEINFO fileinfo;
		res = LoadFATXFilefixed(partition, alts[n]+2, &fileinfo, (BYTE*)0x100000);
		if (!res) {
			printk("Loading failed :(   Halting\n");
			while(1)
				;
		}
		printk("\n");
		printk ("Bios '%s', %dkbytes\n", alts[n]+2, fileinfo.fileSize >> 10);

		offset = 0;
#ifdef BANK_SEL
		switch (fileinfo.fileSize) {
		case 1024*1024:
			offset = 1024 * 1024 * NiceMenu(banks, 2);
			break;
		case 512*1024:
			offset = 512 * 1024 * NiceMenu(banks, 4);
			break;
		case 256*1024:
			offset = 256 * 1024 * NiceMenu(banks, 8);
			break;
		default:
			printk("BIOS must have size 256k, 512k or 1024k\n");
			while (1)
				;
		}
#endif
		res = BootReflashAndReset((BYTE*)0x100000,offset,fileinfo.fileSize);
		printk("flash failed: %d\n",res);
	}

	CloseFATXPartition(partition);

}

extern void ClearScreen (void);

int CDFlash(void){

	DWORD dwConfigSize=0;
	BYTE ba[2048];
	BYTE bCount=0, bCount1;
	unsigned int n;
	ISO_PRIMARY_VOLUME_DESCRIPTOR * pipvd;
	char sz[64];
	
	DWORD dwY=VIDEO_CURSOR_POSY;
	DWORD dwX=VIDEO_CURSOR_POSX;

	I2CTransmitWord(0x10, 0x0c00); // eject DVD tray
	wait_ms(2000); // Wait for DVD to become responsive to inject command
                        	
selectinsert:
	printk("\n\n");
	ClearScreen ();

	while(DVD_TRAY_STATE != DVD_CLOSING) {
	
		VIDEO_CURSOR_POSX=dwX;	
		VIDEO_CURSOR_POSY=dwY;
			
		bCount++;
		bCount1=bCount; if(bCount1&0x80) { bCount1=(-bCount1)-1; }
			VIDEO_ATTR=0xff000000|(((bCount1>>1)+64)<<16)|(((bCount1>>1)+64)<<8)|0 ;
		printk("\2Please insert CD - Flashing Mode\n\2");
		
		for (n=0;n<1000000;n++) {;}
	}


	VIDEO_ATTR=0xffffffff;
	printk("\n\n");
	ClearScreen ();

	// wait until the media is readable

	{
		bool fMore=true, fOkay=true;
		int timeoutcount = 0;
		
		while(fMore) {
			timeoutcount++;
			// We waited very long now for a Good read sector, but we did not get one, so we
			// jump back and try again
			if (timeoutcount>200) {
				I2CTransmitWord(0x10, 0x0c00); // eject DVD tray	
				wait_ms(2000); // Wait for DVD to become responsive to inject command
				goto selectinsert;
			}
			wait_ms(200);
			
			if(BootIdeReadSector(1, &ba[0], 0x10, 0, 2048)) { // starts at 16
				VIDEO_CURSOR_POSX=dwX;
				VIDEO_CURSOR_POSY=dwY;
				bCount++;
				bCount1=bCount; if(bCount1&0x80) { bCount1=(-bCount1)-1; }

				VIDEO_ATTR=0xff000000|(((bCount1)+64)<<16)|(((bCount1>>1)+128)<<8)|(((bCount1)+128)) ;

				printk("\2Waiting for drive\2\n");
	
			} else {  // read it successfully
				fMore=false;
				fOkay=true;
			}
		}

		if(!fOkay) {
			printk("cdrom unhappy\n");
			while(1);
		} else {
//			printk("\n");
		}
	}

	printk("\n\n");
	ClearScreen (); 
        
	{
		printk("\n");
	
		ISO_PRIMARY_VOLUME_DESCRIPTOR * pipvd = (ISO_PRIMARY_VOLUME_DESCRIPTOR *)&ba[0];
		char sz[64];
		memset(&sz,0x00,sizeof(sz));
		VIDEO_ATTR=0xffeeeeee;
		printk("CD-Rom Label: ");
		VIDEO_ATTR=0xffeeee00;
		BootIso9660DescriptorToString(pipvd->m_szVolumeIdentifier, sizeof(pipvd->m_szVolumeIdentifier), sz);
		printk("%s\n", sz);
	}
    
	{
		static const char * const filenames[]={"/BIOS.BIN","/LINUXBIO.BIN","/XECUTER.BIN","/LINUX.BIN","/CROMWELL.BIN","/BIOSUPD1.BIN",NULL};
		int len;
		int i=-1;
		do {
			i++;
			if(filenames[i]==NULL){
				printk("No Bios Update found... Halting!");
				while(1);
			}
			len=BootIso9660GetFile(1, filenames[i],
					       (BYTE *)0x100000,
					       0x100000, 0x0);
			
		} while (len<1024);
		
		
		VIDEO_ATTR=0xffc8c8c8;
		printk("Found BiosUpdate: ");
		VIDEO_ATTR=0xffc8c800;
		printk("%s (%dk)\n",filenames[i],len>>10);
		
		{
			int res = BootReflashAndReset((BYTE*)0x100000,0,len);
			printk("flash failed: %d\n",res);
		}
		
	}

	printk("   We are done flashing, didn't I reboot now?\n");

	return true;
}

void FlashEEPROM10(void){

	// Thanks to "bunnie" for his eeprom and his checkup with MS
	// verifying the legality of distributing it; and thanks to 
	// the person who wrote this code originally and released
	// it to the public.
	// http://arisme.free.fr/Xbox/Reflash/

        bool EEPROMprocessed=false;
        bool EEPROMchecked=false;

        int nAds=0, n;
        static const BYTE EEPROMimg[] = {
                0x47, 0x83, 0xa2, 0x7d, 0x6a, 0x69, 0x10, 0x8b, 0x2d, 0xb2, 0xe8, 0x90, 0xe1, 0x60, 0xde, 0xed,
                0x02, 0xc2, 0xaa, 0x79, 0x21, 0x47, 0xcd, 0xb0, 0xb7, 0xa8, 0x7a, 0x77, 0x44, 0x9c, 0x5e, 0x6e,
                0xd0, 0xf5, 0xf9, 0xe6, 0x94, 0x68, 0x39, 0xe0, 0xca, 0xa5, 0xd2, 0xe5, 0xfa, 0x02, 0xb9, 0xb7,
                0x9d, 0x19, 0xe6, 0xed, 0x36, 0x30, 0x35, 0x33, 0x37, 0x39, 0x35, 0x32, 0x31, 0x39, 0x30, 0x32,
                0x00, 0x50, 0xf2, 0x41, 0x9e, 0x5f, 0x00, 0x00, 0x2d, 0xaa, 0x6c, 0x23, 0x99, 0x80, 0x11, 0x47,
                0x33, 0xc3, 0xc7, 0x1a, 0x2b, 0xa5, 0x06, 0xb3, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x75, 0x61, 0x57, 0xfb, 0x2c, 0x01, 0x00, 0x00, 0x45, 0x53, 0x54, 0x00, 0x45, 0x44, 0x54, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x00, 0x02, 0x04, 0x01, 0x00, 0x02,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,
                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };
        if (memcmp(EEPROMimg, "EEPROMIMG", 9) != 0) {
                EEPROMprocessed=true;
                while(nAds<0x100) {
                        I2CTransmitWord( 0x54, (nAds<<8)|EEPROMimg[nAds]);
                        for(n=0;n<1000;n++) { IoInputByte(I2C_IO_BASE+0); }
                        nAds++;
                }
                // Recheck EEprom
                BootEepromReadEntireEEPROM();
                EEPROMchecked = (memcmp((void*)&eeprom, EEPROMimg, 0x100) == 0);
        }

        if (EEPROMprocessed) {
                printk("EEProm flashed - status : ");
                if (EEPROMchecked)
                        printk("SUCCESSFUL\n\n");
                else
                        printk("FAILED\n\n");
        }
        else
                printk("EEprom NOT flashed\n\n");

        printk("You should turn off your XBOX now...\n\n");
}

void FlashEEPROM11(void){

        bool EEPROMprocessed=false;
        bool EEPROMchecked=false;

        int nAds=0, n;
        static const BYTE EEPROMimg[] = {
                0xa1, 0xdb, 0x72, 0x43, 0x5c, 0x91, 0x5a, 0x76, 0xc5, 0xfb, 0xe7, 0xe5, 0x42, 0x25, 0x38, 0x51,
                0x02, 0x68, 0x24, 0xc5, 0x80, 0x58, 0x3f, 0x83, 0xa4, 0xb5, 0x14, 0x9e, 0xc7, 0xbb, 0x18, 0x3a,
                0xb3, 0x52, 0x39, 0x6d, 0xd7, 0xc4, 0x74, 0xb9, 0x03, 0x29, 0x3a, 0xa7, 0x8a, 0x09, 0x11, 0xeb,
                0xf8, 0x31, 0x33, 0x20, 0x34, 0x33, 0x31, 0x39, 0x31, 0x32, 0x31, 0x33, 0x32, 0x38, 0x30, 0x36,
                0x00, 0x0d, 0x3a, 0x00, 0x0f, 0x42, 0x00, 0x00, 0x93, 0x37, 0xb1, 0x05, 0x3a, 0xa6, 0x42, 0xa5,
                0x2c, 0xc8, 0x47, 0x0b, 0x67, 0x3a, 0x84, 0x86, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x75, 0x61, 0x57, 0xfb, 0x2c, 0x01, 0x00, 0x00, 0x45, 0x53, 0x54, 0x00, 0x45, 0x44, 0x54, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x00, 0x02, 0x04, 0x01, 0x00, 0x02,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,
                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };
        if (memcmp(EEPROMimg, "EEPROMIMG", 9) != 0) {
                EEPROMprocessed=true;
                while(nAds<0x100) {
                        I2CTransmitWord( 0x54, (nAds<<8)|EEPROMimg[nAds]);
                        for(n=0;n<1000;n++) { IoInputByte(I2C_IO_BASE+0); }
                        nAds++;
                }
                // Recheck EEprom
                BootEepromReadEntireEEPROM();
                EEPROMchecked = (memcmp((void*)&eeprom, EEPROMimg, 0x100) == 0);
        }

        if (EEPROMprocessed) {
                printk("EEProm flashed - status : ");
                if (EEPROMchecked)
                        printk("SUCCESSFUL\n\n");
                else
                        printk("FAILED\n\n");
        }
        else
                printk("EEprom NOT flashed\n\n");

        printk("You should turn off your XBOX now...\n\n");
}

void FlashEEPROM12(void){

        bool EEPROMprocessed=false;
        bool EEPROMchecked=false;

        int nAds=0, n;
        static const BYTE EEPROMimg[] = {
                0x8f, 0x1a, 0xbb, 0x35, 0x79, 0x0f, 0xfc, 0x16, 0xb8, 0xf2, 0x03, 0xbd, 0x0a, 0x26, 0xe4, 0x55,
                0x4f, 0x56, 0xec, 0x36, 0x7e, 0xf3, 0x4c, 0x9d, 0x92, 0x90, 0xb9, 0x8f, 0x42, 0x43, 0x05, 0x22,
                0xce, 0x47, 0xc7, 0xcb, 0x1b, 0x01, 0xd7, 0xfa, 0x36, 0x5a, 0x80, 0x1f, 0x42, 0xa6, 0xb4, 0xb4,
                0x11, 0x70, 0x31, 0x4d, 0x33, 0x34, 0x33, 0x30, 0x35, 0x39, 0x34, 0x33, 0x32, 0x39, 0x30, 0x36,
                0x00, 0x0d, 0x3a, 0x00, 0x59, 0x3e, 0x00, 0x00, 0x3c, 0xd5, 0xa7, 0x8a, 0xae, 0xfb, 0xc3, 0x00,
                0x4f, 0xeb, 0x6e, 0x2d, 0xc1, 0xe0, 0xe1, 0x5f, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x75, 0x61, 0x57, 0xfb, 0x2c, 0x01, 0x00, 0x00, 0x45, 0x53, 0x54, 0x00, 0x45, 0x44, 0x54, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x00, 0x02, 0x04, 0x01, 0x00, 0x02,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,
                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };
        if (memcmp(EEPROMimg, "EEPROMIMG", 9) != 0) {
                EEPROMprocessed=true;
                while(nAds<0x100) {
                        I2CTransmitWord( 0x54, (nAds<<8)|EEPROMimg[nAds]);
                        for(n=0;n<1000;n++) { IoInputByte(I2C_IO_BASE+0); }
                        nAds++;
                }
                // Recheck EEprom
                BootEepromReadEntireEEPROM();
                EEPROMchecked = (memcmp((void*)&eeprom, EEPROMimg, 0x100) == 0);
        }

        if (EEPROMprocessed) {
                printk("EEProm flashed - status : ");
                if (EEPROMchecked)
                        printk("SUCCESSFUL\n\n");
                else
                        printk("FAILED\n\n");
        }
        else
                printk("EEprom NOT flashed\n\n");

        printk("You should turn off your XBOX now...\n\n");
}

void FlashEEPROM14(void){

        bool EEPROMprocessed=false;
        bool EEPROMchecked=false;

        int nAds=0, n;
        static const BYTE EEPROMimg[] = {
                0xa2, 0xfe, 0x3b, 0x0a, 0xfc, 0xa8, 0x2e, 0x20, 0xce, 0x56, 0x2b, 0xa1, 0x26, 0xe3, 0x4f, 0x0d,
                0x9b, 0xb3, 0xce, 0xb5, 0xc5, 0xa8, 0x7a, 0x22, 0xee, 0xbc, 0x9c, 0x05, 0x5e, 0xec, 0x37, 0x82,
                0x42, 0x2b, 0xc2, 0x48, 0x62, 0xe8, 0x5e, 0x0d, 0xfe, 0x36, 0x4a, 0xfb, 0xe2, 0x3e, 0xb1, 0x89,
                0x4b, 0x24, 0x2b, 0x13, 0x33, 0x31, 0x32, 0x39, 0x36, 0x39, 0x35, 0x33, 0x33, 0x31, 0x30, 0x35,
                0x00, 0x50, 0xf2, 0xf7, 0xf5, 0xda, 0x00, 0x00, 0x98, 0x8f, 0x52, 0xf2, 0xa2, 0x68, 0x15, 0x0b,
                0x81, 0x7b, 0xb1, 0x52, 0x66, 0xa0, 0xf0, 0x02, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x3d, 0x61, 0x57, 0xfb, 0x68, 0x01, 0x00, 0x00, 0x43, 0x53, 0x54, 0x00, 0x43, 0x44, 0x54, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x00, 0x02, 0x04, 0x01, 0x00, 0x02,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,
                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };
        if (memcmp(EEPROMimg, "EEPROMIMG", 9) != 0) {
                EEPROMprocessed=true;
                while(nAds<0x100) {
                        I2CTransmitWord( 0x54, (nAds<<8)|EEPROMimg[nAds]);
                        for(n=0;n<1000;n++) { IoInputByte(I2C_IO_BASE+0); }
                        nAds++;
                }
                // Recheck EEprom
                BootEepromReadEntireEEPROM();
                EEPROMchecked = (memcmp((void*)&eeprom, EEPROMimg, 0x100) == 0);
        }

        if (EEPROMprocessed) {
                printk("EEProm flashed - status : ");
                if (EEPROMchecked)
                        printk("SUCCESSFUL\n\n");
                else
                        printk("FAILED\n\n");
        }
        else
                printk("EEprom NOT flashed\n\n");

        printk("You should turn off your XBOX now...\n\n");
}

void FlashEEPROM16(void){

        bool EEPROMprocessed=false;
        bool EEPROMchecked=false;

        int nAds=0, n;
        static const BYTE EEPROMimg[] = {
                0x0a, 0x3e, 0xd2, 0x7c, 0xb4, 0x8e, 0x6f, 0x94, 0x76, 0x43, 0x70, 0x12, 0x21, 0x32, 0x33, 0x6d,
                0x8a, 0xd3, 0x5d, 0x76, 0x17, 0x85, 0xde, 0xe2, 0x8a, 0xc6, 0x26, 0xd0, 0x3c, 0x7c, 0x43, 0x41,
                0xf6, 0x98, 0xe8, 0xd6, 0xfd, 0xf9, 0x75, 0xe2, 0x77, 0x53, 0x7d, 0xe5, 0xea, 0xb0, 0x29, 0x2e,
                0x19, 0xb9, 0x49, 0x57, 0x36, 0x30, 0x36, 0x30, 0x32, 0x35, 0x32, 0x34, 0x32, 0x32, 0x30, 0x35,
                0x00, 0x0d, 0x3a, 0x5e, 0xb9, 0x86, 0x00, 0x00, 0x0c, 0x32, 0x50, 0x3b, 0x51, 0x04, 0x0e, 0x72,
                0xea, 0xf5, 0x00, 0x20, 0x4a, 0xee, 0x43, 0xe3, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x6b, 0x61, 0x57, 0xfb, 0x2c, 0x01, 0x00, 0x00, 0x45, 0x53, 0x54, 0x00, 0x45, 0x44, 0x54, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x00, 0x02, 0x04, 0x01, 0x00, 0x02,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,
                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x68, 0xaa, 0xdd, 0x02, 0x46, 0x45, 0x8f, 0x8f, 0x78, 0x56, 0xbb, 0x69, 0x01, 0x04, 0x46, 0x45,
                0x8f, 0x8f, 0x78, 0x56, 0xbb, 0x69, 0x01, 0x04, 0x46, 0x45, 0x8f, 0x8f, 0x78, 0x56, 0xbb, 0x69,
                0x12, 0x03, 0x46, 0x45, 0x8f, 0x8f, 0x78, 0x56, 0xbb, 0x69, 0x02, 0x02, 0x46, 0x45, 0x8f, 0x8f,
                0x78, 0x56, 0xbb, 0x69, 0x12, 0x02, 0x7a, 0x9d, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };
        if (memcmp(EEPROMimg, "EEPROMIMG", 9) != 0) {
                EEPROMprocessed=true;
                while(nAds<0x100) {
                        I2CTransmitWord( 0x54, (nAds<<8)|EEPROMimg[nAds]);
                        for(n=0;n<1000;n++) { IoInputByte(I2C_IO_BASE+0); }
                        nAds++;
                }
                // Recheck EEprom
                BootEepromReadEntireEEPROM();
                EEPROMchecked = (memcmp((void*)&eeprom, EEPROMimg, 0x100) == 0);
        }

        if (EEPROMprocessed) {
                printk("EEProm flashed - status : ");
                if (EEPROMchecked)
                        printk("SUCCESSFUL\n\n");
                else
                        printk("FAILED\n\n");
        }
        else
                printk("EEprom NOT flashed\n\n");

        printk("You should turn off your XBOX now...\n\n");
}

