//-----------------------------------------------------------------------------
// File: Keyboard.h
//
// Desc: Handles debug keyboard.
//
// Hist: 06.11.01 - Created
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------
#ifndef KEYBOARD_H
#define KEYBOARD_H


// Keyboard command button values
#define KEY_BACKSPACE       8
#define KEY_TAB             9
#define KEY_RETURN          10
#define KEY_ENTER           13
#define KEY_ESC             27
#define KEY_PGUP            33
#define KEY_PGDN            34
#define KEY_END             35
#define KEY_HOME            36
#define KEY_LEFT            37
#define KEY_UP              38
#define KEY_RIGHT           39
#define KEY_DOWN            40
#define KEY_DELETE          46
#define KEY_F2              113

typedef struct _X_KEYSTROKE
{
    BYTE VirtualKey;
    CHAR Ascii;
    BYTE Flags;
} X_KEYSTROKE;

//-----------------------------------------------------------------------------
// Name: XBInput_InitDebugKeyboard()
// Desc: Initialise Debug Keyboard for use
//-----------------------------------------------------------------------------
HRESULT XBInput_InitDebugKeyboard();


//-----------------------------------------------------------------------------
// Name: XBInput_GetKeyboardInput()
// Desc: Processes input from a debug keyboard
//-----------------------------------------------------------------------------
X_KEYSTROKE XBInput_GetKeyboardInput();


#endif
