#include "KeyPadWindow.h"
#include "Resource.h"
#include <string>

CXKeyPadWindow::CXKeyPadWindow(CXxPad *_parent, FLOAT _top, FLOAT _left, DWORD _outlinecolour, DWORD _innercolour, DWORD _fontcolour)
{
  keyPadMode = MODE_LOWER;
	parent = _parent;
	top = _top;
	left = _left;
	outlinecolour = _outlinecolour;
	innercolor = _innercolour;
	fontcolour = _fontcolour;

  lowercase = "0123456789abcdefghijklmnopqrstuvwxyz";
  uppercase = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  specchars = "!@#$%^&*  (){}[]-_=+\\|;':\",.<>/?  ";
  

  curChar = 'e';    // will get set by first draw call anyway
  if (parent->controlMode == CONTROL_LEFTSTICK)
    controlMode = CONTROL_DPAD;
  if (parent->controlMode == CONTROL_DPAD)
    controlMode = CONTROL_LEFTSTICK;
  lastKPx = 0;
  lastKPy = 0;
}

HRESULT CXKeyPadWindow::Initialize()
{
  return S_OK;
}

HRESULT CXKeyPadWindow::Render(FLOAT kpX, FLOAT kpY)
{
  left = kpX;
  top = kpY;

  // Render virtual keyboard window
  parent->DrawRectWithBorder( left, top, left + 130, top + 105, innercolor, innercolor, outlinecolour);

	// Render our line selector
	Draw(lastKPx, lastKPy);

  parent->m_Font.DrawText( left + 5, top + 5, 0xfffff600, L"Keypad");
  
  if (keyPadMode == MODE_LOWER)
		parent->m_editFont.DrawText( left + 5, top + 35, fontcolour, L"0123456789\nabcdefghij\nklmnopqrst\nuvwxyz");
  if (keyPadMode == MODE_UPPER)
		parent->m_editFont.DrawText( left + 5, top + 35, fontcolour, L"0123456789\nABCDEFGHIJ\nKLMNOPQRST\nUVWXYZ");
  if (keyPadMode == MODE_CHARS)
		parent->m_editFont.DrawText( left + 5, top + 35, fontcolour, L"!@#$%^&*  \n(){}[]-_=+\n\\|;':\",.<>\n/?  ");


  return S_OK;
}

HRESULT CXKeyPadWindow::Cleanup()
{
  return S_OK;
}

HRESULT CXKeyPadWindow::FrameMove()
{
  // Check for control Modes to determine how were are doing character selection.
  switch (controlMode)
  {
    case CONTROL_LEFTSTICK:
    {
      lastKPx = parent->GetGamePad()->fX1;
      lastKPy = -parent->GetGamePad()->fY1;
      break;
    }
    case CONTROL_DPAD:
    {
      if( parent->GetGamePad()->wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
        lastKPx -= 1;
      if( parent->GetGamePad()->wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
        lastKPx += 1;
      if( parent->GetGamePad()->wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
        lastKPy -= 1;
      if( parent->GetGamePad()->wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
        lastKPy += 1;

      lastKPx=max(lastKPx,-4);
      lastKPx=min(lastKPx,5);
      lastKPy=max(lastKPy,-1);
      lastKPy=min(lastKPy,2);

      break;
    }
  }

  
  // Check for Y button to change character modes.
  if( parent->GetGamePad()->bPressedAnalogButtons[XINPUT_GAMEPAD_Y] )
  {
    switch (keyPadMode)
		{
			case MODE_LOWER:
			{
				keyPadMode = MODE_UPPER;
				break;
			}
			case MODE_UPPER:
			{
				keyPadMode = MODE_CHARS;
				break;
			}
			case MODE_CHARS:
			{
				keyPadMode = MODE_LOWER;
				break;
			}
		}
  }

  return S_OK;
}

void CXKeyPadWindow::DrawBox(float x, float y, int g1, int g2)
{
	parent->DrawRect(x, y, x+12, y+18, g1, g2);
}

void CXKeyPadWindow::Draw(double x, double y)
{
  const float sx = 6;
  const float sy = 4.0f;
  const float cx = left + 54;
  const float cy = top + 50;

  int charx = 0;
  int chary = 0;

  switch (controlMode)
  {
    case CONTROL_LEFTSTICK:
    {
      charx = (int)(x * sx);
      chary = (int)(y * sy);
      break;
    }
    case CONTROL_DPAD:
    {
      charx = (int)lastKPx;
      chary = (int)lastKPy;
      break;
    }
  }

  
  charx=max(charx,-4);
  charx=min(charx,5);

  chary=max(chary,-1);
  chary=min(chary,2);

  RefreshCurChar(charx, chary);

  // Set the current char...
  if (keyPadMode == MODE_LOWER)
		parent->m_editFont.DrawText( left + 5, top + 35, fontcolour, L"0123456789\nabcdefghij\nklmnopqrst\nuvwxyz");
  if (keyPadMode == MODE_UPPER)
		parent->m_editFont.DrawText( left + 5, top + 35, fontcolour, L"0123456789\nABCDEFGHIJ\nKLMNOPQRST\nUVWXYZ");
  if (keyPadMode == MODE_CHARS)
		parent->m_editFont.DrawText( left + 5, top + 35, fontcolour, L"!@#$%^&*  \n(){}[]-_=+\n\\|;':\",.<>\n/?  ");


  DrawBox(cx + charx * 12, cy + chary * 18, 0xff000000 , 0xff000000);
  //DrawBox(cx + ((x * sx) * 12), cy + ((y * sy) * 18), DEBUG_SEMITRANS_BLUE , DEBUG_SEMITRANS_BLUE);

}

void CXKeyPadWindow::RefreshCurChar(int charx, int chary)
{
  // Normalize the values
  charx+= 4;
  chary+= 1;

  unsigned int curCharIndex = 0;

  // Get the character index into the array
  curCharIndex = (chary * 10) + charx;

  if (keyPadMode == MODE_LOWER)
  {
    if (curCharIndex < lowercase.length())
      curChar = lowercase[curCharIndex];
    else
      curChar = ' ';
  }
  if (keyPadMode == MODE_UPPER)
  {
    if (curCharIndex < lowercase.length())
      curChar = uppercase[curCharIndex];
    else
      curChar = ' ';
  }
  if (keyPadMode == MODE_CHARS)
  {
    if (curCharIndex < lowercase.length())
      curChar = specchars[curCharIndex];
    else
      curChar = ' ';
  }

}