#include "SettingsWindow.h"
#include "Resource.h"
#include "Keyboard.h"
#include <string>

CXSettingsWindow::CXSettingsWindow(CXxPad *_parent)
{
  parent = _parent;
}

HRESULT CXSettingsWindow::Initialize()
{
  // Create texture for the image to persist
  m_pMainWindow = NULL;
  m_pMainWindow = parent->m_xprResource.GetTexture( resource_Settings_OFFSET );

  ResetSettings();
  return S_OK;
}

HRESULT CXSettingsWindow::Render()
{
  float curBottomWarpVal;
  float curTopWarpVal;
  float curAlphaVal;
  float modValue;
  const float windowExpand = 0.6f;
  const float animSpeed = 0.05f;

  /*D3DXVECTOR4 rect (106, 116, 522, 396);
  parent->RenderImage (rect, m_pMainWindow, 1.0f, curTopWarpVal, curBottomWarpVal);
  
  if (opening)
  {
    curBottomWarpVal -= 4.0f;
    curTopWarpVal -= 4.0f;
    curBottomWarpVal = max(curBottomWarpVal, 0.0f);
    curTopWarpVal = max(curTopWarpVal, 0.0f);
  }
  else
  {
    curBottomWarpVal += 4.0f;
    curTopWarpVal += 4.0f;
    curBottomWarpVal = min(curBottomWarpVal, 200.0f);
    curTopWarpVal = min(curTopWarpVal, 100.0f);
    if (curBottomWarpVal == 200.0f && curTopWarpVal == 100.0f)
    {
      parent->curMode = parent->MODE_NORMAL;
      if (strlen(fileToOpen) != 0)
        parent->OpenFile(fileToOpen);
      parent->ResetMenuSystem();
    }
  }*/

  if (opening)
  {
    windowOpenAmount += animSpeed;
    windowOpenAmount = min(windowOpenAmount, 1.0f);
  }
  else
  {
    windowOpenAmount -= animSpeed;
    windowOpenAmount = max(windowOpenAmount, 0.0f);
    if (windowOpenAmount == 0.0f)
    {
      parent->curMode = parent->MODE_NORMAL;
      parent->ResetMenuSystem();
    }
  }
  modValue = min(windowOpenAmount, windowExpand) * (1.0f / windowExpand);
  curBottomWarpVal = 200.0f - (200.0f * modValue);
  curTopWarpVal = 100.0f - (100.0f * modValue);
  curAlphaVal = 0.9f * windowOpenAmount;

  D3DXVECTOR4 rect (106, 116, 522, 396);
  parent->RenderImage (rect, m_pMainWindow, curAlphaVal, curTopWarpVal, curBottomWarpVal);
  
  if ((curBottomWarpVal == 0.0f && curTopWarpVal == 0.0f))
  {

  }  
  return S_OK;
}

HRESULT CXSettingsWindow::Cleanup()
{
  return S_OK;
}

HRESULT CXSettingsWindow::FrameMove()
{
  if( parent->GetGamePad()->bPressedAnalogButtons[XINPUT_GAMEPAD_B] || parent->GetGamePad()->wPressedButtons & XINPUT_GAMEPAD_BACK || parent->lastKBChar == KEY_ESC)
  {
    //parent->curMode = parent->Mode::MODE_NORMAL;
    //parent->ResetMenuSystem();
    opening = false;
  }
  

  return S_OK;
}


void CXSettingsWindow::ResetSettings()
{
  windowOpenAmount = 0.0f;
  opening = true;
}
