#ifndef __FILEBROWSER_H
#define __FILEBROWSER_H

#include <XBApp.h>
#include <XbResource.h>
#include <XBFont.h>
#include <vector>
  
#include "xPad.h"

class CXxPad;

using namespace std;

class CXFileBrowser
{

  enum BrowseModes
  {
    MODE_FILE,
    MODE_DRIVE,
    MODE_FILENAME
  };

  struct FILELISTING
  {
    char strPath[MAX_PATH];
    bool isDirectory; 
  };

public:
  CXFileBrowser(CXxPad *_parent);
  HRESULT Initialize();
  HRESULT Render();
  HRESULT Cleanup();
  HRESULT FrameMove();
  void ResetBrowser();

private:
  void AddToSearch(char strFind[MAX_PATH]);
  void ReadFileListing();
  void InsertCharacterFromKeypad(); 
  void InsertStringAtCursor(string stringToInsert);
  void DeleteCharactersAtCursor(int count);
  void ProcessKeyboard();


  LPDIRECT3DTEXTURE8  m_pMainWindow;
  CXxPad *parent;

  BrowseModes BrowseMode;
  int curFileLine;
  int curFilePage;
  int curSelDrive;
  int curCol;
  CHAR lastKBChar;

  char curDrive;
  char curPath[MAX_PATH];
  char selFilename[MAX_PATH];
  bool ignoreInput;
  typedef vector<FILELISTING> fileItem; 
  fileItem fileItems;

  float windowOpenAmount;
  bool opening;
  char fileToOpen[MAX_PATH];


  void MoveCursorToStartOfLine();
  void MoveCursorToEndOfLine();
  
  bool holdingADown;
  bool BeginButtonARepeat();
  bool holdingXDown;
  bool BeginButtonXRepeat();

  void MoveCursorUp(int count = 1);
  bool movingUp;
  bool BeginCursorUpRepeat();

  void MoveCursorDown(int count = 1);
  bool movingDown;
  bool BeginCursorDownRepeat();

  void MoveCursorLeft(int count = 1);
  bool movingLeft;
  bool BeginCursorLeftRepeat();

  void MoveCursorRight(int count = 1);
  bool movingRight;
  bool BeginCursorRightRepeat();


};

#endif  //__FILEBROWSER_H