
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <XBApp.h>
#include <XBFont.h>
#include <XBMesh.h>
#include <XBResource.h>
#include <XBHelp.h>
#include <XBUtil.h>

#include "debug.h"
#include "menu.h"
#include "xbcopy.h"

typedef struct _UNICODE_STRING {
USHORT Length;
USHORT MaximumLength;
PSTR  Buffer;
} UNICODE_STRING, *PUNICODE_STRING;

#define IN

extern "C" XBOXAPI DWORD WINAPI IoCreateSymbolicLink(IN PUNICODE_STRING SymbolicLinkName,IN PUNICODE_STRING DeviceName);
extern "C" XBOXAPI DWORD WINAPI IoDeleteSymbolicLink(IN PUNICODE_STRING SymbolicLinkName);

#define DriveD "\\??\\D:"
#define CdRom "\\Device\\Cdrom0"
UNICODE_STRING DDeviceName = { strlen(CdRom), strlen(CdRom)+1, CdRom };
UNICODE_STRING DSymbolicLinkName = { strlen(DriveD), strlen(DriveD)+1, DriveD };

#define DriveC "\\??\\C:"
#define DeviceC "\\Device\\Harddisk0\\Partition1"
UNICODE_STRING CDeviceName = {strlen(DeviceC), strlen(DeviceC)+1, DeviceC };
UNICODE_STRING CSymbolicLinkName = { strlen(DriveC), strlen(DriveC)+1, DriveC };

#define DriveE "\\??\\E:"
#define DeviceE "\\Device\\Harddisk0\\Partition1"
UNICODE_STRING EDeviceName = { strlen(DeviceE) , strlen(DeviceE)+1, DeviceE};
UNICODE_STRING ESymbolicLinkName = { strlen(DriveE), strlen(DriveE)+1, DriveE };

#define DriveF "\\??\\F:"
#define DeviceF "\\Device\\Harddisk0\\Partition6"
UNICODE_STRING FDeviceName = { strlen(DeviceF) , strlen(DeviceF)+1, DeviceF};
UNICODE_STRING FSymbolicLinkName = { strlen(DriveF), strlen(DriveF)+1, DriveF };


#define MENU_E			0
#define MENU_F			1

MENUENTRY config_menu[]=
{
    { 100.0,120.0, L"Save to E Drive (Xbox Saves)", true , false , MENU_E },
    { 100.0,140.0, L"Save to F Drive (Expansion)" , true , false , MENU_F },
    { 000.0,000.0, NULL                           , false, false, 0 },
};


//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXBCopy xbApp;
    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}

CXBCopy::CXBCopy()
            :CXBApplication()
{
}



HRESULT CXBCopy::Initialize()
{
	// Minum work before any activity
	mpDebug = new CXBoxDebug(40.0,80.0);

	mFont.Create(m_pd3dDevice, "font.xpr");

	// Pretty Blue background
	RenderGradientBackground(0xff404040, 0xff4040C0);
	m_pd3dDevice->Present(NULL,NULL,NULL,NULL);

	StartUpMessage();

	// Create the menu object
	mpMenu = new CXBoxMenu(NULL,NULL,mFont);
	mpMenu->SetMenuStruct(config_menu);

	mCounter=0;
	mFileCount=0;
	mDirCount=0;

	// Remap the CDROM, map E & F Drives
	IoDeleteSymbolicLink(&DSymbolicLinkName);
	IoCreateSymbolicLink(&DSymbolicLinkName, &DDeviceName);
	IoCreateSymbolicLink(&ESymbolicLinkName, &EDeviceName);
	IoCreateSymbolicLink(&FSymbolicLinkName, &FDeviceName);

	strcpy(mDestPath,"f:\\");
	
	return S_OK;
}


void CXBCopy::StartUpMessage(void)
{
	// Startup messages
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"Welcome to XBCopy");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING");
	mpDebug->Message(L"");
	mpDebug->Message(L" ****** DO NOT SWITCH OFF YOUR XBOX DURING THE FILE COPY ******");
	mpDebug->Message(L"");
	mpDebug->Message(L"WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"");
	mpDebug->Message(L"Press <START> dump DVD/CD to Disk.");
}


HRESULT CXBCopy::FrameMove()
{
	static DWORD loop=0;
	switch(mCounter)
	{
		case 0:
			if((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START))
			{
				mCounter++;
			}
			break;
		case 1:
			mpMenu->ProcessMenu(m_DefaultGamepad);
			if((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START))
			{
				if(mpMenu->GetSelected()==MENU_E)
				{
					strcpy(mDestPath,"e:\\");
					strcat(mDestPath,GetNextPath(mDestPath));
					mCounter++;
				}
				if(mpMenu->GetSelected()==MENU_F)
				{
					strcpy(mDestPath,"f:\\");
					strcat(mDestPath,GetNextPath(mDestPath));
					mCounter++;
				}
			}
			break;
			// Get dest Path
		case 2:
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L" ****** COPYING FILES NOW, DO NOT SWITCH OFF YOUR XBOX ******");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING");
			mpDebug->MessageInstant(L"");
			mpDebug->MessageInstant(L"");
//			ResetAttributes("f:\\Junk\\");

			DumpDVDtoHD("d:\\",mDestPath);
			mpDebug->MessageInstant(L"Finished.");
			mpDebug->MessageInstant(L"Please switch off, or press LEFT+RIGHT+BLACK for dashboard");
			mCounter++;
			break;
		default:
			break;

			
	}
	return S_OK;
}

HRESULT CXBCopy::Render()
{
	RenderGradientBackground(0xff404040, 0xff4040C0);
	if(mCounter==1)
	{
		mpMenu->RenderMenu();
	}
	else
	{
		mpDebug->Display();
	}
	m_pd3dDevice->Present(NULL,NULL,NULL,NULL);
	return S_OK;
}

HRESULT CXBCopy::Cleanup()
{
	return S_OK;
}

bool CXBCopy::DumpDVDtoHD(char *path,char *destroot)
{
	char sourcesearch[1024]="";
	char sourcefile[1024]="";
	char destfile[1024]="";
	WIN32_FIND_DATA wfd;
	HANDLE hFind;


	// We must create the dest directory
	if(CreateDirectory(destroot,NULL))
	{
		if(mpDebug) mpDebug->MessageInstant(L"XBCopy() - Created Directory: %hs",destroot);
	}

	strcpy(sourcesearch,path);
	strcat(sourcesearch,"*");

	// Start the find and check for failure.
	hFind = FindFirstFile( sourcesearch, &wfd );

	if( INVALID_HANDLE_VALUE == hFind )
	{
	    if(mpDebug) mpDebug->MessageInstant(L"XBCopy() - SetDirectory FindFirstFile returned invalid HANDLE");
	    return false;
	}
	else
	{
	    // Display each file and ask for the next.
	    do
	    {
			strcpy(sourcefile,path);
			strcat(sourcefile,wfd.cFileName);

			strcpy(destfile,destroot);
			strcat(destfile,wfd.cFileName);

			// Only do files
			if(wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
			{
				strcat(sourcefile,"\\");
				strcat(destfile,"\\");
				mDirCount++;
				// Recursion
				if(!DumpDVDtoHD(sourcefile,destfile)) return false;
			}
			else
			{
				if(mpDebug) mpDebug->MessageInstant(L"XBCopy() - Copying: %hs",wfd.cFileName);
				if(!CopyFile(sourcefile,destfile,0))
				{
				    if(mpDebug) mpDebug->MessageInstant(L"XBCopy() - Failed to copy %hs to %hs",sourcefile,destfile);
					return false;
				}
				SetFileAttributes(destfile,FILE_ATTRIBUTE_NORMAL);
				mFileCount++;
			}

	    }
	    while(FindNextFile( hFind, &wfd ));

	    // Close the find handle.
	    FindClose( hFind );
	}
	return true;
}

char* CXBCopy::GetNextPath(char *drive)
{
	static char testname[1024];
	char drivepath[1024];
	int count=0;
	WIN32_FIND_DATA wfd;
	HANDLE hFind;
	boolean GoodOne=true;

	strcpy(drivepath,drive);
	strcat(drivepath,"*");

	while(count<=999)
	{
		sprintf(testname,"XBCopy%03d",count);
		GoodOne=true;

		// Start the find and check for failure.
		hFind = FindFirstFile(drivepath, &wfd );

		// See if this exists in the directory
	    do
	    {
			// Only do directories
			if(wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY && strcmp(wfd.cFileName,testname)==0)
			{
				GoodOne=false;
				break;
			}
	    }
	    while(FindNextFile( hFind, &wfd ));
	    // Close the find handle.
	    FindClose( hFind );

		if(GoodOne) break;
		count++;
	}
	strcat(testname,"\\");

	return testname;

}

bool CXBCopy::ResetAttributes(char *path)
{
	char sourcesearch[1024]="";
	char sourcefile[1024]="";
	WIN32_FIND_DATA wfd;
	HANDLE hFind;


	strcpy(sourcesearch,path);
	strcat(sourcesearch,"*");

	// Start the find and check for failure.
	hFind = FindFirstFile( sourcesearch, &wfd );

	if( INVALID_HANDLE_VALUE == hFind )
	{
	    if(mpDebug) mpDebug->MessageInstant(L"ResetAttr() - SetDirectory FindFirstFile returned invalid HANDLE");
	    return false;
	}
	else
	{
	    // Display each file and ask for the next.
	    do
	    {
			strcpy(sourcefile,path);
			strcat(sourcefile,wfd.cFileName);

			// Only do files
			if(wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
			{
				SetFileAttributes(sourcefile,FILE_ATTRIBUTE_NORMAL);
				strcat(sourcefile,"\\");
				// Recursion
				if(!ResetAttributes(sourcefile)) return false;
			}
			else
			{
				SetFileAttributes(sourcefile,FILE_ATTRIBUTE_NORMAL);
				if(mpDebug) mpDebug->MessageInstant(L"ResetAttr() - Reset: %hs",sourcefile);
			}

	    }
	    while(FindNextFile( hFind, &wfd ));

	    // Close the find handle.
	    FindClose( hFind );
	}
	return true;
}

