#ifndef _cfgparser_h_
#define _cfgparser_h_

#include "types.h"


#define CONFIG_FILE "backup.cfg"
#define CONFIG_FILE_BUFSIZE 4096


#define MAX_PATHNAME 256


typedef struct _CONFIGENTRY {
    unsigned int err_linenum;
    char path[MAX_PATHNAME];
    char log[MAX_PATHNAME];
    char primary_backup_dir[MAX_PATHNAME];
    char secondary_backup_dir[MAX_PATHNAME];
    unsigned long iso_slice_size;
} CONFIGENTRY, *LPCONFIGENTRY;


NTSTATUS cfgparser_get_config(CONFIGENTRY *entry);


#endif /* _cfgparser_h_ */
