/*
 * ldscript.ld
 * GNU LD script for XBE (Xbox executable) files.
 *
 * Copyright 2004 rmenhal
 *
 * Licensed under GNU General Public License version 2. See the file COPYING
 * for details.
 */

OUTPUT_FORMAT("binary");
OUTPUT_ARCH("i386");

BASE_ADDRESS = 0x10000;

SECTIONS {

	.headers ( BASE_ADDRESS ) : AT ( 0 ) {

		/* Image header */

		LONG( 0x48454258 );		/* XBE magic ("XBEH") */
		. = . + 0x100;			/* RSA signature */
		LONG( BASE_ADDRESS );		/* Base address */
		LONG( SIZEOF(.headers) );	/* Size reserved for headers */
		LONG( ADDR(.bss) + SIZEOF(.bss) ); /* Size of image */
		LONG( image_header_size );	/* Size for image header */
		LONG( 0x41b384e0 );		/* Time/date stamp */
		LONG( cert_header );		/* Certificate address */
		LONG( section_headers_size / 0x38 ); /* Number of sections */
		LONG( section_headers );		/* Section headers address */
		LONG( 0 );			/* Init flags */
		LONG( ( ( -1 - ABSOLUTE(boot) ) & 0xA8FC57AB ) + ( ABSOLUTE(boot) & ( -1 - 0xA8FC57AB ) ) ); /* Entry point address */
		LONG( 0 );			/* TLS address */
		LONG( 0 );			/* PE stack commit */
		LONG( 0 );			/* PE heap reserve */
		LONG( 0 );			/* PE heap commit */
		LONG( 0 );			/* PE base address */
		LONG( 0 );			/* PE size of image */
		LONG( 0 );			/* PE checksum */
		LONG( 0 );			/* PE time/date */
		LONG( debug_path );		/* Debug pathname address */
		LONG( debug_path );		/* Debug filename address */
		LONG( debug_unicode_path );	/* Debug unicode name address */
		LONG( ( ( -1 - kernel_thunk_table ) & 0x5B6D40B6 ) + ( kernel_thunk_table & ( -1 - 0x5B6D40B6 ) ) ); /* Kernel thunk table address */
		LONG( 0 );			/* Non-kernel import dir addx */
		LONG( 0 );			/* Number of library versions */
		LONG( 0 );			/* Library versions address */
		LONG( 0 );			/* Kernel library version addx */
		LONG( 0 );			/* XAPI library version addx */
		LONG( 0 );			/* Logo bitmap address */
		LONG( 0 );			/* Logo bitmap size */
		
		image_header_size = .;


		/* Certificate header */

		cert_header = ABSOLUTE(.);

		LONG( cert_header_size );	/* Certificate header size */
		LONG( 0x41b384e0 );		/* Time/date */
		LONG( 0 );			/* Title ID */
		SHORT( 0x49 ); SHORT( 0x53 ); SHORT( 0x4f ); SHORT( 0x20 ); 
		SHORT( 0x42 ); SHORT( 0x61 ); SHORT( 0x63 ); SHORT( 0x6b ); 
		SHORT( 0x75 ); SHORT( 0x70 ); SHORT( 0x20 ); SHORT( 0x55 ); 
		SHORT( 0x74 ); SHORT( 0x69 ); SHORT( 0x6c ); SHORT( 0x69 ); 
		SHORT( 0x74 ); SHORT( 0x79 ); SHORT( 0x00 ); SHORT( 0x00 ); 
		SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); 
		SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); 
		SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); 
		SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); 
		SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); SHORT( 0x00 ); 
		/* . = . + 0x50; */			/* Title name */
		. = . + 0x40;			/* Alternative title IDs */
		LONG( 0xC0FFFFFF );		/* Allowed media */
		LONG( 0x80000007 );		/* Game regions */
		LONG( 0xFFFFFFFF );		/* Game ratings */
		LONG( 0 );			/* Disk number */
		LONG( 0 );			/* Version */
		. = . + 0x10;			/* LAN key */
		. = . + 0x10;			/* Signature key */
		. = . + 0x100;			/* Alternative signature keys */

		cert_header_size = ABSOLUTE(.) - cert_header;


		/* Section headers */

		section_headers = ABSOLUTE(.);

		/* .text section */

		LONG( 0x7 );			/* Section flags */
		LONG( BASE_ADDRESS + LOADADDR(.text) ); /* Section virtual address */
		LONG( SIZEOF(.text) + SIZEOF(.data) + SIZEOF(.bss) ); /* Section virtual size */
		LONG( LOADADDR(.text) );		/* Section raw/file address */
		LONG( SIZEOF(.text) + SIZEOF(.data) ); /* Section raw/file size */
		LONG( text_section_name );	/* Section name address */
		LONG( 0 );			/* Section reference count */
		LONG( text_head_count );		/* Head shared page ref addx */
		LONG( text_tail_count );		/* Tail shared page ref addx */
		. = . + 20;			/* Section SHA-1 hash */

		section_headers_size = ABSOLUTE(.) - section_headers;
		

		text_section_name = ABSOLUTE(.);
		BYTE( 0x2E ); BYTE( 0x74 ); BYTE( 0x65 ); BYTE( 0x78 );
		BYTE( 0x74 ); BYTE( 0x00 ); BYTE( 0x00 ); BYTE( 0x00 );
		text_head_count = ABSOLUTE(.);
		LONG( 0 );
		text_tail_count = ABSOLUTE(.);
		LONG( 0 );


		debug_path = ABSOLUTE(.);
		. = . + 40;

		debug_unicode_path = ABSOLUTE(.);
		. = . + 40;

		. = 0x1000;
	}

	.text ( BASE_ADDRESS + SIZEOF(.headers) ) : AT ( SIZEOF(.headers) ) {
		*(.text);
		*(.rodata);
	}

	.data ( BASE_ADDRESS + LOADADDR(.text) + SIZEOF(.text) ) : AT ( LOADADDR(.text) + SIZEOF(.text) ) {
		*(.data);
	}

	.bss ( BASE_ADDRESS + LOADADDR(.data) + SIZEOF(.data) ) : AT ( LOADADDR(.data) + SIZEOF(.data) ) {
		*(COMMON)
	}
}
